/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SamlTokenFactory;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.http.AuthException;
import com.vmware.vim.sso.http.AuthVerifier;
import com.vmware.vim.sso.http.Request;
import com.vmware.vim.sso.http.impl.Requests;
import com.vmware.vim.sso.http.impl.Token;
import com.vmware.vim.sso.http.impl.TokenFormatter;
import java.io.IOException;
import java.security.cert.X509Certificate;

public final class AuthVerifierImpl
implements AuthVerifier {
    private final SamlTokenFactory _tokenFactory = new DefaultTokenFactory();
    private final X509Certificate[] _trustedRootCertificates;
    private final Requests _requests;
    private final int _clockToleranceSec;

    public AuthVerifierImpl(X509Certificate[] trustedRootCertificates, int clockToleranceSec, int maxRequestAgeSec) {
        assert (trustedRootCertificates != null && trustedRootCertificates.length > 0) : "No trusted STS certificates provided!";
        assert (clockToleranceSec >= 0) : "Must be a not negative integer!";
        assert (maxRequestAgeSec >= 0) : "Must be a not negative integer!";
        this._trustedRootCertificates = trustedRootCertificates;
        this._requests = new Requests(clockToleranceSec, maxRequestAgeSec);
        this._clockToleranceSec = clockToleranceSec;
    }

    @Override
    public SamlToken verifyToken(Request req, String[] tokenTxt) throws IOException {
        assert (req != null) : "HTTP request is a mandatory argument!";
        assert (tokenTxt != null && tokenTxt.length > 0) : "HTTP token is a mandatory argument!";
        Token token = TokenFormatter.newInstance().parse(tokenTxt);
        assert (token != null);
        SamlToken samlToken = this.validateSamlToken(token.samlToken());
        this._requests.onNewRequest(samlToken.getSubject(), token.nonce());
        token.checkBodyHash(req);
        token.checkSignature(req, samlToken.getConfirmationCertificate().getPublicKey());
        return samlToken;
    }

    private SamlToken validateSamlToken(String tokenTxt) {
        SamlToken samlToken;
        try {
            samlToken = this._tokenFactory.parseToken(tokenTxt, this._trustedRootCertificates, (long)this._clockToleranceSec);
        }
        catch (InvalidTokenException e) {
            throw new AuthException("The SAML token is invalid!", e);
        }
        if (samlToken.getConfirmationType() != ConfirmationType.HOLDER_OF_KEY) {
            throw new AuthException("The SAML token is of unsupported confirmation type!");
        }
        return samlToken;
    }
}

