/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.clientside.filter;

import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.merge.DefaultItemComparator;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.provider.util.filter.FilterEvaluator;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.provider.util.property.PropertyByNameBackedByResourceItem;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyValueByNameViaIndexMap;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class ClientSideFiltering
implements DataProvider {
    public static final Map<String, QuerySchema.PropertyInfo> VMOMI_CLIENT_SIDE_PROPS = ImmutableMap.builder().put((Object)"ClusterComputeResource/summary/numCpuCores", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.SHORT)).put((Object)"Datastore/alarmActionsEnabled", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"Datastore/capability/perFileThinProvisioningSupported", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"Datastore/host/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"Datastore/info/timestamp", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ID)).put((Object)"Datastore/info/freeSpace", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"Datastore/overallStatus", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"Datacenter/host/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"Datacenter/vm/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"Datacenter/alarmActionsEnabled", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"DistributedVirtualPortgroup/alarmActionsEnabled", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"DistributedVirtualPortgroup/config/numPorts", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"DistributedVirtualPortgroup/overallStatus", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"DistributedVirtualPortgroup/summary/ipPoolName", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"Folder/allNormalVMOrPrimaryFTVM/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"Folder/host/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"HostProfile/modifiedTime", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ID)).put((Object)"HostSystem/alarmActionsEnabled", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"HostSystem/capability/tpmSupported", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"HostSystem/hardware/cpuInfo/numCpuPackages", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.SHORT)).put((Object)"HostSystem/hardware/memorySize", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"HostSystem/summary/hardware/numNics", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"HostSystem/summary/overallStatus", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"HostSystem/summary/quickStats/uptime", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"Network/summary/ipPoolName", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"Network/vm/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"OpaqueNetwork/summary/ipPoolName", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"OpaqueNetwork/summary/opaqueNetworkId", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"OpaqueNetwork/summary/opaqueNetworkType", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"OpaqueNetwork/vm/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ResourcePool/config/cpuAllocation/reservation", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"ResourcePool/config/cpuAllocation/limit", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"ResourcePool/config/cpuAllocation/expandableReservation", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"ResourcePool/config/cpuAllocation/shares/level", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"ResourcePool/config/cpuAllocation/shares/shares", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ResourcePool/config/memoryAllocation/shares/level", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"ResourcePool/config/memoryAllocation/shares/shares", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ResourcePool/parentVApp", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ID)).put((Object)"StoragePod/alarmActionsEnabled", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"StoragePod/datastore/length", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"StoragePod/overallStatus", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"StoragePod/summary/capacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"StoragePod/summary/freeSpace", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"StoragePod/vmTemplateCount", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"VirtualMachine/alarmActionsEnabled", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"VirtualMachine/summary/config/annotation", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"VirtualMachine/summary/config/uuid", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"VirtualMachine/summary/overallStatus", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ENUM)).put((Object)"VirtualMachine/summary/quickStats/hostMemoryUsage", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"VirtualMachine/summary/quickStats/overallCpuUsage", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"VirtualMachine/summary/quickStats/uptimeSeconds", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"Datastore/specificType", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"Datastore/thinProvisioningSupported", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"HostSystem/memoryUsage", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"HostSystem/cpuUsage", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"HostSystem/pciPassthruSupported", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.BOOLEAN)).put((Object)"HostSystem/certificateValidTo", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ID)).put((Object)"StoragePod/capacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"StoragePod/free", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"VirtualMachine/guestMemoryPercentage", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"VirtualMachine/hostCpuUsage", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"VirtualMachine/hostMemoryUsage", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ClusterComputeResource/freeCpuCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ClusterComputeResource/totalCpuCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ClusterComputeResource/usedCpuCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ClusterComputeResource/freeMemoryCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ClusterComputeResource/totalMemoryCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ClusterComputeResource/usedMemoryCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.INT)).put((Object)"ClusterComputeResource/freeStorageCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"ClusterComputeResource/totalStorageCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).put((Object)"ClusterComputeResource/usedStorageCapacity", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.LONG)).build();
    public static final Map<String, QuerySchema.PropertyInfo> VAPI_CLIENT_SIDE_PROPS = ImmutableMap.builder().put((Object)"com.vmware.content.library.ItemModel/contentVersion", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"com.vmware.content.library.ItemModel/description", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).put((Object)"com.vmware.content.type.ovf.OvfTemplate/vmTemplate/osDescription", (Object)QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.STRING)).build();
    private final DataProvider _provider;
    private final Map<String, QuerySchema.PropertyInfo> _clientSideProps;
    private final QuerySchema _schema;

    public ClientSideFiltering(DataProvider provider, Map<String, QuerySchema.PropertyInfo> clientSideProps) {
        assert (provider != null);
        assert (clientSideProps != null);
        this._provider = provider;
        this._schema = provider.getSchema();
        this._clientSideProps = clientSideProps;
    }

    @Override
    public QuerySchema getSchema() {
        QuerySchema clientSideSchema = QuerySchema.forProperties(this._clientSideProps);
        return SchemaUtil.merge(this._schema, clientSideSchema);
    }

    @Override
    public ResultSet executeQuery(Query query) {
        if (!this.isClientSide(query)) {
            return this._provider.executeQuery(query);
        }
        ArrayList<PropertyPredicate> clientSidePredicates = new ArrayList<PropertyPredicate>();
        Filter newFilter = this.toExecutableFilter(query.getFilter(), clientSidePredicates);
        List<String> newSelect = ClientSideFiltering.toExecutableSelect(query.getProperties(), clientSidePredicates, query.getSortCriteria());
        Collection<String> resourceModels = query.getResourceModels();
        Query executableQuery = Query.Builder.select(newSelect).from(resourceModels).where(newFilter).build();
        ResultSet result = this._provider.executeQuery(executableQuery);
        ResultSet filteredResult = ClientSideFiltering.filterAtClientSide(result, query, clientSidePredicates);
        ResultSet pagedResult = ResultSetUtil.applyLimitAndOffset(filteredResult, query.getLimit(), query.getOffset());
        return ResultSetUtil.project(pagedResult, query.getProperties());
    }

    public String toString() {
        return this._provider.toString();
    }

    private boolean isClientSide(Query query) {
        if (query.getFilter() != null) {
            Filter filter = query.getFilter();
            for (PropertyPredicate predicate : filter.getCriteria()) {
                if (!this.isClientSide(predicate.getProperty())) continue;
                return true;
            }
        }
        for (SortCriterion sortCriterion : query.getSortCriteria()) {
            if (!this.isClientSide(sortCriterion.getProperty())) continue;
            return true;
        }
        return false;
    }

    private boolean isClientSide(String property) {
        if (!this._clientSideProps.containsKey(property)) {
            return false;
        }
        QuerySchema.PropertyInfo propertyInfo = SchemaUtil.getPropertyInfoForQualifiedName(this._schema, property);
        if (propertyInfo == null) {
            String msg = String.format("The property '%s' is listed for client-side handling, but it is not available on the server.", property);
            throw new IllegalArgumentException(msg);
        }
        return !propertyInfo.getFilterable();
    }

    private Filter toExecutableFilter(Filter filter, List<PropertyPredicate> clientSidePredicates) {
        if (filter == null) {
            return filter;
        }
        List<PropertyPredicate> predicates = filter.getCriteria();
        ArrayList<PropertyPredicate> serverSidePredicates = new ArrayList<PropertyPredicate>(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            if (this.isClientSide(predicate.getProperty())) {
                clientSidePredicates.add(predicate);
                continue;
            }
            serverSidePredicates.add(predicate);
        }
        if (clientSidePredicates.isEmpty()) {
            return filter;
        }
        if (serverSidePredicates.isEmpty()) {
            return null;
        }
        if (filter.getOperator().equals((Object)LogicalOperator.OR)) {
            clientSidePredicates.addAll(serverSidePredicates);
            return null;
        }
        return new Filter(serverSidePredicates, filter.getOperator());
    }

    private static List<String> toExecutableSelect(List<String> properties, List<PropertyPredicate> predicates, List<SortCriterion> sorts) {
        LinkedHashSet<String> newSelect = new LinkedHashSet<String>(properties);
        for (PropertyPredicate predicate : predicates) {
            newSelect.add(predicate.getProperty());
        }
        for (SortCriterion sort : sorts) {
            newSelect.add(sort.getProperty());
        }
        return new ArrayList<String>(newSelect);
    }

    private static ResultSet filterAtClientSide(ResultSet result, Query query, List<PropertyPredicate> clientSidePredicates) {
        Filter clientSideFilter = ClientSideFiltering.toFilter(query.getFilter(), clientSidePredicates);
        List<ResourceItem> filteredItems = ClientSideFiltering.filterAtClientSide(result.getProperties(), result.getItems(), clientSideFilter);
        List<ResourceItem> orderedItems = ClientSideFiltering.order(result.getProperties(), filteredItems, query.getSortCriteria());
        ResultSet.Builder resultBuilder = ResultSet.Builder.properties(result.getProperties());
        for (ResourceItem item : orderedItems) {
            resultBuilder.item(item.getKey(), item.getPropertyValues());
        }
        if (query.getWithTotalCount()) {
            resultBuilder.totalCount(orderedItems.size());
        }
        return resultBuilder.build();
    }

    private static List<ResourceItem> filterAtClientSide(List<String> properties, List<ResourceItem> items, Filter filter) {
        if (filter == null) {
            return items;
        }
        ArrayList<ResourceItem> filteredItems = new ArrayList<ResourceItem>();
        for (ResourceItem item : items) {
            if (!FilterEvaluator.eval(filter, ClientSideFiltering.toPropertyByName(item, properties))) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    private static List<ResourceItem> order(List<String> properties, List<ResourceItem> items, List<SortCriterion> sortCriteria) {
        if (sortCriteria.isEmpty()) {
            return items;
        }
        DefaultItemComparator comparator = new DefaultItemComparator(properties, sortCriteria);
        ArrayList<ResourceItem> orderedItems = new ArrayList<ResourceItem>(items);
        Collections.sort(orderedItems, comparator);
        return orderedItems;
    }

    private static Filter toFilter(Filter filter, List<PropertyPredicate> predicates) {
        if (filter == null) {
            return null;
        }
        if (predicates.isEmpty()) {
            return null;
        }
        return new Filter(predicates, filter.getOperator());
    }

    private static PropertyByName toPropertyByName(ResourceItem item, List<String> properties) {
        return new PropertyByNameBackedByResourceItem(item, new ResourceItemPropertyValueByNameViaIndexMap(properties));
    }
}

