/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.property;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.property.PropertyProviderMethod;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyProviderBeanDataProvider
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(PropertyProviderBeanDataProvider.class);
    private final Object _propertyProvider;
    private final Map<String, PropertyProviderMethod> _providerMethodByProperty;

    public static PropertyProviderBeanDataProvider toDataProvider(Object propertyProvider) {
        Validate.notNull((Object)propertyProvider);
        Collection<PropertyProviderMethod> propertyMethods = PropertyProviderMethod.forPropertyProvider(propertyProvider);
        if (propertyMethods.isEmpty()) {
            _logger.warn("Ignore property provider without property provider methods: {}", (Object)propertyProvider.getClass().getCanonicalName());
            return null;
        }
        HashMap<String, PropertyProviderMethod> providerMethodByProperty = new HashMap<String, PropertyProviderMethod>(propertyMethods.size());
        for (PropertyProviderMethod propertyMethod : propertyMethods) {
            providerMethodByProperty.put(propertyMethod.getPropertyName(), propertyMethod);
        }
        _logger.info("Loaded property provider '{}' for properties: {}", (Object)propertyProvider.getClass().getCanonicalName(), providerMethodByProperty.keySet());
        return new PropertyProviderBeanDataProvider(propertyProvider, providerMethodByProperty);
    }

    private PropertyProviderBeanDataProvider(Object propertyProvider, Map<String, PropertyProviderMethod> providerMethodByProperty) {
        assert (propertyProvider != null);
        assert (providerMethodByProperty != null);
        this._propertyProvider = propertyProvider;
        this._providerMethodByProperty = providerMethodByProperty;
    }

    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableSet(this._providerMethodByProperty.keySet());
    }

    @Override
    public ResultSet executeQuery(Query query) {
        _logger.trace("Query for property provider '{}': {}", (Object)this._propertyProvider.getClass().getSimpleName(), (Object)query);
        Validate.notNull((Object)query, (String)"Query must not be null");
        Validate.isTrue((!query.getWithTotalCount() ? 1 : 0) != 0, (String)"Total count is not supported");
        Validate.isTrue((!query.getProperties().isEmpty() ? 1 : 0) != 0, (String)"Query must request properties");
        Collection<?> keys = PropertyProviderBeanDataProvider.getKeys(query.getFilter());
        List<String> select = query.getProperties();
        ArrayList columns = new ArrayList(select.size());
        for (String property : select) {
            Collection<?> column = this.computeColumn(property, keys);
            columns.add(column);
        }
        ResultSet result = ResultSetUtil.toResult(keys, select, columns);
        _logger.trace("Result of query for property provider '{}': {}", (Object)this._propertyProvider.getClass().getSimpleName(), (Object)result);
        return result;
    }

    @Override
    public QuerySchema getSchema() {
        HashMap<String, QuerySchema.PropertyInfo> infoByProperty = new HashMap<String, QuerySchema.PropertyInfo>(this._providerMethodByProperty.size());
        for (String propertyName : this._providerMethodByProperty.keySet()) {
            infoByProperty.put(propertyName, QuerySchema.PropertyInfo.forNonFilterableProperty());
        }
        return QuerySchema.forProperties(infoByProperty);
    }

    public String toString() {
        return "PropertyProvider[" + this._propertyProvider.getClass().getCanonicalName() + "]";
    }

    static Collection<?> getKeys(Filter filter) {
        Validate.notNull((Object)filter, (String)"Filter must not be null");
        assert (!filter.getCriteria().isEmpty());
        Validate.isTrue((filter.getCriteria().size() == 1 ? 1 : 0) != 0, (String)"Filter must contain exactly one predicate");
        PropertyPredicate predicate = filter.getCriteria().get(0);
        Validate.isTrue((boolean)"@modelKey".equals(predicate.getProperty()), (String)("Cannot filter by property: " + predicate.getProperty()));
        Validate.isTrue((PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)predicate.getOperator()) || PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator()) ? 1 : 0) != 0, (String)("Invalid comparison operator: " + (Object)((Object)predicate.getOperator())));
        Object comparableValue = predicate.getComparableValue();
        if (comparableValue instanceof Collection) {
            return Collections.unmodifiableCollection((Collection)comparableValue);
        }
        return Collections.singletonList(comparableValue);
    }

    private Collection<?> computeColumn(String property, Collection<?> keys) {
        assert (property != null);
        assert (keys != null);
        assert (!keys.isEmpty());
        if ("@modelKey".equals(property)) {
            return keys;
        }
        Validate.isTrue((!PropertyUtil.isSpecialProperty(property) ? 1 : 0) != 0, (String)("Unsupported special property: " + property));
        PropertyProviderMethod propertyMethod = this._providerMethodByProperty.get(property);
        Validate.notNull((Object)propertyMethod, (String)("Could not find implementation for property: " + property));
        return propertyMethod.getPropertyValuesForKeys(keys);
    }
}

