/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ResultSetAnalyzer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public final class ResourceItemUtil {
    public static List<Object> compactResourceItemsValues(int propertyIndex, Collection<ResourceItem> resourceItems, boolean deduplicateValues) {
        assert (resourceItems != null);
        if (resourceItems.isEmpty()) {
            Collections.emptyList();
        }
        ArrayList<Object> compactedPropertyValues = new ArrayList<Object>();
        for (ResourceItem item : resourceItems) {
            Object propertyValue = item.getPropertyValues().get(propertyIndex);
            if (propertyValue == null) continue;
            if (propertyValue instanceof Object[]) {
                ResourceItemUtil.compactResourceItemValues(compactedPropertyValues, Arrays.asList((Object[])propertyValue), deduplicateValues);
                continue;
            }
            if (propertyValue instanceof Collection) {
                ResourceItemUtil.compactResourceItemValues(compactedPropertyValues, (Collection)propertyValue, deduplicateValues);
                continue;
            }
            compactedPropertyValues.add(propertyValue);
        }
        return compactedPropertyValues;
    }

    private static void compactResourceItemValues(List<Object> compactedPropertyValues, Collection<Object> propertyValues, boolean deduplicateValues) {
        if (deduplicateValues) {
            compactedPropertyValues.addAll(new LinkedHashSet<Object>(propertyValues));
        } else {
            compactedPropertyValues.addAll(propertyValues);
        }
    }

    public static List<Object> flattenNotNullPropertyValues(List<Object> propertyValues) {
        if (CollectionUtils.isEmpty(propertyValues)) {
            return Collections.emptyList();
        }
        LinkedHashSet<Object> flattenedPropertyValues = new LinkedHashSet<Object>();
        for (Object propertyValue : propertyValues) {
            if (propertyValue == null) continue;
            if (propertyValue instanceof Object[]) {
                flattenedPropertyValues.addAll(Arrays.asList((Object[])propertyValue));
                continue;
            }
            if (propertyValue instanceof Collection) {
                flattenedPropertyValues.addAll((Collection)propertyValue);
                continue;
            }
            flattenedPropertyValues.add(propertyValue);
        }
        return new ArrayList<Object>(flattenedPropertyValues);
    }

    public static List<ResourceItem> reorderResourceItems(List<ResourceItem> resourceItems, List<Integer> resourceItemsIndexPermutation) {
        assert (resourceItems != null);
        assert (resourceItemsIndexPermutation != null);
        if (resourceItems.isEmpty() || resourceItemsIndexPermutation.isEmpty()) {
            return resourceItems;
        }
        assert (resourceItems.size() == resourceItemsIndexPermutation.size());
        ResourceItem[] reorderedResourceItems = new ResourceItem[resourceItems.size()];
        for (int i = 0; i < resourceItems.size(); ++i) {
            reorderedResourceItems[i] = resourceItems.get(resourceItemsIndexPermutation.get(i));
        }
        return new ArrayList<ResourceItem>(Arrays.asList(reorderedResourceItems));
    }

    public static List<Integer> getResourceItemsPermutation(ResultSet leftResultSet, String leftJoinProperty, ResultSet rightResultSet, String rightJoinProperty, boolean notMappedItemsFirst) {
        assert (leftResultSet != null);
        assert (leftJoinProperty != null);
        assert (rightResultSet != null);
        assert (rightJoinProperty != null);
        if (leftResultSet.getItems().isEmpty() || rightResultSet.getItems().isEmpty()) {
            return Collections.emptyList();
        }
        int leftPropertyIndex = leftResultSet.getProperties().lastIndexOf(leftJoinProperty);
        if (leftPropertyIndex < 0) {
            throw new IllegalArgumentException(String.format("The given property [%s] is not among the result properties!", leftPropertyIndex));
        }
        Map<Object, Integer> rightItemIndexByPropertyValue = ResourceItemUtil.mapItemIndexByPropertyValue(rightResultSet, rightJoinProperty);
        HashMap<Integer, Integer> leftToRightIndexMapping = new HashMap<Integer, Integer>();
        int leftItemIndex = 0;
        for (ResourceItem leftItem : leftResultSet.getItems()) {
            Object leftPropertyValue = leftItem.getPropertyValues().get(leftPropertyIndex);
            if (leftPropertyValue instanceof Object[]) {
                for (Object propValue : (Object[])leftPropertyValue) {
                    ResourceItemUtil.mapLeftToRightIndex(propValue, leftItemIndex, rightItemIndexByPropertyValue, leftToRightIndexMapping);
                }
            } else if (leftPropertyValue instanceof Collection) {
                for (Object propValue : (Collection)leftPropertyValue) {
                    ResourceItemUtil.mapLeftToRightIndex(propValue, leftItemIndex, rightItemIndexByPropertyValue, leftToRightIndexMapping);
                }
            } else {
                ResourceItemUtil.mapLeftToRightIndex(leftPropertyValue, leftItemIndex, rightItemIndexByPropertyValue, leftToRightIndexMapping);
            }
            ++leftItemIndex;
        }
        return ResourceItemUtil.getResourceItemsPermutation(leftResultSet.getItems().size(), leftToRightIndexMapping, notMappedItemsFirst);
    }

    private static List<Integer> getResourceItemsPermutation(int itemsCount, Map<Integer, Integer> indexMapping, boolean notMappedItemsFirst) {
        assert (indexMapping != null);
        if (itemsCount <= 0 || indexMapping.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Integer, ArrayList<Integer>> itemsByNewIndex = new HashMap<Integer, ArrayList<Integer>>();
        int maxOrderIndex = -1;
        for (int i = 0; i < itemsCount; ++i) {
            Integer newOrderIndex = indexMapping.get(i);
            newOrderIndex = newOrderIndex == null ? -1 : newOrderIndex;
            maxOrderIndex = newOrderIndex > maxOrderIndex ? newOrderIndex : maxOrderIndex;
            ArrayList<Integer> itemsForIndex = (ArrayList<Integer>)itemsByNewIndex.get(newOrderIndex);
            if (itemsForIndex == null) {
                itemsForIndex = new ArrayList<Integer>();
                itemsByNewIndex.put(newOrderIndex, itemsForIndex);
            }
            itemsForIndex.add(i);
        }
        ArrayList<Integer> reorderedItemsIndices = new ArrayList<Integer>();
        for (int i = 0; i <= maxOrderIndex; ++i) {
            if (!itemsByNewIndex.containsKey(i)) continue;
            reorderedItemsIndices.addAll((Collection)itemsByNewIndex.get(i));
        }
        List notMappedItemsIndices = (List)itemsByNewIndex.get(-1);
        if (notMappedItemsIndices != null) {
            if (notMappedItemsFirst) {
                reorderedItemsIndices.addAll(0, notMappedItemsIndices);
            } else {
                reorderedItemsIndices.addAll(notMappedItemsIndices);
            }
        }
        return reorderedItemsIndices;
    }

    private static void mapLeftToRightIndex(Object leftPropertyValue, Integer leftItemIndex, Map<Object, Integer> rightItemIndexByPropertyValue, Map<Integer, Integer> leftToRightIndexMapping) {
        assert (rightItemIndexByPropertyValue != null);
        assert (leftItemIndex >= 0);
        if (leftPropertyValue == null || rightItemIndexByPropertyValue.isEmpty()) {
            return;
        }
        assert (leftToRightIndexMapping != null);
        Integer rightItemIndex = rightItemIndexByPropertyValue.get(leftPropertyValue);
        if (rightItemIndex != null) {
            leftToRightIndexMapping.put(leftItemIndex, rightItemIndex);
        }
    }

    private static Map<Object, Integer> mapItemIndexByPropertyValue(ResultSet result, String property) {
        assert (result != null);
        assert (property != null);
        if (result.getItems().isEmpty()) {
            return Collections.emptyMap();
        }
        int propertyIndex = result.getProperties().lastIndexOf(property);
        if (propertyIndex < 0) {
            throw new IllegalArgumentException(String.format("The given property [%s] is not among the result properties!", propertyIndex));
        }
        HashMap<Object, Integer> smallestItemIndexByPropertyValue = new HashMap<Object, Integer>();
        int itemIndex = 0;
        for (ResourceItem item : result.getItems()) {
            Object propertyValue = item.getPropertyValues().get(propertyIndex);
            if (propertyValue == null) continue;
            if (propertyValue instanceof Object[]) {
                for (Object propValue : (Object[])propertyValue) {
                    ResourceItemUtil.mapFirstItemIndexByPropertyValue(smallestItemIndexByPropertyValue, propValue, itemIndex);
                }
            } else if (propertyValue instanceof Collection) {
                for (Object propValue : (Collection)propertyValue) {
                    ResourceItemUtil.mapFirstItemIndexByPropertyValue(smallestItemIndexByPropertyValue, propValue, itemIndex);
                }
            } else {
                ResourceItemUtil.mapFirstItemIndexByPropertyValue(smallestItemIndexByPropertyValue, propertyValue, itemIndex);
            }
            ++itemIndex;
        }
        return smallestItemIndexByPropertyValue;
    }

    private static void mapFirstItemIndexByPropertyValue(Map<Object, Integer> smallestItemIndexByPropertyValue, Object propertyValue, Integer itemIndex) {
        if (propertyValue == null || smallestItemIndexByPropertyValue.containsKey(propertyValue)) {
            return;
        }
        smallestItemIndexByPropertyValue.put(propertyValue, itemIndex);
    }

    public static Map<Object, Collection<ResourceItem>> getResourceItemsByPropertyValue(int propertyIndex, ResultSet result) {
        assert (propertyIndex >= 0);
        assert (result != null);
        HashMap<Object, Collection<ResourceItem>> itemsByPropertyValue = new HashMap<Object, Collection<ResourceItem>>();
        List<Object> propertyValues = ResultSetAnalyzer.gatherPropertyValuesByIndexOrdered(result, propertyIndex);
        List<ResourceItem> resourceItems = result.getItems();
        assert (propertyValues.size() == resourceItems.size());
        int i = 0;
        for (Object propertyValue : propertyValues) {
            ResourceItemUtil.mapResourceItemByPropertyValue(itemsByPropertyValue, propertyValue, resourceItems.get(i++));
        }
        return itemsByPropertyValue;
    }

    private static void mapResourceItemByPropertyValue(Map<Object, Collection<ResourceItem>> itemsByPropertyValue, Object propertyValue, ResourceItem resourceItem) {
        if (propertyValue == null) {
            return;
        }
        assert (itemsByPropertyValue != null);
        assert (resourceItem != null);
        if (propertyValue instanceof Object[]) {
            for (Object propValue : (Object[])propertyValue) {
                ResourceItemUtil.mapItemByPropertyValue(itemsByPropertyValue, propValue, resourceItem);
            }
        } else if (propertyValue instanceof Collection) {
            for (Object propValue : (Collection)propertyValue) {
                ResourceItemUtil.mapItemByPropertyValue(itemsByPropertyValue, propValue, resourceItem);
            }
        } else {
            ResourceItemUtil.mapItemByPropertyValue(itemsByPropertyValue, propertyValue, resourceItem);
        }
    }

    private static void mapItemByPropertyValue(Map<Object, Collection<ResourceItem>> itemsByPropertyValue, Object propertyValue, ResourceItem resourceItem) {
        Collection<ResourceItem> resourceItemsForProperty = itemsByPropertyValue.get(propertyValue);
        if (resourceItemsForProperty == null) {
            resourceItemsForProperty = new ArrayList<ResourceItem>();
            itemsByPropertyValue.put(propertyValue, resourceItemsForProperty);
        }
        resourceItemsForProperty.add(resourceItem);
    }
}

