/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.internal.util.UnqualifiedProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class ContentLibraryQualifier {
    public static final char RESOURCE_MODEL_SEPARATOR = '/';
    private static final String LIBRARY_TYPE = "com.vmware.content.Library";
    private static final String LIBRARY_MODEL = "com.vmware.content.LibraryModel";
    private static final String ITEM_TYPE = "com.vmware.content.library.Item";
    private static final String ITEM_MODEL = "com.vmware.content.library.ItemModel";
    private static final String OVF_TEMPLATE_MODEL = "com.vmware.content.type.ovf.OvfTemplate";
    private static final String VM_TEMPLATE_ITEM_MODEL = "com.vmware.vcenter.vm_template.LibraryItems.Info";
    private static final Collection<String> ALL_LIBRARY_MODELS = Arrays.asList("com.vmware.content.Library", "com.vmware.content.LibraryModel");
    private static final Collection<String> ALL_ITEM_MODELS = Arrays.asList("com.vmware.content.library.Item", "com.vmware.content.library.ItemModel", "com.vmware.content.type.ovf.OvfTemplate", "com.vmware.vcenter.vm_template.LibraryItems.Info");
    private static final Collection<String> GENERIC_PROPERTIES = ImmutableList.builder().add((Object)"grantedPrivileges").add((Object)"systemPrivileges").add((Object)"entityPermission").add((Object)"rolesInfo").add((Object)"hasPrivileges").add((Object)"primaryIconId").add((Object)"labelIds").build();
    private static final Map<String, Collection<String>> NATIVE_MODEL_PROPERTIES_MAP = ContentLibraryQualifier.getNativeModelPropertiesMap();

    private ContentLibraryQualifier() {
    }

    public static String qualifyClProperty(String property, Collection<String> resourceModels) {
        Validate.isTrue((boolean)ContentLibraryQualifier.isClFromClause(resourceModels), (String)"The resource models collection should be valid from clause.");
        if (PropertyUtil.isSpecialProperty(property)) {
            return property;
        }
        for (String model : resourceModels) {
            if (!ContentLibraryQualifier.isQualified(property, model)) continue;
            return property;
        }
        String model = ContentLibraryQualifier.classifyClProperty(property, resourceModels);
        return QualifiedProperty.forModelAndSimpleProperty(model, property).toString();
    }

    public static String getClModel(String property, Collection<String> resourceModels) {
        Validate.isTrue((boolean)ContentLibraryQualifier.isClFromClause(resourceModels), (String)"The resource models collection should be valid from clause.");
        if (PropertyUtil.isSpecialProperty(property)) {
            return null;
        }
        for (String model : resourceModels) {
            if (!ContentLibraryQualifier.isQualified(property, model)) continue;
            return model;
        }
        String model = ContentLibraryQualifier.classifyClProperty(property, resourceModels);
        return model;
    }

    public static boolean isClModel(String resourceModel) {
        Validate.notNull((Object)resourceModel);
        return ALL_LIBRARY_MODELS.contains(resourceModel) || ALL_ITEM_MODELS.contains(resourceModel);
    }

    public static boolean isClType(String resourceModel) {
        Validate.notNull((Object)resourceModel);
        return LIBRARY_TYPE.equals(resourceModel) || ITEM_TYPE.equals(resourceModel);
    }

    public static boolean isClFromClause(Collection<String> resourceModels) {
        Validate.notEmpty(resourceModels);
        return ALL_LIBRARY_MODELS.containsAll(resourceModels) || ALL_ITEM_MODELS.containsAll(resourceModels);
    }

    private static String classifyClProperty(String propertyPath, Collection<String> resourceModels) {
        String primaryModel = null;
        String secondaryModel = null;
        for (String resourceModel : resourceModels) {
            if (LIBRARY_MODEL.equals(resourceModel) || ITEM_MODEL.equals(resourceModel)) {
                primaryModel = resourceModel;
                continue;
            }
            if (!ContentLibraryQualifier.isSupportedProperty(propertyPath, resourceModel)) continue;
            secondaryModel = resourceModel;
        }
        return secondaryModel == null ? primaryModel : secondaryModel;
    }

    private static boolean isSupportedProperty(String propertyPath, String model) {
        assert (propertyPath != null);
        assert (model != null);
        Collection<String> rootProperties = NATIVE_MODEL_PROPERTIES_MAP.get(model);
        if (rootProperties == null) {
            return false;
        }
        String rootProperty = UnqualifiedProperty.getRootProperty(propertyPath);
        return rootProperties.contains(rootProperty);
    }

    private static boolean isQualified(String property, String model) {
        assert (property != null);
        assert (model != null);
        return property.startsWith(model) && property.length() > model.length() && property.charAt(model.length()) == '/';
    }

    private static Map<String, Collection<String>> getNativeModelPropertiesMap() {
        return ImmutableMap.builder().put((Object)LIBRARY_TYPE, ContentLibraryQualifier.getNativeLibraryTypeProperties()).put((Object)ITEM_TYPE, ContentLibraryQualifier.getNativeItemTypeProperties()).put((Object)OVF_TEMPLATE_MODEL, ContentLibraryQualifier.getNativeOvfTemplateProperties()).put((Object)VM_TEMPLATE_ITEM_MODEL, ContentLibraryQualifier.getNativeVmTemplateItemProperties()).build();
    }

    private static Collection<String> getNativeLibraryTypeProperties() {
        return ImmutableList.builder().add((Object)"hasDeletePrivileges").addAll(GENERIC_PROPERTIES).build();
    }

    private static Collection<String> getNativeItemTypeProperties() {
        return ImmutableList.builder().add((Object)"files").add((Object)"contentLibraryIsoPath").add((Object)"contentLibraryFriendlyIsoPath").addAll(GENERIC_PROPERTIES).build();
    }

    private static Collection<String> getNativeOvfTemplateProperties() {
        return ImmutableList.builder().add((Object)"id").add((Object)"isVappTemplate").add((Object)"libraryIdParent").add((Object)"libraryItemGuestOs").add((Object)"networks").add((Object)"ovfTemplate").add((Object)"storagePolicyGroups").add((Object)"vappTemplate").add((Object)"version").add((Object)"vmCount").add((Object)"vmTemplate").build();
    }

    private static Collection<String> getNativeVmTemplateItemProperties() {
        return ImmutableList.builder().add((Object)"guestOS").add((Object)"cpu").add((Object)"memory").add((Object)"vmHomeStorage").add((Object)"disks").add((Object)"nics").add((Object)"nativeVmwareTemplate").build();
    }
}

