/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat.deserialization;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class RdfToJson {
    private static String FK_SUFFIX = "__FK";
    private static String ARRAY_SUFFIX = "__ARRAY";
    private final InputStream _rdf;

    public RdfToJson(InputStream rdf) {
        this._rdf = rdf;
    }

    private static String getId(Resource subject) {
        URI uri;
        String id = subject.toString();
        if (subject instanceof URI && (uri = (URI)subject).getNamespace().equals("cdf:id#")) {
            id = uri.getLocalName();
        }
        return id;
    }

    public void streamAll(JsonHandler handler) throws IOException, RDFParseException, RDFHandlerException {
        JsonOutput output = new JsonOutput(handler);
        RDFParser parser = Rio.createParser(RDFFormat.TURTLE);
        parser.getParserConfig().set(BasicParserSettings.VERIFY_URI_SYNTAX, false);
        parser.setRDFHandler(output);
        parser.parse(this._rdf, "<>");
    }

    public List<JSONObject> readAll() throws IOException, RDFParseException, RDFHandlerException {
        final ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
        this.streamAll(new JsonHandler(){

            @Override
            public void handle(JSONObject json) {
                ret.add(json);
            }
        });
        return ret;
    }

    public static void main(String[] args) throws Exception {
        RdfToJson rdf = new RdfToJson(new FileInputStream(args[0]));
        rdf.streamAll(new JsonHandler(){

            @Override
            public void handle(JSONObject json) {
                System.out.println(json.toString());
            }
        });
    }

    private static class JsonOutput
    extends RDFHandlerBase {
        private JSONObject _current;
        private JsonHandler _handler;

        public JsonOutput(JsonHandler handler) {
            this._handler = handler;
        }

        @Override
        public void handleStatement(Statement st) {
            URI predicate = st.getPredicate();
            if (RDF.FIRST.equals(predicate) || RDF.REST.equals(predicate)) {
                this._current = null;
                return;
            }
            if (RDF.TYPE.equals(predicate)) {
                JsonOutput.handleObject(this._handler, this._current);
                this._current = new JSONObject();
                this._current.put("@id", RdfToJson.getId(st.getSubject()));
                this._current.put("@type", ((URI)st.getObject()).getLocalName());
            } else {
                String key = predicate.getLocalName();
                Value val = st.getObject();
                if (val instanceof Literal) {
                    Literal literal = (Literal)val;
                    URI type = literal.getDatatype();
                    if (XMLDatatypeUtil.isDecimalDatatype(type)) {
                        this._current.put(key, literal.longValue());
                    } else if (XMLDatatypeUtil.isFloatingPointDatatype(type)) {
                        this._current.put(key, literal.doubleValue());
                    } else if (XMLDatatypeUtil.isCalendarDatatype(type)) {
                        this._current.put(key, literal.calendarValue().toGregorianCalendar().getTime());
                    } else if (XMLSchema.BOOLEAN.equals(type)) {
                        this._current.put(key, literal.booleanValue());
                    } else {
                        this._current.put(key, val.stringValue());
                    }
                } else if (val instanceof URI) {
                    this._current.put(key, ((URI)st.getObject()).getLocalName());
                }
            }
        }

        @Override
        public void endRDF() {
            JsonOutput.handleObject(this._handler, this._current);
        }

        private static void handleObject(JsonHandler handler, JSONObject json) {
            if (json == null) {
                return;
            }
            if (json.getString("@type").toUpperCase().endsWith(ARRAY_SUFFIX)) {
                String[] keys = JSONObject.getNames(json);
                ArrayList<String> fks = new ArrayList<String>();
                for (String key : keys) {
                    if (!key.toUpperCase().endsWith(FK_SUFFIX)) continue;
                    fks.add(key);
                }
                for (String key : keys) {
                    if (!key.toUpperCase().endsWith(ARRAY_SUFFIX)) continue;
                    String type = key.substring(0, key.length() - ARRAY_SUFFIX.length());
                    JSONArray array = new JSONArray(new JSONTokener(json.getString(key)));
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject tmp = array.getJSONObject(i);
                        tmp.put("@type", type);
                        for (String fk : fks) {
                            tmp.put(fk, json.getString(fk));
                        }
                        handler.handle(tmp);
                    }
                }
            } else {
                handler.handle(json);
            }
        }
    }

    public static interface JsonHandler {
        public void handle(JSONObject var1);
    }
}

