/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.impl;

import com.vmware.ph.client.api.PhClient;
import com.vmware.ph.client.api.commondataformat.Governed;
import com.vmware.ph.client.api.commondataformat.Id;
import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat.serialization.PayloadSerializer;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.CdfSequenceSerializerFactory;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.exceptions.AuditFileWritingFailedException;
import com.vmware.ph.client.api.exceptions.PhClientConnectionException;
import com.vmware.ph.client.api.exceptions.PhClientException;
import com.vmware.ph.client.api.impl.aggregation.Aggregator;
import com.vmware.ph.client.api.impl.aggregation.AggregatorFactory;
import com.vmware.ph.common.audit.PayloadAuditPersister;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.upload.exception.ConnectionException;
import com.vmware.ph.upload.service.UploadService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class PhClientImpl
implements PhClient {
    private static final String SIMPLE_CLASS_NAME = PhClientImpl.class.getSimpleName();
    private static Logger log = LoggerFactory.getLogger(PhClientImpl.class);
    private static final int UPLOAD_PIPE_BUFFER_SIZE = 8192;
    private final FileSystemOperationsWrapper fileSystemOperationsWrapper;
    private final ExecutorService payloadSerializationTaskExecutor;
    private final ExecutorService aggregationTasksExecutor;
    private final PayloadSerializer serializer;
    private final PayloadAuditPersister payloadAuditPersister;
    private final UploadService uploadService;
    private final Aggregator aggregator;
    private final CeipConfigProvider ceipConfigProvider;

    public PhClientImpl(PayloadAuditPersister payloadAuditPersister, UploadService uploadService, Collector collector, long bufferUploadPeriodMillis, long bufferSizeInBytes, String bufferFolder, CeipConfigProvider ceipConfigProvider) {
        this(payloadAuditPersister, new FileSystemOperationsWrapper(), new PayloadSerializer(), uploadService, collector, bufferUploadPeriodMillis, bufferSizeInBytes, bufferFolder, AggregatorFactory.getInstance(), ceipConfigProvider);
    }

    PhClientImpl(PayloadAuditPersister payloadAuditPersister, FileSystemOperationsWrapper fileSystemOperationsWrapper, PayloadSerializer serializer, UploadService uploadService, Collector collector, long bufferUploadPeriodMillis, long bufferSizeInBytes, String bufferFolder, AggregatorFactory aggregatorFactory, CeipConfigProvider ceipConfigProvider) {
        this.payloadAuditPersister = payloadAuditPersister;
        this.fileSystemOperationsWrapper = fileSystemOperationsWrapper;
        this.serializer = serializer;
        this.uploadService = uploadService;
        this.ceipConfigProvider = ceipConfigProvider;
        this.aggregator = aggregatorFactory.getAggregator(collector.getCollectorId(), collector.getCollectorInstanceId(), bufferUploadPeriodMillis, bufferSizeInBytes, bufferFolder, payloadAuditPersister, uploadService, ceipConfigProvider);
        this.aggregationTasksExecutor = this.initAggregatorExecutorService();
        this.payloadSerializationTaskExecutor = this.singleThreadServiceWithNamedThread("ph-payload-serialization-task");
    }

    private ExecutorService singleThreadServiceWithNamedThread(String threadName) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(threadName).daemon(true).build();
        return Executors.newSingleThreadExecutor(factory);
    }

    private ExecutorService initAggregatorExecutorService() {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("aggregation-workerthread-%d").daemon(true).build();
        return Executors.newFixedThreadPool(10, factory);
    }

    @Override
    public Future<?> upload(String collectorId, String instanceId, String uploadId, File fileToUpload) throws IOException, PhClientConnectionException {
        Future<?> future;
        block6: {
            Validate.notEmpty(collectorId);
            Validate.notEmpty(uploadId);
            Validate.notNull(fileToUpload);
            if (fileToUpload.length() <= 0L) {
                throw new IllegalArgumentException("The file to be uploaded must have size > 0.");
            }
            log.debug("Entering {}.upload() with arguments: collectorId={}, instanceId={}, uploadId={}, fileToUpload={}", new Object[]{SIMPLE_CLASS_NAME, collectorId, instanceId, uploadId, fileToUpload.getAbsoluteFile()});
            if (this.ceipConfigProvider.isCeipEnabled()) break block6;
            Future<?> future2 = this.getCeipDisabledFuture();
            log.debug("Exiting {}.upload() with arguments: collectorId={}, instanceId={}, uploadId={}, fileToUpload={}", new Object[]{SIMPLE_CLASS_NAME, collectorId, instanceId, uploadId, fileToUpload.getAbsoluteFile()});
            return future2;
        }
        try {
            future = this.uploadService.upload(collectorId, instanceId, uploadId, this.fileSystemOperationsWrapper.createStream(fileToUpload), fileToUpload.length());
        }
        catch (ConnectionException e) {
            try {
                throw new PhClientConnectionException(e);
            }
            catch (Throwable throwable) {
                log.debug("Exiting {}.upload() with arguments: collectorId={}, instanceId={}, uploadId={}, fileToUpload={}", new Object[]{SIMPLE_CLASS_NAME, collectorId, instanceId, uploadId, fileToUpload.getAbsoluteFile()});
                throw throwable;
            }
        }
        log.debug("Exiting {}.upload() with arguments: collectorId={}, instanceId={}, uploadId={}, fileToUpload={}", new Object[]{SIMPLE_CLASS_NAME, collectorId, instanceId, uploadId, fileToUpload.getAbsoluteFile()});
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getManifest(String collectorId, String instanceId) throws PhClientConnectionException {
        String string;
        Validate.notEmpty(collectorId);
        log.debug("Entering {}.getManifest() with arguments: collectorId={}, instanceId={}", new Object[]{SIMPLE_CLASS_NAME, collectorId, instanceId});
        try {
            string = this.uploadService.getManifest(collectorId, instanceId);
        }
        catch (Throwable throwable) {
            log.debug("Exiting {}.getManifest() with arguments: collectorId={}, instanceId={}", new Object[]{SIMPLE_CLASS_NAME, collectorId, instanceId});
            throw throwable;
        }
        log.debug("Exiting {}.getManifest() with arguments: collectorId={}, instanceId={}", new Object[]{SIMPLE_CLASS_NAME, collectorId, instanceId});
        return string;
    }

    @Override
    public Future<?> sendPayload(Payload payload, PayloadEnvelope envelope, @Governed.Format @Id.Scope.Universe String uploadId) throws PhClientConnectionException {
        Future<?> result;
        Validate.notNull(payload);
        if (payload.getResources().size() == 0 && payload.getFreeforms().size() == 0) {
            throw new IllegalArgumentException("The payload to be uploaded must have at least one Resource or FreeFormData");
        }
        Validate.notNull(envelope);
        Validate.notNull(envelope.getCollector());
        Validate.notNull(envelope.getCollector().getCollectorId());
        Validate.notEmpty(uploadId);
        if (this.ceipConfigProvider.isCeipEnabled()) {
            this.persistPayloadInAuditFile(payload, envelope, uploadId);
            result = this.uploadPayload(payload, envelope, uploadId);
        } else {
            result = this.getCeipDisabledFuture();
        }
        return result;
    }

    private Future<?> getCeipDisabledFuture() {
        final String msg = "sendPayload will not upload any data - " + this.getCeipDisabledMessage();
        System.out.println(msg);
        log.debug(msg);
        Future<Void> result = new Future<Void>(){

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                throw new ExecutionException(new PhClientException(msg));
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }
        };
        return result;
    }

    private String getCeipDisabledMessage() {
        return "Customer Experience Improvement Program (CEIP) is not enabled. As a result the data will not be uploaded. The isCeipEnabled call was executed against " + CeipConfigProvider.class.getSimpleName() + "=" + this.ceipConfigProvider + " You can enable data upload by agreeing to CEIP consent (or by configuring another " + CeipConfigProvider.class.getSimpleName() + ".";
    }

    @Override
    public void add(CdfAble ... cdf) {
        List<CdfAble> list = Arrays.asList(cdf);
        this.add(list);
    }

    @Override
    public void add(final Collection<? extends CdfAble> cdf) {
        if (!this.ceipConfigProvider.isCeipEnabled()) {
            String msg = "Data will not be added in the buffer - " + this.getCeipDisabledMessage();
            System.out.println(msg);
            log.debug(msg);
            return;
        }
        log.trace("Submitting a task for buffering of a CDF-ables {}", cdf);
        cdf.getClass();
        for (CdfAble cdfAble : cdf) {
            if (null != cdfAble) continue;
            throw new NullPointerException("Null values for " + CdfAble.class.getSimpleName() + " is not accepted.");
        }
        this.aggregationTasksExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (CdfAble c : cdf) {
                        PhClientImpl.this.aggregator.add(c);
                    }
                }
                catch (RuntimeException e) {
                    String msg = "Buffering operation failed. If this error persists, this means that the buffering feature is not working and no data will be buffered and uploaded. For more information see the message of the underlying exception. Please contact the PhoneHome team. ";
                    log.error(msg, (Throwable)e);
                }
            }
        });
    }

    private void persistPayloadInAuditFile(Payload payload, PayloadEnvelope envelope, String uploadId) {
        if (this.payloadAuditPersister != null) {
            try {
                this.payloadAuditPersister.persistPayload(payload, envelope);
            }
            catch (IOException e) {
                log.error("IO Exception during persistance of a payload for uploadId = " + uploadId, (Throwable)e);
                throw new AuditFileWritingFailedException(e);
            }
        }
    }

    private Future<?> uploadPayload(final Payload payload, final PayloadEnvelope envelope, String uploadId) throws PhClientConnectionException {
        long sizeInBytes = this.calculateUploadSizeInBytes(payload, envelope, uploadId);
        final PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(8192);
        try {
            is.connect(os);
        }
        catch (IOException e) {
            throw new Bug("Impossible since piped streams are used correctly");
        }
        Callable<Void> serializationTask = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PhClientImpl.this.serializePayload(payload, envelope, os);
                return null;
            }
        };
        this.payloadSerializationTaskExecutor.submit(serializationTask);
        if (!this.ceipConfigProvider.isCeipEnabled()) {
            log.debug("Upload is disabled by the ceipConfigProvider = " + this.ceipConfigProvider);
            return null;
        }
        String collectorId = envelope.getCollector().getCollectorId();
        String instanceId = envelope.getCollector().getCollectorInstanceId();
        try {
            return this.uploadService.upload(collectorId, instanceId, uploadId, is, sizeInBytes);
        }
        catch (ConnectionException e) {
            throw new PhClientConnectionException(e);
        }
    }

    long calculateUploadSizeInBytes(Payload payload, PayloadEnvelope envelope, String uploadId) {
        BytesCountingStream stream = new BytesCountingStream();
        this.serializePayload(payload, envelope, stream);
        long result = stream.getBytesCount();
        log.trace("Upload size for uploadId = {} is {}", (Object)uploadId, (Object)result);
        return result;
    }

    void serializePayload(Payload payload, PayloadEnvelope envelope, OutputStream os) {
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(os);){
            log.trace(Thread.currentThread().getName() + " start payload serialization.");
            this.serializer.serialize(payload, envelope, CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer(gzipOut));
            log.trace(Thread.currentThread().getName() + " end payload serialization.");
        }
        catch (IOException e) {
            throw new Bug("IO Exception during in-memory serialization of payload must be a bug.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        log.trace("Entering " + SIMPLE_CLASS_NAME + ".close()");
        try {
            this.shutdownExecutorService(this.payloadSerializationTaskExecutor);
            this.aggregator.close();
            this.uploadService.close();
        }
        finally {
            log.trace("Exiting " + SIMPLE_CLASS_NAME + ".close()");
        }
    }

    private void shutdownExecutorService(ExecutorService executorService) {
        executorService.shutdownNow();
        try {
            executorService.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("There was an error while closing the PhClient - an executor service was not shutdown. The upload operations are not affected, but potential system resources may not be freed. Swallowing - nothing we can do.", (Throwable)e);
        }
    }

    static class FileSystemOperationsWrapper {
        FileSystemOperationsWrapper() {
        }

        public InputStream createStream(File file) throws FileNotFoundException {
            return new FileInputStream(file);
        }
    }

    static class BytesCountingStream
    extends OutputStream {
        private long size = 0L;

        BytesCountingStream() {
        }

        public long getBytesCount() {
            return this.size;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new Bug("Unexpected error while counting bytes size. This is unrecoverable bug and the requested operation is aborted. Contact PhoneHome development team for new bug-free version.", new IndexOutOfBoundsException());
            }
            if (len == 0) {
                return;
            }
            this.size += (long)len;
        }
    }
}

