/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.impl.aggregation;

import com.vmware.ph.client.api.commondataformat.serialization.CdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.CdfSequenceSerializerFactory;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.exceptions.PhClientException;
import com.vmware.ph.client.api.impl.aggregation.DataProcessor;
import com.vmware.ph.common.audit.PayloadAuditPersister;
import com.vmware.ph.exceptions.Bug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProcessorImpl
implements DataProcessor {
    private static final Logger log = LoggerFactory.getLogger(DataProcessorImpl.class);
    private final PayloadAuditPersister auditPersister;
    private final CdfSequenceSerializerInstantiator cdfSeqSerInstantiator;

    public DataProcessorImpl(PayloadAuditPersister auditPersister) {
        this.auditPersister = auditPersister;
        this.cdfSeqSerInstantiator = new CdfSequenceSerializerInstantiator();
    }

    @Override
    public byte[] process(CdfAble cdf) {
        if (cdf == null) {
            throw new Bug("CdfAble is null. As a result it cannot be processed. Provide a non-null value.");
        }
        this.persistForAudit(cdf);
        return this.serializeToBytes(cdf);
    }

    private void persistForAudit(CdfAble cdf) {
        try {
            log.trace("persist cdf " + cdf);
            this.auditPersister.persistCdfAble(cdf);
            log.trace("finish persisting cdf " + cdf);
        }
        catch (IOException e) {
            String msg = "IOException during persisting of CdfAble for audit. This should not happen and most probably mean that the disk is full and no write can be executed.No data should be uploaded without being persisted for audit first, so we bubble up a PhClientException.As a result this resource will not be added for aggregation and will not be uploaded.Try to provide disk space, and if this does not help - contact the PhoneHome team.";
            log.error(msg, (Throwable)e);
            throw new PhClientException(msg, e);
        }
    }

    private byte[] serializeToBytes(CdfAble cdf) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (CdfSequenceSerializer serializer = this.cdfSeqSerInstantiator.create(os);){
            log.trace("serializing cdf " + cdf);
            serializer.write(cdf);
            log.trace("finish serializing cdf " + cdf);
        }
        catch (IOException e) {
            String message = "IO Exception during in-memory serialization of cdf.";
            log.error(message, (Throwable)e);
            throw new Bug(message, e);
        }
        return os.toByteArray();
    }

    static class CdfSequenceSerializerInstantiator {
        CdfSequenceSerializerInstantiator() {
        }

        public CdfSequenceSerializer create(OutputStream os) throws IOException {
            return CdfSequenceSerializerFactory.createRdfCdfSequenceSerializerNoNamespaces(os);
        }
    }
}

