/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps.discovery;

import com.google.common.net.InternetDomainName;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOrigin;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String obtainFqdn() throws UnknownHostException {
        String localIP;
        InetAddress localAddress = InetAddress.getLocalHost();
        String fqdn = localAddress.getCanonicalHostName();
        return fqdn.equalsIgnoreCase(localIP = localAddress.getHostAddress()) ? null : fqdn;
    }

    public static String getNextLevelNonPublicDomain(String domain) {
        log.trace("Getting the next level non-public domain for {}", (Object)domain);
        if (domain == null) {
            return null;
        }
        StringBuilder domainCleared = new StringBuilder(domain.trim());
        while (domainCleared.length() > 0 && domainCleared.charAt(0) == '.') {
            domainCleared.deleteCharAt(0);
        }
        while (domainCleared.length() > 0 && domainCleared.charAt(domainCleared.length() - 1) == '.') {
            domainCleared.deleteCharAt(domainCleared.length() - 1);
        }
        if (domainCleared.length() == 0) {
            return null;
        }
        int dotIndex = domainCleared.indexOf(".");
        if (dotIndex != -1) {
            domainCleared.delete(0, dotIndex + 1);
            log.trace("Possible next level domain is {}", (Object)domainCleared);
            InternetDomainName idn = InternetDomainName.from(domainCleared.toString());
            if (idn.hasParent() && !idn.isPublicSuffix()) {
                log.trace("It is not public, returning it.");
                return domainCleared.toString();
            }
            log.trace("It is a public domain.");
        }
        log.trace("No next level non-public domain found");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPacAvailability(URL scriptUrl) throws IOException {
        log.debug("Checking availability of a PAC script with URL {}", (Object)scriptUrl);
        if (scriptUrl == null) {
            return false;
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)scriptUrl.openConnection(Proxy.NO_PROXY);
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("accept", "application/x-ns-proxy-autoconfig");
            int responseCode = conn.getResponseCode();
            log.debug("HTTP connection to PAC script returned code {}", (Object)responseCode);
            boolean bl = responseCode == 200;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static URL constructDnsWpadScriptUrl(String domain) throws MalformedURLException {
        log.trace("Constructing DNS WPAD PAC script URL for domain {}", (Object)domain);
        if (domain == null) {
            return null;
        }
        StringBuilder urlString = new StringBuilder(domain.trim());
        if (urlString.length() == 0) {
            return null;
        }
        if (urlString.charAt(0) == '.' || urlString.charAt(0) == '/') {
            urlString.deleteCharAt(0);
        }
        if (urlString.charAt(urlString.length() - 1) == '.' || urlString.charAt(urlString.length() - 1) == '/') {
            urlString.deleteCharAt(urlString.length() - 1);
        }
        String result = urlString.insert(0, "http://wpad.").append("/wpad.dat").toString();
        log.trace("DNS WPAD script URL constructed: {}", (Object)result);
        return new URL(result);
    }

    public static List<ProxySettingsWithOrigin> toProxySettings(Proxy javaProxy, String strategyName) {
        SocketAddress address = javaProxy.address();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            ProxySettingsWithOrigin ps = new ProxySettingsWithOrigin(inetAddress.getHostString(), inetAddress.getPort(), null, null, strategyName);
            return Collections.singletonList(ps);
        }
        if (address != null) {
            log.debug("Unexpected proxy address: " + address);
        }
        return Collections.emptyList();
    }

    public static HostAndPort parseHost(String host) {
        log.debug("Parsing host: {}", (Object)host);
        if (host == null) {
            return new HostAndPort(null, null);
        }
        int ipV6leftBracketIndex = host.indexOf(91);
        int ipv6rightBracketIndex = host.indexOf(93);
        String hostname = null;
        Integer port = null;
        if (ipV6leftBracketIndex >= 0 && ipV6leftBracketIndex < ipv6rightBracketIndex) {
            int colonIndex;
            log.debug("The host is in IPv6 format '[IPv6_addr]:port'");
            hostname = host.substring(ipV6leftBracketIndex + 1, ipv6rightBracketIndex).replaceAll(" ", "");
            if (hostname.isEmpty()) {
                hostname = null;
            }
            if ((colonIndex = host.indexOf(58, ipv6rightBracketIndex + 1)) != -1) {
                String portString = host.substring(colonIndex + 1).trim();
                try {
                    port = new Integer(portString);
                }
                catch (NumberFormatException e) {
                    log.debug("Couldn't parse port: '{}'", (Object)portString);
                }
            }
        } else {
            log.debug("The host is in IPv4 format 'host:port'");
            String[] serverParts = host.split(":");
            if (serverParts.length > 0) {
                hostname = serverParts[0].trim();
                if (hostname.isEmpty()) {
                    hostname = null;
                }
                if (serverParts.length > 1) {
                    String portString = serverParts[1].trim();
                    try {
                        port = new Integer(portString);
                    }
                    catch (NumberFormatException e) {
                        log.debug("Couldn't parse port: '{}'", (Object)portString);
                    }
                }
            }
        }
        log.debug("Parsed as hostname: {}, port: {}", (Object)hostname, port);
        return new HostAndPort(hostname, port);
    }

    public static class HostAndPort {
        private final String hostname;
        private final Integer port;

        public HostAndPort(String hostname, Integer port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Integer getPort(int defaultValue) {
            return this.port != null ? this.port : defaultValue;
        }
    }
}

