/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps.discovery;

import com.btr.proxy.util.ProxyException;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOrigin;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOriginProvider;
import com.vmware.ph.client.common.extensions.ps.discovery.Utils;
import com.vmware.ph.client.common.extensions.ps.discovery.wpad.WpadProxySearchStrategy;
import com.vmware.ph.client.common.extensions.ps.discovery.wpad.impl.DnsPacScriptDiscoverer;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpadProxyProvider
implements ProxySettingsWithOriginProvider {
    private static final Logger log = LoggerFactory.getLogger(WpadProxyProvider.class);
    private final URI platformBaseUri;

    public WpadProxyProvider(URI platformBaseUri) {
        this.platformBaseUri = platformBaseUri;
    }

    @Override
    public Collection<ProxySettingsWithOrigin> getOptions() {
        LinkedHashSet<ProxySettingsWithOrigin> result = new LinkedHashSet<ProxySettingsWithOrigin>();
        result.addAll(this.getSettings());
        return result;
    }

    private Collection<? extends ProxySettingsWithOrigin> getSettings() {
        log.debug("Getting proxy settings through WPAD for URI {}", (Object)this.platformBaseUri);
        List<Proxy> possibleProxies = null;
        try {
            WpadProxySearchStrategy wpadProxySearchStrategy = new WpadProxySearchStrategy(new DnsPacScriptDiscoverer());
            ProxySelector selector = wpadProxySearchStrategy.getProxySelector();
            if (selector != null) {
                log.debug("WPAD proxy selector is obtained. Selecting URI {} ", (Object)this.platformBaseUri);
                possibleProxies = selector.select(this.platformBaseUri);
                log.info("WPAD proxies found: {}", possibleProxies);
            } else {
                log.info("No WPAD proxies were found. No worries. Continuing with other proxy auto-discovery algorithms.");
            }
        }
        catch (RuntimeException e) {
            log.warn("Ignoring unexpected error while retrieving proxy information from WPAD search strategy", (Throwable)e);
        }
        catch (ProxyException e) {
            log.warn("Caught an exception while obtaining selector for WPAD. As a result no WPAD proxy settings will be yielded.", (Throwable)e);
        }
        ArrayList<ProxySettingsWithOrigin> result = new ArrayList<ProxySettingsWithOrigin>();
        if (possibleProxies != null) {
            for (Proxy proxy : possibleProxies) {
                log.trace("Processing proxy {}", (Object)proxy);
                List<ProxySettingsWithOrigin> strategyResult = Utils.toProxySettings(proxy, "WPAD");
                log.trace("Adding List<ProxySettingsWithOrigin> to the end result {}", strategyResult);
                result.addAll(strategyResult);
            }
        }
        log.debug("WPAD strategy yielded {}.", result);
        return result;
    }
}

