/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsRestClientBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(TlsRestClientBuilderFactory.class);
    private static final String TLS_VERSION_PH_PROPERTY_NAME = "ph.https.protocols";
    private static final String TLS_VERSION_JVM_PROPERTY_NAME = "https.protocols";
    private static final String DEFAULT_TLS_VERSIONS = "TLSv1.1,TLSv1.2";
    private static final String CIPHER_SUITES_PH_PROPERTY_NAME = "ph.https.cipherSuites";
    private static final String CIPHER_SUITES_JVM_PROPERTY_NAME = "https.cipherSuites";
    private static final String DEFAULT_CIPHER_SUITES = null;
    private final ObjectFactory objectFactory;

    public TlsRestClientBuilderFactory() {
        this(new DefaultObjectFactory());
    }

    TlsRestClientBuilderFactory(ObjectFactory factoryHelper) {
        this.objectFactory = factoryHelper;
    }

    public HttpClientConnectionManager createCustomizedConnectionManager(TrustManager[] trustManagers) {
        HttpClientConnectionManager connManager = null;
        String[] supportedSslProtocols = TlsRestClientBuilderFactory.split(this.getConfiguredHttpsProtocols());
        String[] supportedCipherSuites = TlsRestClientBuilderFactory.split(this.getConfiguredCipherSuites());
        try {
            SSLContext sslContext = this.objectFactory.createSslContext();
            if (trustManagers != null) {
                sslContext.init(null, trustManagers, null);
            }
            SSLConnectionSocketFactory sslSocketFactory = this.objectFactory.createSSLConnectionSocketFactory(sslContext, supportedSslProtocols, supportedCipherSuites, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            Registry<ConnectionSocketFactory> registry = this.objectFactory.createConnectionSocketFactoryRegistry(sslSocketFactory);
            connManager = this.objectFactory.createHttpClientConnectionManager(registry);
            log.debug("Created PoolingHttpClientConnectionManager with support of the following SSL protocols: " + Arrays.asList(supportedSslProtocols));
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("It is not possible to create HttpClientConnectionManager with:\nTLS enabled protocols: {}'\nCipher suites: {}\nTrust managers: {}.\nThis means that PhClient will work with the configured by default HttpClientConnectionManager.", (Object)new Object[]{supportedSslProtocols, supportedCipherSuites, trustManagers}, (Object)e);
        }
        return connManager;
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private String getConfiguredHttpsProtocols() {
        return this.getConfigurationValue(TLS_VERSION_PH_PROPERTY_NAME, TLS_VERSION_JVM_PROPERTY_NAME, DEFAULT_TLS_VERSIONS);
    }

    private String getConfiguredCipherSuites() {
        return this.getConfigurationValue(CIPHER_SUITES_PH_PROPERTY_NAME, CIPHER_SUITES_JVM_PROPERTY_NAME, DEFAULT_CIPHER_SUITES);
    }

    private String getConfigurationValue(String higherPrecedencePropName, String lowerPrecedencePropName, String defaultValue) {
        String value = System.getProperty(higherPrecedencePropName);
        if (TextUtils.isBlank(value)) {
            value = System.getProperty(lowerPrecedencePropName);
        }
        if (TextUtils.isBlank(value)) {
            value = defaultValue;
        }
        return value;
    }

    static class DefaultObjectFactory
    implements ObjectFactory {
        DefaultObjectFactory() {
        }

        @Override
        public SSLContext createSslContext() throws KeyManagementException, NoSuchAlgorithmException {
            return SSLContexts.custom().useTLS().build();
        }

        @Override
        public SSLConnectionSocketFactory createSSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
            return new SSLConnectionSocketFactory(sslContext, supportedProtocols, supportedCipherSuites, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }

        @Override
        public Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(SSLConnectionSocketFactory sslConectionSocketFactory) {
            return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslConectionSocketFactory)).build();
        }

        @Override
        public HttpClientConnectionManager createHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry) {
            return new PoolingHttpClientConnectionManager(registry);
        }
    }

    static interface ObjectFactory {
        public SSLContext createSslContext() throws KeyManagementException, NoSuchAlgorithmException;

        public SSLConnectionSocketFactory createSSLConnectionSocketFactory(SSLContext var1, String[] var2, String[] var3, X509HostnameVerifier var4);

        public Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(SSLConnectionSocketFactory var1);

        public HttpClientConnectionManager createHttpClientConnectionManager(Registry<ConnectionSocketFactory> var1);
    }
}

