/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common.net;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ProxySettings {
    public static final List<String> DEFAULT_PROXY_AUTHENTICATION_SCHEMES = Arrays.asList("digest", "basic");
    public static final ProxySettings NO_PROXY = new ProxySettings();
    private String hostname;
    private int port;
    private String username;
    private String password;
    private String scheme = "http";
    private Collection<String> proxyAuthenticationSchemes = DEFAULT_PROXY_AUTHENTICATION_SCHEMES;

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Collection<String> getProxyAuthenticationSchemes() {
        return this.proxyAuthenticationSchemes;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProxyAuthenticationSchemes(Collection<String> proxyAuthenticationSchemes) {
        this.proxyAuthenticationSchemes = proxyAuthenticationSchemes;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ProxySettings(String scheme, String hostname, int port, String username, String password) {
        this.scheme = scheme;
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
    }

    public ProxySettings(String hostname, int port, String username, String password) {
        this("http", hostname, port, username, password);
    }

    public ProxySettings() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.proxyAuthenticationSchemes == null ? 0 : this.proxyAuthenticationSchemes.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxySettings)) {
            return false;
        }
        ProxySettings other = (ProxySettings)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.proxyAuthenticationSchemes == null ? other.proxyAuthenticationSchemes != null : !this.proxyAuthenticationSchemes.equals(other.proxyAuthenticationSchemes)) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return String.format("%s[scheme=%s, hostname=%s, port=%d, username=%s, proxyAuthenticationSchemes=%s]", this.getClass().getSimpleName(), this.scheme, this.hostname, this.port, this.username, this.proxyAuthenticationSchemes);
    }
}

