/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.upload.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.vmware.ph.LibVersion;
import com.vmware.ph.common.json.JsonSerializer;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.exceptions.collector.InvalidCollectorException;
import com.vmware.ph.model.exceptions.ExceptionType;
import com.vmware.ph.model.exceptions.ServiceException;
import com.vmware.ph.upload.HttpClientSetup;
import com.vmware.ph.upload.exception.ConnectionException;
import com.vmware.ph.upload.model.UploadDetails;
import com.vmware.ph.upload.rest.PhRestClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PhRestClientImpl
implements PhRestClient {
    private static final String EXCEPTION_WHILE_GETTING_INITIAL_PROBLEM = "Exception while trying to build human readable message for another connection problem. Cause: ";
    private static final String GENERIC_REQUEST_FAILED_MESSAGE = "Request failed with %s:%s";
    public static final String SERVER_TIME_CONTEXT_PATH = "server_time";
    private static final String UPLOAD_REQUEST_CONTEXT_PATH = "upload_request";
    private static final String MANIFEST_CONTEXT_PATH = "manifest";
    private static final int ERROR_MESSAGE_MAX_SIZE_IN_BYTES = 16384;
    private static final Logger log = LoggerFactory.getLogger(PhRestClientImpl.class);
    private final HttpClientBuilder httpClientBuilder;
    private CloseableHttpClient phServerClient;
    private final String serverBasePath;
    private final HttpConnectionConfig connectionConfig;
    private ProxySettings proxySettings;

    public PhRestClientImpl(String serverBasePath, ProxySettings proxySettings, HttpConnectionConfig connConfig) {
        this(serverBasePath, proxySettings, HttpClientBuilder.create(), connConfig);
    }

    PhRestClientImpl(String serverBasePath, ProxySettings proxySettings, HttpClientBuilder httpClientBuilder, HttpConnectionConfig connConfig) {
        Validate.notNull(serverBasePath);
        Validate.notNull(httpClientBuilder);
        Validate.notNull(connConfig);
        this.serverBasePath = serverBasePath;
        this.proxySettings = proxySettings;
        this.httpClientBuilder = httpClientBuilder;
        this.connectionConfig = connConfig;
        this.phServerClient = this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() {
        log.trace("Rebuilding the underlying HTTP client...");
        HttpClientSetup.setupHttpClientBuilder(this.httpClientBuilder, this.connectionConfig, this.proxySettings, new BasicCredentialsProvider());
        CloseableHttpClient client = this.httpClientBuilder.build();
        log.trace("Underlying HTTP client is built.");
        return client;
    }

    @Override
    public String getManifest(String collectorId, String instanceId) throws ConnectionException {
        URIBuilder builder = null;
        try {
            builder = new URIBuilder(this.serverBasePath + MANIFEST_CONTEXT_PATH);
            builder.setParameter("collectorId", collectorId);
            builder.setParameter("instanceId", instanceId);
            builder.setParameter("v", LibVersion.getFullVersion());
        }
        catch (URISyntaxException e) {
            throw new Bug(e.getMessage(), e);
        }
        String uri = builder.toString();
        log.debug("Executing request: {}", (Object)uri);
        HttpGet request = new HttpGet(uri);
        request.setHeader("accept", "text/plain");
        CloseableHttpResponse response = null;
        try {
            String manifest;
            response = this.phServerClient.execute(request);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            log.debug("Status code: {}", (Object)statusLine);
            if (statusCode == 500) {
                this.handlePhServerException(response);
            }
            if (statusCode != 200) {
                this.handleGenericProblem(response, statusLine, statusCode);
            }
            if (response.getEntity() == null) {
                throw new Bug("response.getEntity should not be null in case of SC_OK http status");
            }
            String string = manifest = EntityUtils.toString(response.getEntity(), "UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
        finally {
            request.reset();
            IOUtils.closeQuietly(response);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public UploadDetails sendUploadRequest(String collectorId, String instanceId, String uploadId, long fileSize) throws ConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        try {
            this.phServerClient.close();
        }
        catch (IOException e) {
            log.error("Error closing the underlying HttpClient while closing the PhRestClient.This may result in resource leak and may be caused by bug in the code. Check the exception cause and if needed reconsider the HTTP request logic. Continuing as if nothing happened.", (Throwable)e);
        }
    }

    @Override
    public synchronized void setProxySettings(ProxySettings proxySettings) {
        log.debug("Setting new proxy settings {}", (Object)proxySettings);
        Validate.notNull(proxySettings);
        this.proxySettings = proxySettings;
        this.phServerClient = this.createHttpClient();
    }

    private void handlePhServerException(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        try {
            InputStream content = response.getEntity().getContent();
            Throwable throwable = null;
            try {
                try {
                    ServiceException exception = JsonSerializer.readObject(content, ServiceException.class);
                    if (exception.getExceptionType() == ExceptionType.InvalidCollector) {
                        throw new InvalidCollectorException(exception.getMessage());
                    }
                    throw new RuntimeException(exception.getMessage());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (content != null) {
                    if (throwable != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        content.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (JsonParseException e) {
            log.debug("The HTTP response's status is 500, but there's no instance of type " + ServiceException.class.getSimpleName() + " in the body. This means an unknown exception was thrown by the server.");
            return;
        }
    }

    private void handleGenericProblem(HttpResponse response, StatusLine statusLine, int statusCode) throws ConnectionException {
        String exceptionMessage;
        try {
            exceptionMessage = this.buildExceptionMessage(response);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_WHILE_GETTING_INITIAL_PROBLEM + e.getMessage(), (Throwable)e);
            exceptionMessage = String.format(GENERIC_REQUEST_FAILED_MESSAGE, statusCode, statusLine.getReasonPhrase());
        }
        if (statusCode == 407 || statusCode == 408) {
            throw new ConnectionException(exceptionMessage);
        }
        throw new RuntimeException(exceptionMessage);
    }

    private String buildExceptionMessage(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        StringBuilder message = new StringBuilder("Request failed: ");
        message.append(statusLine.getStatusCode()).append(" ").append(statusLine.getReasonPhrase());
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            message.append("; Reason: \n");
            String encoding = entity.getContentEncoding() == null ? null : entity.getContentEncoding().getValue();
            try (InputStream input = entity.getContent();){
                String errorCause = PhRestClientImpl.readFirstBytes(input, 16384, encoding);
                message.append(errorCause);
            }
        }
        return message.toString();
    }

    static String readFirstBytes(InputStream input, int limit, String encoding) throws IOException {
        byte[] buffer = new byte[limit];
        int i = input.read(buffer);
        if (i == -1) {
            return "";
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return new String(buffer, 0, i, encoding);
    }
}

