/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal;

import com.vmware.cis.license.common.misc.DateUtil;
import com.vmware.cis.license.common.misc.Util;
import com.vmware.cis.license.common.serialization.DeserializeException;
import com.vmware.cis.license.common.vmodl.VmodlUtil;
import com.vmware.license.myvmware.client.sync.internal.ContractDetails;
import com.vmware.license.myvmware.client.sync.internal.EncodeUtil;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.OrderDetails;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class LicenseMetadataUtil {
    private static final String ACCOUNT_NAME_PROP = "accountName";
    private static final String ACCOUNT_NUMBER_PROP = "accountNumber";
    private static final String PRODUCT_NAME_PROP = "productName";
    private static final String LICENSE_KEY_PROP = "licenseKey";
    private static final String LICENSE_QUANTITY_PROP = "licenseQuantity";
    private static final String UNIT_OF_MEASURE_PROP = "unitOfMeasure";
    private static final String FOLDER_LOCATION_PROP = "folderLocation";
    private static final String LICENSE_KEY_NOTES_PROP = "licenseKeyNotes";
    private static final String CUSTOM_LABELS_PROP = "customLabels";
    private static final String ORDER_DETAILS_PROP = "orderDetails";
    private static final String ORDER_TYPE_PROP = "type";
    private static final String ORDER_NUMBER_PROP = "number";
    private static final String ORDER_QUANTITY_PROP = "orderQuantity";
    private static final String ORDER_DATE_PROP = "orderDate";
    private static final String ORDER_PO_NUMBER_PROP = "poNumber";
    private static final String CONTRACT_DETAILS_PROP = "contractDetails";
    private static final String CONTRACT_TYPE_PROP = "type";
    private static final String CONTRACT_NUMBER_PROP = "number";
    private static final String CONTRACT_LICENSE_COVERAGE_START_DATE_PROP = "licenseCoverageStartDate";
    private static final String CONTRACT_LICENSE_COVERAGE_END_DATE_PROP = "licenseCoverageEndDate";
    private static final String CONTRACT_SUPPORT_LEVEL_PROP = "supportLevel";
    private static final String CONTRACT_ELA_FLAG_PROP = "ELAFlag";

    public static KeyAnyValue[] decodeLicenseMetadata(byte[] data, String version) throws DeserializeException {
        LicenseKeyDetails licenseKeyDetails = EncodeUtil.decodeLicenseKeyDetails(data, version);
        return LicenseMetadataUtil.buildLicenseMetadataProperties(licenseKeyDetails);
    }

    public static boolean isLicenseWithActiveSupport(KeyAnyValue[] licenseMetadata) {
        if (Util.isNullOrEmpty((Object[])licenseMetadata)) {
            return false;
        }
        List contractsDetails = VmodlUtil.findAllValues((String)CONTRACT_DETAILS_PROP, (KeyAnyValue[])licenseMetadata);
        boolean hasActiveSupport = false;
        if (!Util.isNullOrEmpty((Collection)contractsDetails)) {
            for (KeyAnyValue[] contractDetails : contractsDetails) {
                if (!LicenseMetadataUtil.isContractWithActiveSupport(contractDetails)) continue;
                hasActiveSupport = true;
                break;
            }
        }
        return hasActiveSupport;
    }

    private static boolean isContractWithActiveSupport(KeyAnyValue[] contractDetails) {
        Calendar licenseConverageEndDate = (Calendar)VmodlUtil.findFirstValue((String)CONTRACT_LICENSE_COVERAGE_END_DATE_PROP, (KeyAnyValue[])contractDetails);
        if (licenseConverageEndDate == null) {
            return false;
        }
        return DateUtil.isCalendarInTheFuture((Calendar)licenseConverageEndDate);
    }

    private static KeyAnyValue[] buildLicenseMetadataProperties(LicenseKeyDetails licenseKeyDetails) {
        ArrayList<KeyAnyValue> licenseMetadataProperties = new ArrayList<KeyAnyValue>();
        LicenseMetadataUtil.populateBaseLicenseKeyDetailsPropeties(licenseMetadataProperties, licenseKeyDetails);
        LicenseMetadataUtil.populateOrdersDetailsProperties(licenseMetadataProperties, licenseKeyDetails.orderDetails);
        LicenseMetadataUtil.populateContractsDetailsProperties(licenseMetadataProperties, licenseKeyDetails.contractDetails);
        return licenseMetadataProperties.toArray(new KeyAnyValue[licenseMetadataProperties.size()]);
    }

    private static void populateBaseLicenseKeyDetailsPropeties(ArrayList<KeyAnyValue> licenseMetadataProperties, LicenseKeyDetails licenseKeyDetails) {
        KeyAnyValueImpl property = new KeyAnyValueImpl();
        property.setKey(ACCOUNT_NAME_PROP);
        property.setValue((Object)licenseKeyDetails.accountDetails.accountName);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(ACCOUNT_NUMBER_PROP);
        property.setValue((Object)licenseKeyDetails.accountDetails.accountNumber);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(PRODUCT_NAME_PROP);
        property.setValue((Object)licenseKeyDetails.productName);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(LICENSE_KEY_PROP);
        property.setValue((Object)licenseKeyDetails.licenseKey);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(LICENSE_QUANTITY_PROP);
        property.setValue((Object)licenseKeyDetails.licenseQuantity);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(UNIT_OF_MEASURE_PROP);
        property.setValue((Object)licenseKeyDetails.unitOfMeasure);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(FOLDER_LOCATION_PROP);
        property.setValue((Object)licenseKeyDetails.folderLocation);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(LICENSE_KEY_NOTES_PROP);
        property.setValue((Object)licenseKeyDetails.licenseKeyNotes);
        licenseMetadataProperties.add((KeyAnyValue)property);
        property = new KeyAnyValueImpl();
        property.setKey(CUSTOM_LABELS_PROP);
        property.setValue((Object)licenseKeyDetails.customLabels);
        licenseMetadataProperties.add((KeyAnyValue)property);
    }

    private static void populateOrdersDetailsProperties(ArrayList<KeyAnyValue> licenseMetadataProperties, OrderDetails[] ordersDetails) {
        if (Util.isNullOrEmpty((Object[])ordersDetails)) {
            return;
        }
        for (OrderDetails orderDetails : ordersDetails) {
            KeyAnyValue[] orderDetailsProperties = LicenseMetadataUtil.buildOrderDetailsProperties(orderDetails);
            KeyAnyValueImpl property = new KeyAnyValueImpl();
            property.setKey(ORDER_DETAILS_PROP);
            property.setValue((Object)orderDetailsProperties);
            licenseMetadataProperties.add((KeyAnyValue)property);
        }
    }

    private static void populateContractsDetailsProperties(ArrayList<KeyAnyValue> licenseMetadataProperties, ContractDetails[] contractsDetails) {
        if (Util.isNullOrEmpty((Object[])contractsDetails)) {
            return;
        }
        for (ContractDetails contractDetails : contractsDetails) {
            KeyAnyValue[] contractDetailsProperties = LicenseMetadataUtil.buildContractDetailsProperties(contractDetails);
            KeyAnyValueImpl property = new KeyAnyValueImpl();
            property.setKey(CONTRACT_DETAILS_PROP);
            property.setValue((Object)contractDetailsProperties);
            licenseMetadataProperties.add((KeyAnyValue)property);
        }
    }

    private static KeyAnyValue[] buildOrderDetailsProperties(OrderDetails orderDetails) {
        ArrayList<KeyAnyValueImpl> orderDetailsProperties = new ArrayList<KeyAnyValueImpl>();
        KeyAnyValueImpl property = new KeyAnyValueImpl();
        property.setKey("type");
        property.setValue((Object)orderDetails.type);
        orderDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey("number");
        property.setValue((Object)orderDetails.number);
        orderDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey(ORDER_QUANTITY_PROP);
        property.setValue((Object)orderDetails.orderQuantity);
        orderDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey(ORDER_DATE_PROP);
        property.setValue((Object)LicenseMetadataUtil.convertDateToCalendar(orderDetails.orderDate));
        orderDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey(ORDER_PO_NUMBER_PROP);
        property.setValue((Object)orderDetails.poNumber);
        orderDetailsProperties.add(property);
        return orderDetailsProperties.toArray(new KeyAnyValue[orderDetailsProperties.size()]);
    }

    private static KeyAnyValue[] buildContractDetailsProperties(ContractDetails contractDetails) {
        ArrayList<KeyAnyValueImpl> contractDetailsProperties = new ArrayList<KeyAnyValueImpl>();
        KeyAnyValueImpl property = new KeyAnyValueImpl();
        property.setKey("type");
        property.setValue((Object)contractDetails.type);
        contractDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey("number");
        property.setValue((Object)contractDetails.number);
        contractDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey(CONTRACT_LICENSE_COVERAGE_START_DATE_PROP);
        property.setValue((Object)LicenseMetadataUtil.convertDateToCalendar(contractDetails.licenseCoverageStartDate));
        contractDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey(CONTRACT_LICENSE_COVERAGE_END_DATE_PROP);
        property.setValue((Object)LicenseMetadataUtil.convertDateToCalendar(contractDetails.licenseCoverageEndDate));
        contractDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey(CONTRACT_SUPPORT_LEVEL_PROP);
        property.setValue((Object)contractDetails.supportLevel);
        contractDetailsProperties.add(property);
        property = new KeyAnyValueImpl();
        property.setKey(CONTRACT_ELA_FLAG_PROP);
        property.setValue((Object)contractDetails.ELAFlag);
        contractDetailsProperties.add(property);
        return contractDetailsProperties.toArray(new KeyAnyValue[contractDetailsProperties.size()]);
    }

    private static Calendar convertDateToCalendar(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.createUTCCalendar((Date)date);
    }
}

