/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.impl;

import com.vmware.license.myvmware.client.sync.internal.ReportReader;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.LicenseInventoryReportParseException;
import com.vmware.license.myvmware.client.sync.internal.inventoryreport.impl.LicenseInventoryReportSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CsvLicenseInventoryReportReaderImpl
implements ReportReader {
    private static final Log _log = LogFactory.getLog(CsvLicenseInventoryReportReaderImpl.class);
    private static final int REPORT_HEADER_ROWS_COUNT_MAX = 20;
    private static final int REPORT_COLUMNS_COUNT_MIN = LicenseInventoryReportSchema.COLUMNS_COUNT_V1_REPORT;
    private static final char REPORT_RECORD_ITEMS_DELIMITER = ',';
    private final CSVParser _parser;
    private Iterator<CSVRecord> _recordsIterator;
    private CSVRecord _nextRecord;
    private String _reportVersion;
    private int _actualReportColumnsCount;

    public CsvLicenseInventoryReportReaderImpl(InputStream csvReportInputStream) throws LicenseInventoryReportParseException {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        csvFormat = csvFormat.withIgnoreEmptyLines(true);
        csvFormat = csvFormat.withIgnoreSurroundingSpaces(true);
        csvFormat = csvFormat.withDelimiter(',');
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(csvReportInputStream, "UTF-8");
            this._parser = new CSVParser((Reader)inputStreamReader, csvFormat);
        }
        catch (IOException e) {
            throw new LicenseInventoryReportParseException("Error reading license report", e);
        }
        this._recordsIterator = this._parser.iterator();
        try {
            this.initialize();
        }
        catch (RuntimeException e) {
            Throwable ex = e;
            if (ex.getCause() != null) {
                ex = ex.getCause();
            }
            throw new LicenseInventoryReportParseException("Error reading license report", ex);
        }
    }

    @Override
    public String getReportVersion() {
        return this._reportVersion;
    }

    @Override
    public boolean hasNext() {
        return this._nextRecord != null && this._nextRecord.size() == this._actualReportColumnsCount;
    }

    @Override
    public String[] next() {
        CSVRecord currentRecord = this._nextRecord;
        if (currentRecord == null) {
            throw new NoSuchElementException("CSV record is null");
        }
        List<String> elementsList = CsvLicenseInventoryReportReaderImpl.collectElements(currentRecord.iterator());
        if (elementsList.size() != this._actualReportColumnsCount) {
            throw new NoSuchElementException("Unexpected CSV record size: " + elementsList.size());
        }
        this._nextRecord = this.readNextRecordSkipOnError();
        return elementsList.toArray(new String[elementsList.size()]);
    }

    @Override
    public void close() {
        try {
            this._parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initialize() throws LicenseInventoryReportParseException {
        CSVRecord columnNamesRecord = this.readColumnNamesRecord();
        CsvLicenseInventoryReportReaderImpl.validateColumnNames(columnNamesRecord);
        this._reportVersion = CsvLicenseInventoryReportReaderImpl.detectReportVersion(columnNamesRecord);
        this._actualReportColumnsCount = columnNamesRecord.size();
        this._nextRecord = this.readNextRecordSkipOnError();
    }

    private CSVRecord readColumnNamesRecord() throws LicenseInventoryReportParseException {
        CSVRecord columnNamesRecord;
        while ((columnNamesRecord = this.readNextRecord()) != null) {
            String actualFirstColumnName;
            String expectedFirstColumnName;
            if (columnNamesRecord.getRecordNumber() > 21L) {
                throw new LicenseInventoryReportParseException("Invalid license report: Column names row is missing");
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)columnNamesRecord.toString());
            }
            if (columnNamesRecord.size() < REPORT_COLUMNS_COUNT_MIN || !(expectedFirstColumnName = LicenseInventoryReportSchema.Columns.values()[0].getColumnName()).equalsIgnoreCase(actualFirstColumnName = columnNamesRecord.get(0))) continue;
            break;
        }
        if (columnNamesRecord == null) {
            throw new LicenseInventoryReportParseException("Invalid license report: Column names row is missing");
        }
        return columnNamesRecord;
    }

    private CSVRecord readNextRecordSkipOnError() {
        boolean rowIsGood = false;
        boolean errorInCurrentRow = false;
        CSVRecord nextRecord = null;
        while (!rowIsGood) {
            try {
                nextRecord = this.readNextRecord();
                if (errorInCurrentRow) {
                    errorInCurrentRow = false;
                    continue;
                }
                rowIsGood = true;
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (e.getCause() instanceof IOException) {
                    errorInCurrentRow = true;
                    continue;
                }
                throw e;
            }
        }
        return nextRecord;
    }

    private CSVRecord readNextRecord() {
        return this._recordsIterator.hasNext() ? this._recordsIterator.next() : null;
    }

    private static void validateColumnNames(CSVRecord columnNamesRecord) throws LicenseInventoryReportParseException {
        for (int i = 0; i < REPORT_COLUMNS_COUNT_MIN; ++i) {
            String actualColumnName;
            String expectedColumnName = LicenseInventoryReportSchema.Columns.values()[i].getColumnName();
            if (expectedColumnName.equalsIgnoreCase(actualColumnName = columnNamesRecord.get(i))) continue;
            throw new LicenseInventoryReportParseException.InvalidReportColumnException(String.format("Invalid license report: Unexpected column detected: %s, should be %s", actualColumnName, expectedColumnName), actualColumnName, expectedColumnName);
        }
    }

    private static String detectReportVersion(CSVRecord columnNamesRecord) {
        if (columnNamesRecord.size() < LicenseInventoryReportSchema.COLUMNS_COUNT_V2_REPORT) {
            return "V1";
        }
        String reportVersion = "V2";
        for (int i = LicenseInventoryReportSchema.LAST_COLUMN_IDX_V1_REPORT + 1; i <= LicenseInventoryReportSchema.LAST_COLUMN_IDX_V2_REPORT; ++i) {
            String actualColumnName;
            String expectedColumnName = LicenseInventoryReportSchema.Columns.values()[i].getColumnName();
            if (expectedColumnName.equalsIgnoreCase(actualColumnName = columnNamesRecord.get(i))) continue;
            reportVersion = "V1";
            break;
        }
        return reportVersion;
    }

    private static List<String> collectElements(Iterator<String> iterator) {
        ArrayList<String> elementsList = new ArrayList<String>();
        while (iterator.hasNext()) {
            elementsList.add(iterator.next());
        }
        return elementsList;
    }
}

