/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.impl;

import com.vmware.cis.license.common.misc.Util;
import com.vmware.license.myvmware.client.sync.internal.RecordWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;

public class CsvRecordWriterImpl
implements RecordWriter {
    private final CSVPrinter _csvPrinter;
    private final int _columnsCount;

    public CsvRecordWriterImpl(OutputStream outputStream, String[] columnNames) throws IOException {
        if (outputStream == null) {
            throw new IOException("OutputStream cannot be null");
        }
        if (Util.isNullOrEmpty((Object[])columnNames)) {
            throw new IOException("Columns names cannot be null or empty");
        }
        this._columnsCount = columnNames.length;
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        csvFormat = csvFormat.withQuoteMode(QuoteMode.ALL);
        this._csvPrinter = new CSVPrinter((Appendable)writer, csvFormat);
        this._csvPrinter.printRecord((Object[])columnNames);
    }

    @Override
    public void writeRecord(String[] recordValues) throws IOException {
        if (Util.isNullOrEmpty((Object[])recordValues)) {
            throw new IOException("Values cannot be null or empty");
        }
        if (recordValues.length != this._columnsCount) {
            throw new IOException("Values count does not match the columns count");
        }
        this._csvPrinter.printRecord((Object[])recordValues);
    }

    @Override
    public void writeEmptyLine() throws IOException {
        this._csvPrinter.println();
    }

    @Override
    public void flush() throws IOException {
        this._csvPrinter.flush();
    }

    @Override
    public void close() throws IOException {
        this._csvPrinter.close();
    }
}

