/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.myvmware.client.sync.internal.inactivekeys.impl;

import com.vmware.cis.license.common.misc.Util;
import com.vmware.license.myvmware.client.sync.internal.AccountDetails;
import com.vmware.license.myvmware.client.sync.internal.ActivityDetails;
import com.vmware.license.myvmware.client.sync.internal.LicenseKeyDetails;
import com.vmware.license.myvmware.client.sync.internal.RecordWriter;
import com.vmware.license.myvmware.client.sync.internal.RecordWriterFactory;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportData;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportGenerator;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.InactiveLicensesReportUtil;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.impl.InactiveLicensesReportGeneratorImpl;
import com.vmware.license.myvmware.client.sync.internal.inactivekeys.impl.InactiveLicensesReportSchema;
import com.vmware.license.myvmware.client.sync.internal.misc.ProductUtil;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.Product;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UpgradedLicensesReportGeneratorImpl
extends InactiveLicensesReportGeneratorImpl
implements InactiveLicensesReportGenerator {
    public UpgradedLicensesReportGeneratorImpl(RecordWriterFactory recordWriterFactory) {
        super(recordWriterFactory);
    }

    @Override
    protected boolean writeInactiveLicenseData(RecordWriter reportWriter, InactiveLicensesReportData inactiveLicenseData) throws IOException {
        List<LicenseKeyDetails> replacementMyVMwareLicenses = new ArrayList<LicenseKeyDetails>(inactiveLicenseData.replacementMyVMwareLicenseToDecodedLicenseInfo.keySet());
        assert (!Util.isNullOrEmpty(replacementMyVMwareLicenses));
        AccountDetails accountDetails = ((LicenseKeyDetails)replacementMyVMwareLicenses.get((int)0)).accountDetails;
        ActivityDetails activityDetails = InactiveLicensesReportUtil.findActivityForSerialKey(inactiveLicenseData.inactiveSerialKey, ((LicenseKeyDetails)replacementMyVMwareLicenses.get((int)0)).activityDetails);
        if (activityDetails.level > 1) {
            activityDetails = InactiveLicensesReportUtil.cloneActivityDetails(activityDetails);
            activityDetails.activity = "MULTIPLE";
        }
        replacementMyVMwareLicenses = UpgradedLicensesReportGeneratorImpl.filterMyVMwareLicensesForUpgrade(replacementMyVMwareLicenses, inactiveLicenseData.inactiveSerialKey);
        replacementMyVMwareLicenses = UpgradedLicensesReportGeneratorImpl.filterMyVMwareLicensesWithDifferentProductNames(replacementMyVMwareLicenses, inactiveLicenseData.inventoryLicense, inactiveLicenseData.replacementMyVMwareLicenseToDecodedLicenseInfo);
        return this.writeInactiveLicenseRecords(reportWriter, inactiveLicenseData.inactiveSerialKey, inactiveLicenseData.inventoryLicense, accountDetails, activityDetails, replacementMyVMwareLicenses);
    }

    private static List<LicenseKeyDetails> filterMyVMwareLicensesForUpgrade(List<LicenseKeyDetails> replacementMyVMwareLicenses, String inactiveSerialKey) {
        if (Util.isNullOrEmpty(replacementMyVMwareLicenses)) {
            return Collections.emptyList();
        }
        ArrayList<LicenseKeyDetails> upgradedMyVMwareLicenses = new ArrayList<LicenseKeyDetails>();
        for (LicenseKeyDetails myVMwareLicense : replacementMyVMwareLicenses) {
            ActivityDetails activityDetails = InactiveLicensesReportUtil.findActivityForSerialKey(inactiveSerialKey, myVMwareLicense.activityDetails);
            if (activityDetails == null || !UpgradedLicensesReportGeneratorImpl.isUpgradeActivity(activityDetails) && !UpgradedLicensesReportGeneratorImpl.containsUpgradeActivity(myVMwareLicense.activityDetails, activityDetails.level)) continue;
            upgradedMyVMwareLicenses.add(myVMwareLicense);
        }
        return upgradedMyVMwareLicenses;
    }

    private static List<LicenseKeyDetails> filterMyVMwareLicensesWithDifferentProductNames(List<LicenseKeyDetails> replacementMyVMwareLicenses, License inventoryLicense, Map<LicenseKeyDetails, LicenseInfo> replacementMyVmwareLicenseToDecodedLicenseInfo) {
        if (Util.isNullOrEmpty(replacementMyVMwareLicenses)) {
            return Collections.emptyList();
        }
        ArrayList<LicenseKeyDetails> filteredReplacementMyVMwareLicenses = new ArrayList<LicenseKeyDetails>();
        for (LicenseKeyDetails myVMwareLicense : replacementMyVMwareLicenses) {
            String replacementLicenseProductName;
            LicenseInfo replacementLicenseInfo = replacementMyVmwareLicenseToDecodedLicenseInfo.get(myVMwareLicense);
            String inventoryLicenseProductName = inventoryLicense.getInfo().getRestrictions()[0].getProduct().getName();
            if (replacementLicenseInfo != null && UpgradedLicensesReportGeneratorImpl.shouldCompareDecodedProductNames(inventoryLicense, replacementLicenseInfo)) {
                replacementLicenseProductName = replacementLicenseInfo.getRestrictions()[0].getProduct().getName();
                if (inventoryLicenseProductName.equals(replacementLicenseProductName)) continue;
                filteredReplacementMyVMwareLicenses.add(myVMwareLicense);
                continue;
            }
            replacementLicenseProductName = myVMwareLicense.productName;
            if (Util.isNullOrEmpty((String)replacementLicenseProductName) || inventoryLicenseProductName.contains(replacementLicenseProductName)) continue;
            filteredReplacementMyVMwareLicenses.add(myVMwareLicense);
        }
        return filteredReplacementMyVMwareLicenses;
    }

    private static boolean containsUpgradeActivity(ActivityDetails[] activitiesDetails, int maxActivityLevel) {
        if (Util.isNullOrEmpty((Object[])activitiesDetails)) {
            return false;
        }
        boolean containsUpgradeActivity = false;
        for (ActivityDetails activityDetails : activitiesDetails) {
            if (activityDetails.level < 0 || activityDetails.level >= maxActivityLevel || !UpgradedLicensesReportGeneratorImpl.isUpgradeActivity(activityDetails)) continue;
            containsUpgradeActivity = true;
            break;
        }
        return containsUpgradeActivity;
    }

    private static boolean isUpgradeActivity(ActivityDetails activityDetails) {
        if (Util.isNullOrEmpty((String)activityDetails.activity)) {
            return false;
        }
        return InactiveLicensesReportSchema.UPGRADE_ACTIVITIES.contains(activityDetails.activity.toUpperCase());
    }

    private static boolean shouldCompareDecodedProductNames(License inventoryLicense, LicenseInfo replacementLicenseInfo) {
        Product inventoryLicenseProduct = inventoryLicense.getInfo().getRestrictions()[0].getProduct();
        Product replacementLicenseProduct = replacementLicenseInfo.getRestrictions()[0].getProduct();
        return !ProductUtil.isVsanProduct(inventoryLicenseProduct) || !ProductUtil.isVsanProduct(replacementLicenseProduct);
    }
}

