/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.adapters.impl;

import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.option.BoolOption;
import com.vmware.vim.binding.vim.option.IntOption;
import com.vmware.vim.binding.vim.option.LongOption;
import com.vmware.vim.binding.vim.option.OptionDef;
import com.vmware.vim.binding.vim.option.OptionType;
import com.vmware.vim.binding.vim.option.StringOption;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.PathParam;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.storage.StorageDataService;
import com.vmware.vsphere.client.storage.adapters.AdvancedOptionTagObject;
import com.vmware.vsphere.client.storage.adapters.InternetScsiTargetsAdvancedSettingsRetrievalSpec;
import com.vmware.vsphere.client.storage.adapters.LocalizedInternetScsiTargetsAdvancedSettingsRetrievalSpec;
import com.vmware.vsphere.client.storage.adapters.impl.AdvancedOptionChangeSpec;
import com.vmware.vsphere.client.storage.adapters.impl.ApplyInternetScsiAdvancedSettingsSpec;
import com.vmware.vsphere.client.storage.adapters.impl.ApplyTargetAdvancedSettingsSpec;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.util.TypeNodeDescriptorCreationHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternetScsiHbaAdvancedSettingsProvider
implements PropertyProviderBean,
MutationProvider {
    private static final String HEADER_DIGEST_TAG = "headerDigestTag";
    private static final String DATA_DIGEST_TAG = "dataDigestTag";
    private static final String ARP_TAG = "arpTag";
    private static final String JUMBO_FRAMES_TAG = "jumboFramesTag";
    private static final String MTU_TAG = "mtuTag";
    private static final int MTU_MIN = 1280;
    private static final int MTU_MAX = 16000;
    private StorageDataService _storageDataService;
    private static Log _logger = LogFactory.getLog(InternetScsiHbaAdvancedSettingsProvider.class);

    public InternetScsiHbaAdvancedSettingsProvider(StorageDataService storageDataService) {
        this._storageDataService = storageDataService;
    }

    @ModelMetadata(type={"HostSystem"}, property="{adapterKey*}.internetScsiAdvancedSettings")
    public DynamicObject[] getInternetScsiAdvancedSettings(ManagedObjectReference hostRef, @PathParam(value="adapterKey") String adapterKey) throws Exception {
        StorageSystem hostStorageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        if (hostStorageSystem == null) {
            return new DynamicObject[0];
        }
        StorageDeviceInfo storageDeviceInfo = hostStorageSystem.getStorageDeviceInfo();
        if (storageDeviceInfo == null) {
            return new DynamicObject[0];
        }
        InternetScsiHba hba = (InternetScsiHba)this._storageDataService.getHostBusAdapterByKey(hostRef, adapterKey, storageDeviceInfo);
        if (hba == null) {
            return new DynamicObject[0];
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        if (hba.digestCapabilities != null) {
            InternetScsiHbaAdvancedSettingsProvider.fillDigestOptions(resultList, hba.digestCapabilities, hba.digestProperties);
        }
        if (hba.ipCapabilities != null) {
            InternetScsiHbaAdvancedSettingsProvider.fillIpOptions(resultList, hba);
        }
        if (hba.supportedAdvancedOptions != null && hba.advancedOptions != null) {
            for (int i = 0; i < hba.supportedAdvancedOptions.length; ++i) {
                OptionDef supportedOption = hba.supportedAdvancedOptions[i];
                resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForStandardOption(supportedOption, hba.advancedOptions));
            }
        }
        DynamicObject[] resultArray = new DynamicObject[resultList.size()];
        return resultList.toArray(resultArray);
    }

    @ModelMetadata(type={"HostSystem"}, property="{adapterKey*}.internetScsiAdvancedSettings.@info")
    public TypeNodeDescriptor getInternetScsiAdvancedSettingsInfo(ManagedObjectReference hostRef, @PathParam(value="adapterKey") String adapterKey) throws Exception {
        InternetScsiHba hba = (InternetScsiHba)this._storageDataService.getHostBusAdapterByKey(hostRef, adapterKey, null);
        if (hba == null) {
            return TypeNodeDescriptor.createArrayDescriptor((TypeNodeDescriptor[])new TypeNodeDescriptor[0]);
        }
        PropertyNodeDescriptor[] nodes = TypeNodeDescriptorCreationHelper.fillPropertyNodeDescriptorArray();
        ArrayList<TypeNodeDescriptor> resultList = new ArrayList<TypeNodeDescriptor>();
        if (hba.digestCapabilities != null) {
            InternetScsiHbaAdvancedSettingsProvider.describeDigestOptions(resultList, hba.digestCapabilities, hba.digestProperties, hba.isSoftwareBased, false, nodes);
        }
        if (hba.ipCapabilities != null) {
            InternetScsiHbaAdvancedSettingsProvider.describeIpOptions(resultList, hba, nodes);
        }
        if (hba.supportedAdvancedOptions != null && hba.advancedOptions != null) {
            for (int i = 0; i < hba.supportedAdvancedOptions.length; ++i) {
                OptionDef option = hba.supportedAdvancedOptions[i];
                resultList.add(TypeNodeDescriptorCreationHelper.getOptionTypeAndCreateDescriptor(option.optionType, false, nodes));
            }
        }
        TypeNodeDescriptor[] resultArray = new TypeNodeDescriptor[resultList.size()];
        resultArray = resultList.toArray(resultArray);
        return TypeNodeDescriptor.createArrayDescriptor((TypeNodeDescriptor[])resultArray);
    }

    private Map<String, Object> convertChangeSetToDataDrivenChangeSet(AdvancedOptionChangeSpec[] changeSet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (changeSet == null || changeSet.length == 0) {
            return result;
        }
        int i = 0;
        for (AdvancedOptionChangeSpec changeSpec : changeSet) {
            HashMap<String, Object> settingMap = new HashMap<String, Object>();
            AdvancedOptionTagObject tag = new AdvancedOptionTagObject();
            tag.optionKey = changeSpec.value.key;
            tag.optionValueType = "";
            Object value = changeSpec.value.value;
            if (HEADER_DIGEST_TAG.equals(changeSpec.value.key) || DATA_DIGEST_TAG.equals(changeSpec.value.key)) {
                value = new NameValuePair("", value);
            }
            settingMap.put("$tag", (Object)tag);
            settingMap.put("value", value);
            settingMap.put("inherited", changeSpec.inherited);
            result.put("" + i, settingMap);
            ++i;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference hostRef, ApplyInternetScsiAdvancedSettingsSpec spec) {
        return this.applyInternetScsiAdvancedSettings(hostRef, this.convertChangeSetToDataDrivenChangeSet(spec.changeSet), spec.adapterKey);
    }

    @MutationMapping(type="HostSystem", property="{adapterKey*}.internetScsiAdvancedSettings")
    public OperationResult applyInternetScsiAdvancedSettings(ManagedObjectReference hostRef, Map<String, Object> changeSet, @PathParam(value="adapterKey") String adapterKey) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        if (changeSet.size() <= 0) {
            return result;
        }
        InternetScsiHba hba = null;
        try {
            hba = (InternetScsiHba)this._storageDataService.getHostBusAdapterByKey(hostRef, adapterKey, null);
        }
        catch (Exception ex) {
            String message = StorageUtil.getLocalizedString("error.invalidAdapter", new String[]{adapterKey});
            _logger.error((Object)message, (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return result;
        }
        if (hba == null) {
            return result;
        }
        try {
            ArrayList<InternetScsiHba.ParamValue> advancedOptions = new ArrayList<InternetScsiHba.ParamValue>();
            HashMap<String, Object> specialOptions = new HashMap<String, Object>();
            for (Object setting : changeSet.values()) {
                Map settingMap = (Map)setting;
                AdvancedOptionTagObject tag = (AdvancedOptionTagObject)((Object)settingMap.get("$tag"));
                Object value = settingMap.get("value");
                if (InternetScsiHbaAdvancedSettingsProvider.isSpecialOption(tag.optionKey)) {
                    specialOptions.put(tag.optionKey, value);
                    continue;
                }
                if (value instanceof Integer && tag.optionValueType.equals(LongOption.class.getSimpleName())) {
                    advancedOptions.add(new InternetScsiHba.ParamValue(tag.optionKey, (Object)((Integer)value).longValue(), null));
                    continue;
                }
                advancedOptions.add(new InternetScsiHba.ParamValue(tag.optionKey, value, null));
            }
            StorageSystem storageSystem = null;
            if (specialOptions.size() > 0) {
                if (storageSystem == null) {
                    storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
                }
                InternetScsiHbaAdvancedSettingsProvider.updateSpecialOptions(storageSystem, hba, specialOptions);
            }
            if (advancedOptions.size() > 0) {
                if (storageSystem == null) {
                    storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
                }
                InternetScsiHba.ParamValue[] advancedOptionsArray = new InternetScsiHba.ParamValue[advancedOptions.size()];
                advancedOptionsArray = advancedOptions.toArray(advancedOptionsArray);
                storageSystem.updateInternetScsiAdvancedOptions(hba.device, null, advancedOptionsArray);
            }
        }
        catch (Exception e) {
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="internetScsiTargetAdvancedSettings")
    public DynamicObject[] getInternetScsiTargetAdvancedSettings(ManagedObjectReference hostRef, InternetScsiTargetsAdvancedSettingsRetrievalSpec spec) throws Exception {
        return this.retrieveInternetScsiTargetAdvancedSettings(hostRef, spec);
    }

    @ModelMetadata(type={"HostSystem"}, property="localizedInternetScsiTargetAdvancedSettings")
    public DynamicObject[] getLocalizedInternetScsiTargetAdvancedSettings(ManagedObjectReference hostRef, LocalizedInternetScsiTargetsAdvancedSettingsRetrievalSpec spec) throws Exception {
        return this.retrieveInternetScsiTargetAdvancedSettings(hostRef, spec);
    }

    @ModelMetadata(type={"HostSystem"}, property="internetScsiTargetAdvancedSettings.@info")
    public TypeNodeDescriptor getInternetScsiTargetAdvancedSettingsInfo(ManagedObjectReference hostRef, InternetScsiTargetsAdvancedSettingsRetrievalSpec spec) throws Exception {
        InternetScsiHba.SendTarget sendTarget = null;
        InternetScsiHba.StaticTarget staticTarget = null;
        if (spec.targetSet.sendTargets != null && spec.targetSet.sendTargets[0] != null) {
            sendTarget = spec.targetSet.sendTargets[0];
        } else if (spec.targetSet.staticTargets != null && spec.targetSet.staticTargets[0] != null) {
            staticTarget = spec.targetSet.staticTargets[0];
        } else {
            return TypeNodeDescriptor.createArrayDescriptor((TypeNodeDescriptor[])new TypeNodeDescriptor[0]);
        }
        PropertyNodeDescriptor[] nodes = TypeNodeDescriptorCreationHelper.fillPropertyNodeDescriptorArray();
        ArrayList<TypeNodeDescriptor> resultList = new ArrayList<TypeNodeDescriptor>();
        if (sendTarget != null) {
            if (spec.digestCapabilities != null) {
                InternetScsiHbaAdvancedSettingsProvider.describeDigestOptions(resultList, spec.digestCapabilities, sendTarget.digestProperties, spec.isSoftwareIScsi, true, nodes);
            }
            if (sendTarget.supportedAdvancedOptions != null && sendTarget.advancedOptions != null) {
                for (int i = 0; i < sendTarget.supportedAdvancedOptions.length; ++i) {
                    OptionDef optionDef = sendTarget.supportedAdvancedOptions[i];
                    InternetScsiHba.ParamValue option = InternetScsiHbaAdvancedSettingsProvider.getOption(sendTarget.advancedOptions, optionDef.key);
                    resultList.add(TypeNodeDescriptorCreationHelper.getOptionTypeAndCreateDescriptor(optionDef.optionType, option.isInherited != null, nodes));
                }
            }
            TypeNodeDescriptor[] resultArray = new TypeNodeDescriptor[resultList.size()];
            resultArray = resultList.toArray(resultArray);
            return TypeNodeDescriptor.createArrayDescriptor((TypeNodeDescriptor[])resultArray);
        }
        if (staticTarget != null) {
            if (spec.digestCapabilities != null) {
                InternetScsiHbaAdvancedSettingsProvider.describeDigestOptions(resultList, spec.digestCapabilities, staticTarget.digestProperties, spec.isSoftwareIScsi, true, nodes);
            }
            if (staticTarget.supportedAdvancedOptions != null && staticTarget.advancedOptions != null) {
                for (int i = 0; i < staticTarget.supportedAdvancedOptions.length; ++i) {
                    OptionDef optionDef = staticTarget.supportedAdvancedOptions[i];
                    InternetScsiHba.ParamValue option = InternetScsiHbaAdvancedSettingsProvider.getOption(staticTarget.advancedOptions, optionDef.key);
                    resultList.add(TypeNodeDescriptorCreationHelper.getOptionTypeAndCreateDescriptor(optionDef.optionType, option.isInherited != null, nodes));
                }
            }
            TypeNodeDescriptor[] resultArray = new TypeNodeDescriptor[resultList.size()];
            resultArray = resultList.toArray(resultArray);
            return TypeNodeDescriptor.createArrayDescriptor((TypeNodeDescriptor[])resultArray);
        }
        return TypeNodeDescriptor.createArrayDescriptor((TypeNodeDescriptor[])new TypeNodeDescriptor[0]);
    }

    public OperationResult apply(ManagedObjectReference hostRef, ApplyTargetAdvancedSettingsSpec spec) {
        return this.applyTargetAdvancedSettings(hostRef, spec.spec, this.convertChangeSetToDataDrivenChangeSet(spec.changeSet));
    }

    @MutationMapping(type="HostSystem", property="internetScsiTargetAdvancedSettings")
    public OperationResult applyTargetAdvancedSettings(ManagedObjectReference hostRef, InternetScsiTargetsAdvancedSettingsRetrievalSpec spec, Map<String, Object> changeSet) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        if (changeSet.size() <= 0) {
            return result;
        }
        InternetScsiHba.SendTarget sendTarget = null;
        InternetScsiHba.StaticTarget staticTarget = null;
        if (spec.targetSet.sendTargets != null && spec.targetSet.sendTargets[0] != null) {
            sendTarget = spec.targetSet.sendTargets[0];
        } else if (spec.targetSet.staticTargets != null && spec.targetSet.staticTargets[0] != null) {
            staticTarget = spec.targetSet.staticTargets[0];
        } else {
            return result;
        }
        try {
            ArrayList<InternetScsiHba.ParamValue> advancedOptions = new ArrayList<InternetScsiHba.ParamValue>();
            InternetScsiHba.DigestProperties digestProps = null;
            for (Object setting : changeSet.values()) {
                Map settingMap = (Map)setting;
                AdvancedOptionTagObject tag = (AdvancedOptionTagObject)((Object)settingMap.get("$tag"));
                String key = tag.optionKey;
                Object value = settingMap.get("value");
                Boolean inherited = (Boolean)settingMap.get("inherited");
                if (key.equals(HEADER_DIGEST_TAG) || key.equals(DATA_DIGEST_TAG)) {
                    NameValuePair valuePair;
                    if (digestProps == null) {
                        if (sendTarget != null) {
                            digestProps = sendTarget.digestProperties;
                        } else if (staticTarget != null) {
                            digestProps = staticTarget.digestProperties;
                        }
                    }
                    if (key.equals(HEADER_DIGEST_TAG)) {
                        valuePair = (NameValuePair)value;
                        if (valuePair != null) {
                            digestProps.headerDigestType = (String)valuePair.value;
                        }
                        if (inherited != null) {
                            digestProps.headerDigestInherited = (boolean)inherited;
                        }
                    }
                    if (!key.equals(DATA_DIGEST_TAG)) continue;
                    valuePair = (NameValuePair)value;
                    if (valuePair != null) {
                        digestProps.dataDigestType = (String)valuePair.value;
                    }
                    if (inherited == null) continue;
                    digestProps.dataDigestInherited = (boolean)inherited;
                    continue;
                }
                if (inherited == null || value == null) {
                    if (sendTarget != null) {
                        for (InternetScsiHba.ParamValue advancedOption : sendTarget.advancedOptions) {
                            if (!key.equals(advancedOption.key)) continue;
                            if (inherited == null) {
                                inherited = advancedOption.isInherited;
                            }
                            if (value != null) break;
                            value = advancedOption.value;
                            break;
                        }
                    } else if (staticTarget != null) {
                        for (InternetScsiHba.ParamValue advancedOption : staticTarget.advancedOptions) {
                            if (!key.equals(advancedOption.key)) continue;
                            if (inherited == null) {
                                inherited = advancedOption.isInherited;
                            }
                            if (value != null) break;
                            value = advancedOption.value;
                            break;
                        }
                    }
                }
                if (value instanceof Integer && tag.optionValueType.equals(LongOption.class.getSimpleName())) {
                    advancedOptions.add(new InternetScsiHba.ParamValue(tag.optionKey, (Object)((Integer)value).longValue(), Boolean.valueOf(inherited != null ? inherited : false)));
                    continue;
                }
                advancedOptions.add(new InternetScsiHba.ParamValue(tag.optionKey, value, Boolean.valueOf(inherited != null ? inherited : false)));
            }
            StorageSystem storageSystem = null;
            if (digestProps != null) {
                if (storageSystem == null) {
                    storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
                }
                storageSystem.updateInternetScsiDigestProperties(spec.device, spec.targetSet, digestProps);
            }
            if (advancedOptions.size() > 0) {
                if (storageSystem == null) {
                    storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
                }
                InternetScsiHba.ParamValue[] advancedOptionsArray = new InternetScsiHba.ParamValue[advancedOptions.size()];
                advancedOptionsArray = advancedOptions.toArray(advancedOptionsArray);
                storageSystem.updateInternetScsiAdvancedOptions(spec.device, spec.targetSet, advancedOptionsArray);
            }
        }
        catch (Exception e) {
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        return result;
    }

    private static ArrayList<DynamicObject> fillDigestOptions(ArrayList<DynamicObject> resultList, InternetScsiHba.DigestCapabilities caps, InternetScsiHba.DigestProperties props) {
        String label;
        if (caps.headerDigestSettable != null && caps.headerDigestSettable.booleanValue() && props.headerDigestType != null) {
            label = StorageUtil.getLocalizedString("iScsiAdvancedSettings.headerDigest");
            resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForSpecialOption(HEADER_DIGEST_TAG, label, InternetScsiHbaAdvancedSettingsProvider.getDigestLabel(props.headerDigestType), null, (OptionType)new StringOption()));
        }
        if (caps.dataDigestSettable != null && caps.dataDigestSettable.booleanValue() && props.dataDigestType != null) {
            label = StorageUtil.getLocalizedString("iScsiAdvancedSettings.dataDigest");
            resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForSpecialOption(DATA_DIGEST_TAG, label, InternetScsiHbaAdvancedSettingsProvider.getDigestLabel(props.dataDigestType), null, (OptionType)new StringOption()));
        }
        return resultList;
    }

    private static ArrayList<DynamicObject> fillTargetDigestOptions(ArrayList<DynamicObject> resultList, InternetScsiHba.DigestCapabilities caps, InternetScsiHba.DigestProperties props) {
        String label;
        if (caps.targetHeaderDigestSettable != null && caps.targetHeaderDigestSettable.booleanValue() && props.headerDigestType != null) {
            label = StorageUtil.getLocalizedString("iScsiAdvancedSettings.headerDigest");
            resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForSpecialOption(HEADER_DIGEST_TAG, label, InternetScsiHbaAdvancedSettingsProvider.getDigestLabel(props.headerDigestType), props.headerDigestInherited, (OptionType)new StringOption()));
        }
        if (caps.targetDataDigestSettable != null && caps.targetDataDigestSettable.booleanValue() && props.dataDigestType != null) {
            label = StorageUtil.getLocalizedString("iScsiAdvancedSettings.dataDigest");
            resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForSpecialOption(DATA_DIGEST_TAG, label, InternetScsiHbaAdvancedSettingsProvider.getDigestLabel(props.dataDigestType), props.dataDigestInherited, (OptionType)new StringOption()));
        }
        return resultList;
    }

    private static ArrayList<DynamicObject> fillIpOptions(ArrayList<DynamicObject> resultList, InternetScsiHba hba) {
        if (hba.ipCapabilities.arpRedirectSettable != null && hba.ipCapabilities.arpRedirectSettable.booleanValue() && hba.ipProperties.arpRedirectEnabled != null) {
            String label = StorageUtil.getLocalizedString("iScsiAdvancedSettings.arpRedirect");
            resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForSpecialOption(ARP_TAG, label, (boolean)hba.ipProperties.arpRedirectEnabled, null, (OptionType)new BoolOption()));
        }
        if (hba.ipCapabilities.mtuSettable != null && hba.ipCapabilities.mtuSettable.booleanValue() && hba.ipProperties.jumboFramesEnabled != null && hba.ipProperties.mtu != null) {
            String mtuLabel = StorageUtil.getLocalizedString("iScsiAdvancedSettings.mtu");
            resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForSpecialOption(MTU_TAG, mtuLabel, hba.ipProperties.mtu, null, (OptionType)new IntOption()));
        }
        return resultList;
    }

    private static DynamicObject createDynamicObjectForSpecialOption(String tag, String label, Object value, Boolean inherited, OptionType optionType) {
        DynamicObject dynObj = new DynamicObject();
        dynObj.tag = InternetScsiHbaAdvancedSettingsProvider.createTagObject(tag, optionType);
        String description = InternetScsiHbaAdvancedSettingsProvider.buildAdapterInfoDescription(label);
        dynObj.properties = inherited == null ? new NameValuePair[]{new NameValuePair("option", (Object)label), new NameValuePair("description", (Object)description), new NameValuePair("value", value)} : new NameValuePair[]{new NameValuePair("option", (Object)label), new NameValuePair("description", (Object)description), new NameValuePair("inherited", (Object)inherited), new NameValuePair("value", value)};
        return dynObj;
    }

    private static DynamicObject createDynamicObjectForStandardOption(OptionDef optionDef, InternetScsiHba.ParamValue[] options) {
        InternetScsiHba.ParamValue optionValue = InternetScsiHbaAdvancedSettingsProvider.getOption(options, optionDef.key);
        DynamicObject dynObj = new DynamicObject();
        dynObj.tag = InternetScsiHbaAdvancedSettingsProvider.createTagObject(optionValue.key, optionDef.optionType);
        dynObj.properties = optionValue.isInherited == null ? new NameValuePair[]{new NameValuePair("option", (Object)optionDef.label), new NameValuePair("description", (Object)optionDef.summary), new NameValuePair("value", optionValue.value)} : new NameValuePair[]{new NameValuePair("option", (Object)optionDef.label), new NameValuePair("description", (Object)optionDef.summary), new NameValuePair("inherited", (Object)optionValue.isInherited), new NameValuePair("value", optionValue.value)};
        return dynObj;
    }

    private static AdvancedOptionTagObject createTagObject(String key, OptionType type2) {
        AdvancedOptionTagObject tag = new AdvancedOptionTagObject();
        tag.optionKey = key;
        tag.optionValueType = type2.getClass().getSimpleName();
        return tag;
    }

    private static InternetScsiHba.ParamValue getOption(InternetScsiHba.ParamValue[] options, String key) {
        for (InternetScsiHba.ParamValue option : options) {
            if (!option.key.equals(key)) continue;
            return option;
        }
        return null;
    }

    private static String buildAdapterInfoDescription(String option) {
        return StorageUtil.getLocalizedString("iScsiAdvancedSettings.adapterOption", new String[]{option});
    }

    private static NameValuePair getDigestLabel(String digestValue) {
        String value = StorageUtil.getLocalizedString("iScsiAdvancedSettings." + digestValue);
        String key = "";
        if (digestValue.equals("digestProhibited")) {
            key = "digestProhibited";
        } else if (digestValue.equals("digestDiscouraged")) {
            key = "digestDiscouraged";
        } else if (digestValue.equals("digestPreferred")) {
            key = "digestPreferred";
        } else if (digestValue.equals("digestRequired")) {
            key = "digestRequired";
        }
        return new NameValuePair(value, (Object)key);
    }

    private static ArrayList<TypeNodeDescriptor> describeDigestOptions(ArrayList<TypeNodeDescriptor> resultList, InternetScsiHba.DigestCapabilities caps, InternetScsiHba.DigestProperties props, boolean softwareIScsi, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        if (caps.headerDigestSettable != null && caps.headerDigestSettable.booleanValue() && props.headerDigestType != null) {
            resultList.add(TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForDigestChoiceOption(softwareIScsi, inheritable, nodes));
        }
        if (caps.dataDigestSettable != null && caps.dataDigestSettable.booleanValue() && props.dataDigestType != null) {
            resultList.add(TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForDigestChoiceOption(softwareIScsi, inheritable, nodes));
        }
        return resultList;
    }

    private static ArrayList<TypeNodeDescriptor> describeIpOptions(ArrayList<TypeNodeDescriptor> resultList, InternetScsiHba hba, PropertyNodeDescriptor[] nodes) {
        if (hba.ipCapabilities.arpRedirectSettable != null && hba.ipCapabilities.arpRedirectSettable.booleanValue() && hba.ipProperties.arpRedirectEnabled != null) {
            resultList.add(TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForBoolean(nodes));
        }
        if (hba.ipCapabilities.mtuSettable != null && hba.ipCapabilities.mtuSettable.booleanValue() && hba.ipProperties.jumboFramesEnabled != null && hba.ipProperties.mtu != null) {
            resultList.add(TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForInt(1280, 16000, nodes));
        }
        return resultList;
    }

    private static boolean isSpecialOption(String tag) {
        if (tag.equals(HEADER_DIGEST_TAG)) {
            return true;
        }
        if (tag.equals(DATA_DIGEST_TAG)) {
            return true;
        }
        if (tag.equals(ARP_TAG)) {
            return true;
        }
        if (tag.equals(JUMBO_FRAMES_TAG)) {
            return true;
        }
        return tag.equals(MTU_TAG);
    }

    private static void updateSpecialOptions(StorageSystem storageSystem, InternetScsiHba hba, HashMap<String, Object> map) throws Exception {
        NameValuePair newValue;
        InternetScsiHba.DigestProperties digestProps = null;
        InternetScsiHba.IPProperties ipProps = null;
        if (map.containsKey(HEADER_DIGEST_TAG)) {
            newValue = (NameValuePair)map.get(HEADER_DIGEST_TAG);
            if (digestProps == null) {
                digestProps = hba.digestProperties;
            }
            digestProps.headerDigestType = (String)newValue.value;
        }
        if (map.containsKey(DATA_DIGEST_TAG)) {
            newValue = (NameValuePair)map.get(DATA_DIGEST_TAG);
            if (digestProps == null) {
                digestProps = hba.digestProperties;
            }
            digestProps.dataDigestType = (String)newValue.value;
        }
        if (map.containsKey(ARP_TAG)) {
            if (ipProps == null) {
                ipProps = InternetScsiHbaAdvancedSettingsProvider.createIpPropertiesSpec(hba.ipProperties);
            }
            ipProps.arpRedirectEnabled = (Boolean)map.get(ARP_TAG);
        }
        if (map.containsKey(MTU_TAG)) {
            if (ipProps == null) {
                ipProps = InternetScsiHbaAdvancedSettingsProvider.createIpPropertiesSpec(hba.ipProperties);
            }
            ipProps.mtu = (Integer)map.get(MTU_TAG);
        }
        if (digestProps != null) {
            storageSystem.updateInternetScsiDigestProperties(hba.device, null, digestProps);
        }
        if (ipProps != null) {
            storageSystem.updateInternetScsiIPProperties(hba.device, ipProps);
        }
    }

    private static InternetScsiHba.IPProperties createIpPropertiesSpec(InternetScsiHba.IPProperties ipProps) {
        InternetScsiHba.IPProperties result = new InternetScsiHba.IPProperties();
        result.dhcpConfigurationEnabled = ipProps.dhcpConfigurationEnabled;
        return result;
    }

    private DynamicObject[] retrieveInternetScsiTargetAdvancedSettings(ManagedObjectReference hostRef, InternetScsiTargetsAdvancedSettingsRetrievalSpec spec) throws Exception {
        InternetScsiHba.SendTarget sendTarget = null;
        InternetScsiHba.StaticTarget staticTarget = null;
        String addapterKey = null;
        if (spec instanceof LocalizedInternetScsiTargetsAdvancedSettingsRetrievalSpec) {
            addapterKey = ((LocalizedInternetScsiTargetsAdvancedSettingsRetrievalSpec)spec).addapterKey;
        }
        if (spec.targetSet.sendTargets != null && spec.targetSet.sendTargets[0] != null) {
            sendTarget = spec.targetSet.sendTargets[0];
            if (addapterKey != null) {
                sendTarget.supportedAdvancedOptions = this.getSupportedAdvancedOptions(hostRef, addapterKey);
            }
        } else if (spec.targetSet.staticTargets != null && spec.targetSet.staticTargets[0] != null) {
            staticTarget = spec.targetSet.staticTargets[0];
            if (addapterKey != null) {
                staticTarget.supportedAdvancedOptions = this.getSupportedAdvancedOptions(hostRef, addapterKey);
            }
        } else {
            return new DynamicObject[0];
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        if (sendTarget != null) {
            if (spec.digestCapabilities != null) {
                InternetScsiHbaAdvancedSettingsProvider.fillTargetDigestOptions(resultList, spec.digestCapabilities, sendTarget.digestProperties);
            }
            if (sendTarget.supportedAdvancedOptions != null && sendTarget.advancedOptions != null) {
                for (int i = 0; i < sendTarget.supportedAdvancedOptions.length; ++i) {
                    OptionDef supportedOption = sendTarget.supportedAdvancedOptions[i];
                    resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForStandardOption(supportedOption, sendTarget.advancedOptions));
                }
            }
            DynamicObject[] resultArray = new DynamicObject[resultList.size()];
            return resultList.toArray(resultArray);
        }
        if (staticTarget != null) {
            if (spec.digestCapabilities != null) {
                InternetScsiHbaAdvancedSettingsProvider.fillTargetDigestOptions(resultList, spec.digestCapabilities, staticTarget.digestProperties);
            }
            if (staticTarget.supportedAdvancedOptions != null && staticTarget.advancedOptions != null) {
                for (int i = 0; i < staticTarget.supportedAdvancedOptions.length; ++i) {
                    OptionDef supportedOption = staticTarget.supportedAdvancedOptions[i];
                    resultList.add(InternetScsiHbaAdvancedSettingsProvider.createDynamicObjectForStandardOption(supportedOption, staticTarget.advancedOptions));
                }
            }
            DynamicObject[] resultArray = new DynamicObject[resultList.size()];
            return resultList.toArray(resultArray);
        }
        return null;
    }

    private OptionDef[] getSupportedAdvancedOptions(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        OptionDef[] result = null;
        StorageSystem hostStorageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        StorageDeviceInfo sdi = hostStorageSystem.getStorageDeviceInfo();
        HostBusAdapter hostBusAdapter = this._storageDataService.getHostBusAdapterByKey(hostRef, adapterKey, sdi);
        if (hostBusAdapter instanceof InternetScsiHba) {
            result = ((InternetScsiHba)hostBusAdapter).getSupportedAdvancedOptions();
        }
        return result;
    }
}

