/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph;

import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextBuilder;
import com.vmware.ph.phservice.provider.vimcommon.VimContextProvider;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vsphere.client.ceip.util.Utils;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NgcVimContextProvider
implements VimContextProvider {
    private static final Log _log = LogFactory.getLog(NgcVimContextProvider.class);
    private final DsSessionSimulator _sessionSimulator;
    private final SolutionUserAuthenticationConfig _nonReadOnlyAuthenticationConfig;
    private final SolutionUserAuthenticationConfig _readOnlyAuthenticationConfig;
    private final KeystoreService _keystoreService;
    private final LookupService _lookupService;
    private final Object _lock = new Object();
    private VimContext _vimContext;

    public NgcVimContextProvider(DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig nonReadOnlyAuthenticationConfig, SolutionUserAuthenticationConfig readOnlyAuthenticationConfig, KeystoreService keystoreService, LookupService lookupService) {
        this._sessionSimulator = sessionSimulator;
        this._nonReadOnlyAuthenticationConfig = nonReadOnlyAuthenticationConfig;
        this._readOnlyAuthenticationConfig = readOnlyAuthenticationConfig;
        this._keystoreService = keystoreService;
        this._lookupService = lookupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VimContext getVimContext() {
        if (this._vimContext == null) {
            Object object = this._lock;
            synchronized (object) {
                if (this._vimContext == null) {
                    this._vimContext = this.buildVimContext();
                }
            }
        }
        return this._vimContext;
    }

    private static URI getVcSdkUri(VcService vcService) {
        URI vcSdkUri = null;
        if (vcService != null) {
            vcSdkUri = URI.create(vcService.getServiceUrl());
        }
        return vcSdkUri;
    }

    private static String getVcInstanceUuid(VcService vcService) {
        String vcInstanceUuid = null;
        if (vcService != null) {
            vcInstanceUuid = vcService.getServiceGuid();
        }
        return vcInstanceUuid;
    }

    private VimContext buildVimContext() {
        VcService vcService = this.getTargetVc();
        VimContextBuilder vimContextBuilder = VimContextBuilder.forVim((URI)URI.create(this._lookupService.getServiceUrl()), (KeyStore)this._keystoreService.getKeyStore()).withVcInstanceUuid(NgcVimContextProvider.getVcInstanceUuid(vcService)).withVcSdkUri(NgcVimContextProvider.getVcSdkUri(vcService)).withSsoSolutionUser(this._nonReadOnlyAuthenticationConfig.getSolutionCertificate(), (Key)this._nonReadOnlyAuthenticationConfig.getSolutionKey());
        return vimContextBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcService getTargetVc() {
        HttpServletRequest request = null;
        VcService targetVc = null;
        try {
            request = this._sessionSimulator.simulate(this._readOnlyAuthenticationConfig, "solution_user_vim_context_provider_simulation");
            LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
            targetVc = Utils.getVcService(vcGroupRegistry);
            this._sessionSimulator.close(request);
        }
        catch (SessionSimulationException e) {
            try {
                _log.debug((Object)"Failed to acquire VC Service. Cannot get VC SDK URL.", (Throwable)e);
                this._sessionSimulator.close(request);
            }
            catch (Throwable throwable) {
                this._sessionSimulator.close(request);
                throw throwable;
            }
        }
        return targetVc;
    }
}

