/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph;

import com.vmware.ph.VcConfiguration;
import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.ceip.util.Utils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleConfiguration {
    static final String KEY_COLLECTION_SCHEDULE = "VirtualCenter.DataCollector.Schedule";
    static final String UNKNOWN_SCHEDULE_SENTINEL = "";
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfiguration.class);
    private final DsSessionSimulator _sessionSimulator;
    private final CustomVcServiceTask.VcConfigurationFactory _vccFactory;
    private final SolutionUserAuthenticationConfig _authConfig;

    public ScheduleConfiguration(DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig) {
        this(sessionSimulator, new CustomVcServiceTask.VcConfigurationFactory(), authConfig);
    }

    ScheduleConfiguration(DsSessionSimulator sessionSimulator, CustomVcServiceTask.VcConfigurationFactory vccFactory, SolutionUserAuthenticationConfig authConfig) {
        this._sessionSimulator = sessionSimulator;
        this._vccFactory = vccFactory;
        this._authConfig = authConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchedule() {
        logger.debug("Getting shcedule configuration...");
        ThreadFactory threadFactory = this.createThreadFactory("ceip-get-schedule");
        ExecutorService executor = Executors.newFixedThreadPool(1, threadFactory);
        try {
            Future<String> f = executor.submit(new CustomVcServiceTask(this._sessionSimulator, this._authConfig, this._vccFactory){

                @Override
                String task() {
                    String value = (String)this._vcConfiguration.getVcConfigObject(ScheduleConfiguration.KEY_COLLECTION_SCHEDULE);
                    return value != null ? value : ScheduleConfiguration.UNKNOWN_SCHEDULE_SENTINEL;
                }
            });
            String scheduleConfig = f.get();
            logger.debug("Successfully retrieved shcedule configuration: {}", (Object)scheduleConfig);
            String string = scheduleConfig;
            return string;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.info("Failed getting shcedule configuration", (Throwable)e);
            String string = UNKNOWN_SCHEDULE_SENTINEL;
            return string;
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedule(final String schedule) {
        logger.debug("Setting shcedule configuration to '{}'...", (Object)schedule);
        ThreadFactory threadFactory = this.createThreadFactory("ceip-set-schedule");
        ExecutorService executor = Executors.newFixedThreadPool(1, threadFactory);
        try {
            Future<String> f = executor.submit(new CustomVcServiceTask(this._sessionSimulator, this._authConfig, this._vccFactory){

                @Override
                String task() {
                    this._vcConfiguration.setVcConfigValue(ScheduleConfiguration.KEY_COLLECTION_SCHEDULE, schedule);
                    return null;
                }
            });
            f.get();
            logger.debug("Successfully set the shcedule configuration to '{}'...", (Object)schedule);
        }
        catch (ExecutionException e) {
            logger.info("Failed setting shcedule configuration", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info("Failed setting shcedule configuration", (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
    }

    private ThreadFactory createThreadFactory(final String name) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(name);
                return t;
            }
        };
        return threadFactory;
    }

    static abstract class CustomVcServiceTask
    implements Callable<String> {
        VcConfiguration _vcConfiguration;
        private final DsSessionSimulator sessionSimulator;
        private final SolutionUserAuthenticationConfig authConfig;
        private final VcConfigurationFactory vccFactory;

        CustomVcServiceTask(DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig, VcConfigurationFactory vccFactory) {
            this.sessionSimulator = sessionSimulator;
            this.authConfig = authConfig;
            this.vccFactory = vccFactory;
        }

        abstract String task();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws SessionSimulationException {
            HttpServletRequest request = null;
            try {
                request = this.sessionSimulator.simulate(this.authConfig, "cmc_schedule_configuration_user");
                logger.debug("Getting LinkedVcGroupRegistry from the SessionUtil");
                LinkedVcGroupRegistry registry = (LinkedVcGroupRegistry)SessionUtil.getData((String)"LINKED_VC_GROUP_REGISTRY");
                VcService vcService = Utils.getVcService(registry);
                this._vcConfiguration = this.vccFactory.getVcConfiguration(vcService);
                logger.debug("Executing the external method against VcService with the following ServiceGuid: {}", (Object)vcService.getServiceGuid());
                String string = this.task();
                return string;
            }
            finally {
                logger.debug("Destroying session.");
                this.sessionSimulator.close(request);
            }
        }

        static class VcConfigurationFactory {
            VcConfigurationFactory() {
            }

            public VcConfiguration getVcConfiguration(VcService vcService) {
                return new VcConfiguration(vcService);
            }
        }
    }
}

