/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph;

import com.vmware.ph.ConfigirationException;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.exception.RemoteException;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(VcConfiguration.class);
    private final VcService _vcService;

    public VcConfiguration(VcService vcService) {
        this._vcService = vcService;
    }

    public Object getVcConfigObject(String key) {
        OptionValue[] result;
        this.verifyVcIsSet();
        OptionManager optionManager = this.createVcSettingStub();
        if (optionManager == null) {
            throw new ConfigirationException("Cannot initialize OptionManager");
        }
        logger.debug("Retrieving value for " + key);
        try {
            result = optionManager.queryView(key);
        }
        catch (InvalidName e) {
            throw new ConfigirationException(this.mkInvalidNameMessage(key), e);
        }
        catch (NoPermission e) {
            throw e;
        }
        catch (RuntimeFault e) {
            throw this.optionQueryError(key, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw this.optionQueryError(key, (Exception)((Object)e));
        }
        logger.debug("Got {} result(s).", (Object)result.length);
        Object firstResult = result.length > 0 ? result[0].getValue() : null;
        logger.debug("Retrieved {} = {}", (Object)key, firstResult);
        return firstResult;
    }

    public void setVcConfigValue(String key, Object value) {
        this.verifyVcIsSet();
        OptionManager optionManager = this.createVcSettingStub();
        if (optionManager == null) {
            throw new ConfigirationException("Cannot initialize OptionManager");
        }
        logger.debug("Updating {} = {} ...", (Object)key, value);
        try {
            OptionValue optionValue = new OptionValue(key, value);
            optionManager.updateValues(new OptionValue[]{optionValue});
        }
        catch (InvalidName e) {
            throw new ConfigirationException(String.format("vCenter service does not support configuration key `%s' (incompatible vCenter version)", key), e);
        }
        catch (RuntimeFault e) {
            throw this.optionStoreError(key, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw this.optionStoreError(key, (Exception)((Object)e));
        }
        logger.debug("Updated {} = {}", (Object)key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionManager createVcSettingStub() {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(thisClassLoader);
        try {
            OptionManager optionManager;
            ManagedObjectReference vcSettingsId = this._vcService.getServiceInstanceContent().getSetting();
            OptionManager optionManager2 = optionManager = (OptionManager)this._vcService.getManagedObject(vcSettingsId);
            return optionManager2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    private String mkInvalidNameMessage(String optionKey) {
        return "vCenter Service doesn't support collector configuration option: " + optionKey;
    }

    private ConfigirationException optionStoreError(String optionKey, Exception error) {
        return this.optionOpErrorMessage("storing", optionKey, error);
    }

    private ConfigirationException optionQueryError(String optionKey, Exception error) {
        return this.optionOpErrorMessage("retrieving", optionKey, error);
    }

    private ConfigirationException optionOpErrorMessage(String action, String optionKey, Exception error) {
        String msg = String.format("Error %s collector config option %s: %s: %s", action, optionKey, error.getClass().getName(), error.getMessage());
        return new ConfigirationException(msg, error);
    }

    void verifyVcIsSet() {
        if (this._vcService == null) {
            throw new UnsupportedOperationException("No vCenter Service is set for this ScheduleConfiguration object. vCenter settings opetations are unsupported.");
        }
    }
}

