/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.impl;

import com.vmware.ph.phservice.ceip.CeipApiProvider;
import com.vmware.ph.phservice.ceip.CeipSynchronizer;
import com.vmware.ph.phservice.ceip.impl.DefaultCeipSynchronizer;
import com.vmware.vise.util.client.configuration.ConfigurationService;

public class ConfigurableCeipSynchronizerWrapper
implements CeipSynchronizer {
    private static final String DEV_CEIP_SYNC_PERIOD_MILLIS = "dev.ceipSynchronizer.syncPeriod.millis";
    private final CeipSynchronizer _wrappedCeipSynchronizer;

    public ConfigurableCeipSynchronizerWrapper(int defaultSyncPeriodMillis, CeipApiProvider ceipApiProvider, ConfigurationService configurationService) {
        this._wrappedCeipSynchronizer = ConfigurableCeipSynchronizerWrapper.initCeipSynchronzier(defaultSyncPeriodMillis, ceipApiProvider, configurationService);
    }

    ConfigurableCeipSynchronizerWrapper(CeipSynchronizer wrappedCeipSynchronizer) {
        this._wrappedCeipSynchronizer = wrappedCeipSynchronizer;
    }

    public void start() {
        this._wrappedCeipSynchronizer.start();
    }

    public void stop() {
        if (this._wrappedCeipSynchronizer != null) {
            this._wrappedCeipSynchronizer.stop();
        }
    }

    private static CeipSynchronizer initCeipSynchronzier(int defaultSyncPeriodMillis, CeipApiProvider ceipApiProvider, ConfigurationService configurationService) {
        String devSyncPeriodMillis = configurationService.getProperty(DEV_CEIP_SYNC_PERIOD_MILLIS);
        int syncPeriodMillis = devSyncPeriodMillis != null ? Integer.valueOf(devSyncPeriodMillis) : defaultSyncPeriodMillis;
        DefaultCeipSynchronizer wrappedCeipSynchronizer = new DefaultCeipSynchronizer(syncPeriodMillis, ceipApiProvider);
        return wrappedCeipSynchronizer;
    }
}

