/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class ParsingUtils {
    ParsingUtils() {
    }

    static int countProvidedAttributeValues(Element element, String ... values) {
        int count = 0;
        for (String s : values) {
            if (!StringUtils.hasText((String)element.getAttribute(s))) continue;
            ++count;
        }
        return count;
    }

    static void mapAllAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        new SimpleBeanDefinitionParser().mapToBuilder(element, parserContext, builder);
    }

    static void mapOptionalAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String ... attrs) {
        for (String attr : attrs) {
            String propertyName;
            String value = element.getAttribute(attr);
            if (!StringUtils.hasText((String)value) || !ParsingUtils.validateProperty(element, parserContext, propertyName = Conventions.attributeNameToPropertyName((String)attr), attr)) continue;
            builder.addPropertyValue(propertyName, (Object)value);
        }
    }

    static void mapOptionalBeanRefAttributes(Element element, BeanDefinitionBuilder builder, ParserContext parserContext, String ... attrs) {
        for (String attr : attrs) {
            String propertyName;
            String value = element.getAttribute(attr);
            if (!StringUtils.hasText((String)value) || !ParsingUtils.validateProperty(element, parserContext, propertyName = Conventions.attributeNameToPropertyName((String)attr), attr)) continue;
            builder.addPropertyReference(propertyName, value);
        }
    }

    static void mapRequiredAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String ... attrs) {
        for (String attr : attrs) {
            String value = element.getAttribute(attr);
            if (!ParsingUtils.validateRequiredAttribute(element, parserContext, attr)) {
                return;
            }
            String propertyName = Conventions.attributeNameToPropertyName((String)attr);
            if (!ParsingUtils.validateProperty(element, parserContext, propertyName, attr)) continue;
            builder.addPropertyValue(propertyName, (Object)value);
        }
    }

    static void mapRequiredBeanRefAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String ... attrs) {
        for (String attr : attrs) {
            String value = element.getAttribute(attr);
            if (!ParsingUtils.validateRequiredAttribute(element, parserContext, attr)) {
                return;
            }
            String propertyName = Conventions.attributeNameToPropertyName((String)attr);
            if (!ParsingUtils.validateProperty(element, parserContext, propertyName, attr)) continue;
            builder.addPropertyReference(propertyName, value);
        }
    }

    static String registerInfrastructureComponent(Element element, ParserContext parserContext, BeanDefinitionBuilder componentBuilder) {
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)componentBuilder.getRawBeanDefinition());
        ParsingUtils.registerInfrastructureComponent(element, parserContext, componentBuilder, beanName);
        return beanName;
    }

    static void registerInfrastructureComponent(Element element, ParserContext parserContext, BeanDefinitionBuilder componentBuilder, String beanName) {
        componentBuilder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        componentBuilder.getRawBeanDefinition().setRole(2);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)componentBuilder.getBeanDefinition(), beanName));
    }

    private static boolean validateRequiredAttribute(Element element, ParserContext parserContext, String attr) {
        if (!StringUtils.hasText((String)attr)) {
            parserContext.getReaderContext().error("The '" + attr + "' attribute is required.", parserContext.extractSource((Object)element));
            return false;
        }
        return true;
    }

    private static boolean validateProperty(Element element, ParserContext parserContext, String propertyName, String attr) {
        if (!StringUtils.hasText((String)propertyName)) {
            parserContext.getReaderContext().error("Illegal property name trying to convert from attribute '" + attr + "' : cannot be null or empty.", parserContext.extractSource((Object)element));
            return false;
        }
        return true;
    }

    private static class SimpleBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private SimpleBeanDefinitionParser() {
        }

        protected void mapToBuilder(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            try {
                this.doParse(element, parserContext, builder);
            }
            catch (Exception ex) {
                parserContext.getReaderContext().error(ex.getMessage(), parserContext.extractSource((Object)element), (Throwable)ex);
            }
        }
    }
}

