/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core.io;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.flex.core.io.AbstractAmfConversionServiceConfigProcessor;
import org.springframework.flex.core.io.HibernateProxyConverter;
import org.springframework.flex.core.io.PersistentCollectionConverterFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateConfigProcessor
extends AbstractAmfConversionServiceConfigProcessor
implements BeanFactoryAware,
InitializingBean {
    private Set<ClassMetadata> classMetadata = new HashSet<ClassMetadata>();
    private Set<CollectionMetadata> collectionMetadata = new HashSet<CollectionMetadata>();
    private ListableBeanFactory beanFactory;
    protected boolean hibernateConfigured = false;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (!this.hibernateConfigured && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.getBeanFactory(), SessionFactory.class).length > 0) {
            for (SessionFactory sessionFactory : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, SessionFactory.class).values()) {
                this.extractHibernateMetadata(sessionFactory);
            }
        }
        super.afterPropertiesSet();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ListableBeanFactory.class, (Object)beanFactory, (String)"HibernateConfigProcessor must be used in a ListableBeanFactory in order to auto-detect the necessary Hibernate configuration.");
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.extractHibernateMetadata(sessionFactory);
    }

    @Override
    protected Set<Class<?>> findTypesToRegister() {
        HashSet typesToRegister = new HashSet();
        if (this.hibernateConfigured) {
            for (ClassMetadata classMetadata : this.classMetadata) {
                if (classMetadata.getMappedClass(EntityMode.POJO).isInterface()) continue;
                typesToRegister.add(classMetadata.getMappedClass(EntityMode.POJO));
                this.findComponentProperties(classMetadata.getPropertyTypes(), typesToRegister);
            }
            for (CollectionMetadata collectionMetadata : this.collectionMetadata) {
                Type elementType = collectionMetadata.getElementType();
                if (!(elementType instanceof ComponentType) || elementType.getReturnedClass().isInterface()) continue;
                typesToRegister.add(elementType.getReturnedClass());
                this.findComponentProperties(((ComponentType)elementType).getSubtypes(), typesToRegister);
            }
        }
        return typesToRegister;
    }

    @Override
    protected void configureConverters(ConverterRegistry registry) {
        registry.addConverter((GenericConverter)new HibernateProxyConverter());
        registry.addConverterFactory((ConverterFactory)new PersistentCollectionConverterFactory());
    }

    protected ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected void extractHibernateMetadata(SessionFactory sessionFactory) {
        this.classMetadata.addAll(sessionFactory.getAllClassMetadata().values());
        this.collectionMetadata.addAll(sessionFactory.getAllCollectionMetadata().values());
        this.hibernateConfigured = true;
    }

    private void findComponentProperties(Type[] propertyTypes, Set<Class<?>> typesToRegister) {
        if (propertyTypes == null) {
            return;
        }
        for (Type propertyType : propertyTypes) {
            if (!(propertyType instanceof ComponentType)) continue;
            typesToRegister.add(propertyType.getReturnedClass());
            this.findComponentProperties(((ComponentType)propertyType).getSubtypes(), typesToRegister);
        }
    }
}

