/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core.io;

import java.lang.reflect.Method;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.flex.core.io.HibernateConfigProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class JpaHibernateConfigProcessor
extends HibernateConfigProcessor {
    public void afterPropertiesSet() throws Exception {
        if (!this.hibernateConfigured) {
            for (EntityManagerFactory entityManagerFactory : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getBeanFactory(), EntityManagerFactory.class).values()) {
                this.setEntityManagerFactory(entityManagerFactory);
            }
        }
        super.afterPropertiesSet();
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        Method gsfMethod = ReflectionUtils.findMethod(entityManagerFactory.getClass(), (String)"getSessionFactory");
        Assert.notNull((Object)gsfMethod, (String)"Could not retrieve the underlying Hibernate SessionFactory from the provided EntityManagerFactory");
        this.setSessionFactory((SessionFactory)ReflectionUtils.invokeMethod((Method)gsfMethod, (Object)entityManagerFactory));
    }
}

