/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.util.ArrayList;
import org.springframework.flex.core.MessageInterceptor;
import org.springframework.flex.core.MessageProcessingContext;
import org.springframework.flex.security3.EndpointSecurityMetadataSource;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointInterceptor
extends AbstractSecurityInterceptor
implements MessageInterceptor {
    private static final String STATUS_TOKEN = "_enpointInterceptorStatusToken";
    private EndpointSecurityMetadataSource securityMetadataSource;

    public void afterPropertiesSet() throws Exception {
        if (this.getAccessDecisionManager() == null) {
            this.configureDefaultAccessDecisionManager();
        }
        super.afterPropertiesSet();
    }

    public EndpointSecurityMetadataSource getObjectDefinitionSource() {
        return this.securityMetadataSource;
    }

    public Class<?> getSecureObjectClass() {
        return AbstractEndpoint.class;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    @Override
    public Message postProcess(MessageProcessingContext context, Message inputMessage, Message outputMessage) {
        if (context.getAttributes().containsKey(STATUS_TOKEN)) {
            InterceptorStatusToken token = (InterceptorStatusToken)context.getAttributes().get(STATUS_TOKEN);
            return (Message)this.afterInvocation(token, outputMessage);
        }
        return outputMessage;
    }

    @Override
    public Message preProcess(MessageProcessingContext context, Message inputMessage) {
        if (!this.isPassThroughCommand(inputMessage)) {
            InterceptorStatusToken token = this.beforeInvocation(context.getMessageTarget());
            context.getAttributes().put(STATUS_TOKEN, token);
        }
        return inputMessage;
    }

    public void setObjectDefinitionSource(EndpointSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
    }

    private void configureDefaultAccessDecisionManager() {
        AffirmativeBased adm = new AffirmativeBased();
        ArrayList<Object> voters = new ArrayList<Object>();
        voters.add(new RoleVoter());
        voters.add(new AuthenticatedVoter());
        adm.setDecisionVoters(voters);
        this.setAccessDecisionManager((AccessDecisionManager)adm);
    }

    private boolean isPassThroughCommand(Message message) {
        if (message instanceof CommandMessage) {
            CommandMessage command = (CommandMessage)message;
            return command.getOperation() == 5 || command.getOperation() == 8;
        }
        return false;
    }
}

