/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.ConfigSpecOperation;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.ProductSpec;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.compositecommand.CommandExecutionEngine;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.network.NetworkCommandFactory;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupReconfigureCommandSpec;
import com.vmware.vsphere.client.dvs.ProductSpecWrapperSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsApplyProductSpecCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsConfigSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsCreateCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsHostRemoveSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsReconfigureCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvsResControlUpgradeSpec;
import com.vmware.vsphere.client.dvs.api.spec.LacpUpgradeSpec;
import com.vmware.vsphere.client.dvs.api.spec.LacpUpgradeVersionCommandSpec;
import com.vmware.vsphere.client.dvs.impl.DvsResControlUpgradeCommandBuilder;
import com.vmware.vsphere.client.dvs.lacp.specs.LacpLegacyConfigRemoveCommandSpec;
import com.vmware.vsphere.client.dvs.lacp.specs.LacpPhysicalNicReassignCommandSpec;
import com.vmware.vsphere.client.dvs.lacp.specs.LagCreateCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsAddNetworkResourcePoolSpec;
import com.vmware.vsphere.client.dvs.specs.DvsHostRectifySpec;
import com.vmware.vsphere.client.dvs.specs.DvsRemoveNetworkResourcePoolSpec;
import com.vmware.vsphere.client.dvs.specs.DvsUpdateHealthCheckSpec;
import com.vmware.vsphere.client.dvs.specs.DvsUpdateNetworkResourcePoolSpec;
import com.vmware.vsphere.client.dvs.specs.LacpConfigSpec;
import com.vmware.vsphere.client.networking.util.I18nUtil;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsMutationProvider
implements MutationProvider {
    private static final String RELATION_DVS_PORT_GROUP = "portgroup";
    private static final String PROP_DVS_UUID = "uuid";
    private static final String PROP_DVS_CONFIG_VERSION = "config.configVersion";
    private static final String PROP_DVS_HOSTS = "host";
    private static final String PROP_PORT_GROUP_CONFIG_VERSION = "config.configVersion";
    private static final String PROP_PORT_GROUP_TEAMING = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].uplinkTeamingPolicy";
    private static final Log _logger = LogFactory.getLog(DvsMutationProvider.class);
    private DataService _dataService;

    public DvsMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult apply(ManagedObjectReference mor, DvsConfigSpec spec) {
        assert (mor != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = mor;
        try {
            VmwareDistributedVirtualSwitch dvs = (VmwareDistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            if (spec.configSpec != null) {
                result.task = dvs.reconfigure((DistributedVirtualSwitch.ConfigSpec)spec.configSpec);
            }
            if (spec.enableResourceManagement != null) {
                dvs.enableNetworkResourceManagement(spec.enableResourceManagement.booleanValue());
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot perform a DVS operation. ", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DistributedVirtualSwitch.ConfigSpec spec) {
        assert (dvsRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
            ManagedObjectReference task = dvs.reconfigure(spec);
            result.task = task;
        }
        catch (Exception e) {
            _logger.error((Object)("Could not reconfigure DVS " + ManagedObjectUtil.morefToString((ManagedObjectReference)dvsRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsReconfigureCommandSpec dvsReconfigCommandSpec) {
        NetworkCommandFactory commandFactory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)dvsReconfigCommandSpec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        return engine.getResult();
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DistributedVirtualPort.ConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
            result.task = dvs.reconfigurePort(new DistributedVirtualPort.ConfigSpec[]{spec});
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult add(DvsCreateCommandSpec spec) {
        NetworkCommandFactory commandFactory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)spec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        return engine.getResult();
    }

    @Deprecated
    public OperationResult apply(ManagedObjectReference dvsRef, ProductSpec productSpec) {
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
            result.task = dvs.performProductSpecOperation(DistributedVirtualSwitch.ProductSpecOperationType.upgrade.toString(), productSpec);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsApplyProductSpecCommandSpec commandSpec) {
        NetworkCommandFactory commandFactory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)commandSpec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        return engine.getResult();
    }

    @Deprecated
    public OperationResult apply(ManagedObjectReference dvsRef, ProductSpecWrapperSpec wrappedProductSpec) {
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
            result.task = dvs.performProductSpecOperation(DistributedVirtualSwitch.ProductSpecOperationType.proceedWithUpgrade.toString(), wrappedProductSpec.dvsProductSpec);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsHostRemoveSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        if (spec == null) {
            _logger.error((Object)"DvsHostRemoveSpec cannot be null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        if (spec.hosts == null) {
            _logger.error((Object)"DvsHostRemoveSpec.hosts cannot be null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
            DistributedVirtualSwitch.ConfigInfo dvsConfig = dvs.getConfig();
            if (dvsConfig == null) {
                _logger.error((Object)"The config spec of the dvs cannot be null");
                result.error = MixedUtil.getInvalidEntityFault();
                return result;
            }
            DistributedVirtualSwitch.ConfigSpec dvsConfigSpec = new DistributedVirtualSwitch.ConfigSpec();
            dvsConfigSpec.configVersion = dvsConfig.configVersion;
            ArrayList<HostMember.ConfigSpec> hostSpecs = new ArrayList<HostMember.ConfigSpec>(spec.hosts.length);
            for (ManagedObjectReference hostSystem : spec.hosts) {
                HostMember.ConfigSpec hostSpec = new HostMember.ConfigSpec();
                hostSpec.host = hostSystem;
                hostSpec.operation = ConfigSpecOperation.remove.toString();
                hostSpecs.add(hostSpec);
            }
            dvsConfigSpec.host = hostSpecs.toArray(new HostMember.ConfigSpec[hostSpecs.size()]);
            result.task = dvs.reconfigure(dvsConfigSpec);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsHostRectifySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        if (spec == null) {
            _logger.error((Object)"DvsHostRectifySpec cannot be null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
            result.task = dvs.rectifyHost(spec.hosts);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsAddNetworkResourcePoolSpec spec) {
        NetworkCommandFactory commandFactory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)spec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        return engine.getResult();
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsUpdateNetworkResourcePoolSpec spec) {
        NetworkCommandFactory commandFactory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)spec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        return engine.getResult();
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsRemoveNetworkResourcePoolSpec spec) {
        NetworkCommandFactory commandFactory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)spec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        return engine.getResult();
    }

    public OperationResult apply(ManagedObjectReference dvsRef, VmVnicNetworkResourcePool.ConfigSpec spec) {
        assert (dvsRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
            VmVnicNetworkResourcePool.ConfigSpec[] configSpecs = new VmVnicNetworkResourcePool.ConfigSpec[]{spec};
            dvs.reconfigureVmVnicNetworkResourcePool(configSpecs);
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot update VM Vnic Resource Pool. ", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference contextObjectRef, DummyCommandSpec rootCommandSpec) {
        NetworkCommandFactory commandFactory = new NetworkCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)rootCommandSpec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        OperationResult operationResult = engine.getResult();
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference contextObjectRef, DvsUpdateHealthCheckSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = contextObjectRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)contextObjectRef);
            DistributedVirtualSwitch.HealthCheckConfig[] config = spec.config;
            if (config != null && config.length > 0) {
                result.task = dvs.updateHealthCheckConfig(spec.config);
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = e;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference contextObjectRef, LacpConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = contextObjectRef;
        try {
            VmwareDistributedVirtualSwitch dvs = (VmwareDistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)contextObjectRef);
            dvs.updateLacpGroupConfig(spec.groups);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = e;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsResControlUpgradeSpec spec) {
        try {
            BaseCommandSpec commandSpec = new DvsResControlUpgradeCommandBuilder(this._dataService, dvsRef, spec).build();
            NetworkCommandFactory commandFactory = new NetworkCommandFactory();
            CommandExecutionEngine engine = new CommandExecutionEngine(commandSpec, this._dataService, (CommandFactory)commandFactory);
            engine.execute();
            OperationResult result = engine.getResult();
            if (!engine.isExecutionSuccessful()) {
                result.error = new Exception(I18nUtil.text("resControl.upgrade.commandFaiure", new String[0]));
            }
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            OperationResult opResult = new OperationResult();
            opResult.entity = dvsRef;
            opResult.error = ex;
            return opResult;
        }
    }

    public OperationResult apply(ManagedObjectReference dvsRef, LacpUpgradeSpec spec) {
        try {
            BaseCommandSpec commandSpec = this.buildLacpUpgradeCommandSpec(dvsRef, spec);
            NetworkCommandFactory commandFactory = new NetworkCommandFactory();
            CommandExecutionEngine engine = new CommandExecutionEngine(commandSpec, this._dataService, (CommandFactory)commandFactory);
            engine.execute();
            OperationResult result = engine.getResult();
            if (!engine.isExecutionSuccessful()) {
                result.error = new Exception(I18nUtil.text("lacp.upgrade.commandFailure", new String[0]));
            }
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            OperationResult opResult = new OperationResult();
            opResult.entity = dvsRef;
            opResult.error = ex;
            return opResult;
        }
    }

    private BaseCommandSpec buildLacpUpgradeCommandSpec(ManagedObjectReference dvsRef, LacpUpgradeSpec spec) throws Exception {
        LacpUpgradeVersionCommandSpec versionUpgradeSpec = this.createLacpVersionUpgradeCommandSpec(dvsRef);
        if (spec.lag != null) {
            LagCreateCommandSpec lagCreateSpec = new LagCreateCommandSpec();
            lagCreateSpec.mor = dvsRef;
            lagCreateSpec.lag = spec.lag;
            versionUpgradeSpec.dependentSpecs = new BaseCommandSpec[]{lagCreateSpec};
            Map<Object, Map<String, Object>> rs = this.retrievePortGroupTeaming(dvsRef);
            List<DvPortgroupReconfigureCommandSpec> mixedModeTeamingPgSpecs = this.createLacpMixedModeTeamingDvPortgroupSpecs(rs, spec.lag.name);
            List<LacpPhysicalNicReassignCommandSpec> hostSpecs = this.createLacpReassignmentHostSpecs(dvsRef, spec.lag.name);
            ArrayList<BaseCommandSpec> mergedSpecs = new ArrayList<BaseCommandSpec>(mixedModeTeamingPgSpecs.size() + hostSpecs.size());
            mergedSpecs.addAll(mixedModeTeamingPgSpecs);
            mergedSpecs.addAll(hostSpecs);
            DvsMutationProvider.chainCommandSpecs(mergedSpecs);
            LacpLegacyConfigRemoveCommandSpec legacyConfigRemoveSpec = new LacpLegacyConfigRemoveCommandSpec();
            legacyConfigRemoveSpec.mor = dvsRef;
            if (!mergedSpecs.isEmpty()) {
                lagCreateSpec.dependentSpecs = new BaseCommandSpec[]{(BaseCommandSpec)mergedSpecs.get(0)};
                ((BaseCommandSpec)mergedSpecs.get((int)(mergedSpecs.size() - 1))).dependentSpecs = new BaseCommandSpec[]{legacyConfigRemoveSpec};
            } else {
                lagCreateSpec.dependentSpecs = new BaseCommandSpec[]{legacyConfigRemoveSpec};
            }
            DvPortgroupReconfigureCommandSpec[] recommendedTeamingPgSpecs = this.toArray(this.createLacpRecommendedTeamingDvPortgroupSpecs(rs, spec.lag.name));
            legacyConfigRemoveSpec.dependentSpecs = recommendedTeamingPgSpecs;
        }
        return versionUpgradeSpec;
    }

    private Map<Object, Map<String, Object>> retrievePortGroupTeaming(ManagedObjectReference dvsRef) throws Exception {
        String pgType = DistributedVirtualPortgroup.class.getSimpleName();
        ObjectIdentityConstraint dvsConstraint = QueryUtil.createObjectIdentityConstraint((Object)dvsRef);
        RelationalConstraint dvsPortGroupConstraint = QueryUtil.createRelationalConstraint((String)RELATION_DVS_PORT_GROUP, (Constraint)dvsConstraint, (Boolean)true, (String)pgType);
        PropertyConstraint nonUplinkConstraint = QueryUtil.createPropertyConstraint((String)pgType, (String)"isUplinkPortgroup", (Comparator)Comparator.EQUALS, (Object)false);
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dvsPortGroupConstraint, nonUplinkConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"config.configVersion", PROP_PORT_GROUP_TEAMING});
        Map<Object, Map<String, Object>> rs = Util.resultSetToMap(QueryUtil.getData((DataService)this._dataService, (QuerySpec)query));
        return rs;
    }

    public DvPortgroupReconfigureCommandSpec[] toArray(List<DvPortgroupReconfigureCommandSpec> specList) {
        return specList.toArray(new DvPortgroupReconfigureCommandSpec[specList.size()]);
    }

    private static void chainCommandSpecs(Iterable<BaseCommandSpec> specList) {
        BaseCommandSpec previousSpec = null;
        for (BaseCommandSpec spec : specList) {
            if (previousSpec != null) {
                previousSpec.dependentSpecs = new BaseCommandSpec[]{spec};
            }
            previousSpec = spec;
        }
    }

    private List<DvPortgroupReconfigureCommandSpec> createLacpMixedModeTeamingDvPortgroupSpecs(Map<Object, Map<String, Object>> rs, String lagName) throws Exception {
        ArrayList<DvPortgroupReconfigureCommandSpec> specs = new ArrayList<DvPortgroupReconfigureCommandSpec>(rs.size());
        for (Map.Entry<Object, Map<String, Object>> ri : rs.entrySet()) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy portConfig = new VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy();
            portConfig.uplinkTeamingPolicy = (VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy)ri.getValue().get(PROP_PORT_GROUP_TEAMING);
            if (portConfig.uplinkTeamingPolicy == null) {
                portConfig.uplinkTeamingPolicy = new VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy();
            }
            portConfig.uplinkTeamingPolicy.inherited = false;
            if (portConfig.uplinkTeamingPolicy.uplinkPortOrder == null) {
                portConfig.uplinkTeamingPolicy.uplinkPortOrder = new VmwareDistributedVirtualSwitch.UplinkPortOrderPolicy();
            }
            portConfig.uplinkTeamingPolicy.uplinkPortOrder.inherited = false;
            String[] standbyUplinks = portConfig.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort;
            ArrayList<Object> standbyUplinkList = standbyUplinks == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(standbyUplinks));
            standbyUplinkList.add(lagName);
            portConfig.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort = standbyUplinkList.toArray(new String[standbyUplinkList.size()]);
            DvPortgroupReconfigureCommandSpec spec = new DvPortgroupReconfigureCommandSpec();
            spec.mor = (ManagedObjectReference)ri.getKey();
            spec.discardExistingConfigVersion = false;
            spec.configSpec = new DistributedVirtualPortgroup.ConfigSpec();
            spec.configSpec.configVersion = (String)ri.getValue().get("config.configVersion");
            spec.configSpec.defaultPortConfig = portConfig;
            specs.add(spec);
        }
        return specs;
    }

    private List<LacpPhysicalNicReassignCommandSpec> createLacpReassignmentHostSpecs(ManagedObjectReference dvsRef, String lagName) throws Exception {
        Map<Object, Map<String, Object>> rs = Util.propertyValuesToMap(QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])new String[]{PROP_DVS_UUID, PROP_DVS_HOSTS}));
        if (rs == null || rs.size() != 1) {
            throw new Exception("Could not retrieve DVS data.");
        }
        Map<String, Object> props = rs.values().iterator().next();
        String uuid = (String)props.get(PROP_DVS_UUID);
        ManagedObjectReference[] hostRefs = (ManagedObjectReference[])props.get(PROP_DVS_HOSTS);
        if (hostRefs == null) {
            return Collections.emptyList();
        }
        ArrayList<LacpPhysicalNicReassignCommandSpec> specs = new ArrayList<LacpPhysicalNicReassignCommandSpec>(hostRefs.length);
        for (ManagedObjectReference hostRef : hostRefs) {
            LacpPhysicalNicReassignCommandSpec spec = new LacpPhysicalNicReassignCommandSpec();
            spec.dvsUuid = uuid;
            spec.lagName = lagName;
            spec.mor = hostRef;
            specs.add(spec);
        }
        return specs;
    }

    private List<DvPortgroupReconfigureCommandSpec> createLacpRecommendedTeamingDvPortgroupSpecs(Map<Object, Map<String, Object>> rs, String lagName) throws Exception {
        ArrayList<DvPortgroupReconfigureCommandSpec> specs = new ArrayList<DvPortgroupReconfigureCommandSpec>(rs.size());
        for (Object rawPgRef : rs.keySet()) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy portConfig = new VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy();
            portConfig.uplinkTeamingPolicy = new VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy();
            portConfig.uplinkTeamingPolicy.inherited = false;
            portConfig.uplinkTeamingPolicy.uplinkPortOrder = new VmwareDistributedVirtualSwitch.UplinkPortOrderPolicy();
            portConfig.uplinkTeamingPolicy.uplinkPortOrder.inherited = false;
            portConfig.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort = new String[]{lagName};
            portConfig.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort = new String[0];
            DvPortgroupReconfigureCommandSpec spec = new DvPortgroupReconfigureCommandSpec();
            spec.mor = (ManagedObjectReference)rawPgRef;
            spec.discardExistingConfigVersion = true;
            spec.configSpec = new DistributedVirtualPortgroup.ConfigSpec();
            spec.configSpec.defaultPortConfig = portConfig;
            specs.add(spec);
        }
        return specs;
    }

    private LacpUpgradeVersionCommandSpec createLacpVersionUpgradeCommandSpec(ManagedObjectReference dvsRef) throws Exception {
        String configVersion = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"config.configVersion");
        LacpUpgradeVersionCommandSpec commandSpec = new LacpUpgradeVersionCommandSpec();
        commandSpec.mor = dvsRef;
        commandSpec.configVersion = configVersion;
        commandSpec.apiVersion = VmwareDistributedVirtualSwitch.LacpApiVersion.multipleLag.name();
        return commandSpec;
    }
}

