/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.IpPoolManager;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.ProductSpec;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.fault.DvsOperationBulkFault;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VirtualNicManagerInfo;
import com.vmware.vim.binding.vim.vApp.IpPool;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceOption;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCardOption;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.compatibility.DvsCompatibilityChecker;
import com.vmware.vsphere.client.dvs.api.DvsHostCompatibilityInfo;
import com.vmware.vsphere.client.dvs.api.DvsHostMemberInfo;
import com.vmware.vsphere.client.dvs.impl.DvsHealthCheckUtil;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.dvs.ports.DistributedVirtualPortQuerySpecBuilder;
import com.vmware.vsphere.client.modules.api.network.ProxySwitchSpec;
import com.vmware.vsphere.client.network.HealthCheckRuntimeInfo;
import com.vmware.vsphere.client.network.vm.api.spec.DisconnectedVmVnicsSpec;
import com.vmware.vsphere.client.networking.util.ServiceContent;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsPropertyProvider
implements PropertyProviderBean {
    private static final String OPAQUE_NETWORK_TYPE_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkType";
    private static final String OPAQUE_NETWORK_ID_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkId";
    private static final char OPAQUE_NETWORK_KEY_DELIMITER = '/';
    private static final String DVPG_KEY_PROPERTY = "key";
    private static Log _logger = LogFactory.getLog(DvsPropertyProvider.class);
    private static final String HARDWARE_DEVICE_PROPERTY = "config.hardware.device";
    private static final String FT_INFO_PROPERTY = "summary.config.ftInfo";
    private static final String NUM_STANDALONE_PORTS_PROPERTY = "config.numStandalonePorts";
    private static final String NETWORK_PROPERTY = "allNetwork";
    private static final String PORTGROUP_PROPERTY = "portgroup";
    private static final String PROPERTY_PARENT = "parent";
    private static final String PROPERTY_DC_NETWORK_FOLDER = "networkFolder";
    private static final String PROPERTY_DVS_DC = "dc";
    private static final String DVPG_CONFIG_KEY = "config.key";
    private static final String DVPG_NRP_KEY = "config.defaultPortConfig.networkResourcePoolKey.value";
    private static final String DVPG_VM = "vm";
    private static final String DVPG_NRP_OVERRIDE_ALLOWED = "config.policy.networkResourcePoolOverrideAllowed";
    private static final String DVPORT_CONNECTED_ENTITY = "connectedEntityReference";
    private static final String DVPORT_NRP = "networkResourcePoolKey";
    private DataService _dataService;

    public DvsPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    @Deprecated
    public int getAvailablePorts(ManagedObjectReference dvsRef) throws Exception {
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        PortCriteria pc = new PortCriteria();
        pc.connected = false;
        pc.uplinkPort = false;
        String[] availablePortKeys = dvs.fetchPortKeys(pc);
        if (availablePortKeys == null) {
            return 0;
        }
        return availablePortKeys.length;
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public VmwareDistributedVirtualSwitch.PvlanMapEntry[] getPvlanConfig(ManagedObjectReference dvsRef) throws Exception {
        return DvsUtil.getPvlanConfig(this._dataService, dvsRef);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DistributedVirtualPort[] getPortsByKey(ManagedObjectReference dvsRef, Object[] portKeys) throws Exception {
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        PortCriteria criteria = new PortCriteria();
        criteria.portKey = new String[portKeys.length];
        for (int i = 0; i < portKeys.length; ++i) {
            criteria.portKey[i] = portKeys[i].toString();
        }
        return dvs.fetchPorts(criteria);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DistributedVirtualPort[] getPorts(ManagedObjectReference dvsRef, PortCriteria portCriteria) throws Exception {
        if (portCriteria == null) {
            portCriteria = new PortCriteria();
        }
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        return dvs.fetchPorts(portCriteria);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DistributedVirtualPort[] getRefreshedPorts(ManagedObjectReference dvsRef, Object[] portKeys) throws Exception {
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        String[] keys = (String[])Arrays.copyOf(portKeys, portKeys.length, String[].class);
        PortCriteria pc = new PortCriteria();
        pc.connected = true;
        pc.portKey = keys;
        keys = dvs.fetchPortKeys(pc);
        try {
            dvs.refreshPortState(keys);
        }
        catch (DvsOperationBulkFault bulkFault) {
            _logger.info((Object)"Refreshing port state failed for some hosts", (Throwable)bulkFault);
        }
        pc.portKey = keys;
        return dvs.fetchPorts(pc);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsHostCompatibilityInfo[] getDvsIncompatHostCompatibilityInfo(ManagedObjectReference dvsRef) throws Exception {
        assert (dvsRef != null);
        DvsHostCompatibilityInfo[] hostCompatInfos = this.getDvsHostCompatibilityInfo(dvsRef);
        if (hostCompatInfos != null) {
            ArrayList<DvsHostCompatibilityInfo> hostIncompatList = new ArrayList<DvsHostCompatibilityInfo>();
            for (DvsHostCompatibilityInfo hostCompatInfo : hostCompatInfos) {
                if (hostCompatInfo.compatibilityError == null || hostCompatInfo.compatibilityError.length <= 0) continue;
                hostIncompatList.add(hostCompatInfo);
            }
            if (!hostIncompatList.isEmpty()) {
                DvsHostCompatibilityInfo[] hostIncompatInfos = new DvsHostCompatibilityInfo[hostIncompatList.size()];
                hostIncompatList.toArray(hostIncompatInfos);
                return hostIncompatInfos;
            }
        }
        return null;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsHostCompatibilityInfo[] getDvsHostCompatibilityInfo(ManagedObjectReference dvsRef) throws Exception {
        assert (dvsRef != null);
        VcService service = VimSessionUtil.getService((String)dvsRef.getServerGuid());
        DistributedVirtualSwitchManager manager = (DistributedVirtualSwitchManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().dvSwitchManager);
        DistributedVirtualSwitchManager.HostContainer hostContainer = new DistributedVirtualSwitchManager.HostContainer();
        hostContainer.container = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)PROPERTY_DVS_DC);
        hostContainer.recursive = true;
        DistributedVirtualSwitchManager.HostContainerFilter filterSpec = new DistributedVirtualSwitchManager.HostContainerFilter();
        filterSpec.hostContainer = hostContainer;
        filterSpec.inclusive = true;
        DistributedVirtualSwitchManager.HostDvsFilterSpec[] hostDvsFilterSpec = new DistributedVirtualSwitchManager.HostDvsFilterSpec[]{filterSpec};
        DistributedVirtualSwitchManager.DvsProductSpec productSpec = new DistributedVirtualSwitchManager.DvsProductSpec();
        productSpec.newSwitchProductSpec = (ProductSpec)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"config.productInfo");
        DistributedVirtualSwitchManager.CompatibilityResult[] compatResults = manager.checkCompatibility(hostContainer, productSpec, hostDvsFilterSpec);
        if (compatResults != null) {
            HashMap<ManagedObjectReference, DvsHostCompatibilityInfo> compatInfoMap = new HashMap<ManagedObjectReference, DvsHostCompatibilityInfo>(compatResults.length * 2);
            for (DistributedVirtualSwitchManager.CompatibilityResult compatResult : compatResults) {
                DvsHostCompatibilityInfo compatInfo = new DvsHostCompatibilityInfo();
                compatInfo.hostRef = compatResult.host;
                if (compatResult.error != null) {
                    String[] compatErrors = new String[compatResult.error.length];
                    int i = 0;
                    for (Exception ex : compatResult.error) {
                        if (!(ex instanceof RuntimeFault)) continue;
                        RuntimeFault rf = (RuntimeFault)ex;
                        LocalizableMessage[] messages = rf.getFaultMessage();
                        String resultMessage = null;
                        for (LocalizableMessage lm : messages) {
                            if (lm == null || StringUtil.isNullOrEmpty((String)lm.getMessage())) continue;
                            resultMessage = resultMessage == null ? lm.getMessage() : resultMessage + '\n' + lm.getMessage();
                        }
                        compatErrors[i++] = resultMessage;
                    }
                    compatInfo.compatibilityError = compatErrors;
                }
                compatInfoMap.put(compatInfo.hostRef, compatInfo);
            }
            PropertyValue[] hostNames = QueryUtil.getProperty((DataService)this._dataService, (Object[])compatInfoMap.keySet().toArray(), (String)"name");
            DvsHostCompatibilityInfo[] compatInfos = new DvsHostCompatibilityInfo[compatResults.length];
            if (hostNames != null) {
                int i = 0;
                for (PropertyValue hostName : hostNames) {
                    DvsHostCompatibilityInfo compatInfo = (DvsHostCompatibilityInfo)compatInfoMap.get(hostName.resourceObject);
                    if (compatInfo != null) {
                        compatInfo.hostName = (String)hostName.value;
                    }
                    compatInfos[i++] = compatInfo;
                }
            }
            DvsUtil.sortByHostName(compatInfos);
            return compatInfos;
        }
        return null;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsHostMemberInfo[] getDvsNewCompatibleHostInfo(ManagedObjectReference dvsRef) throws Exception {
        assert (dvsRef != null);
        HashMap<ManagedObjectReference, DvsHostMemberInfo> hostMembersInfoMap = DvsUtil.getDvsNewCompatHosts(this._dataService, dvsRef);
        if (hostMembersInfoMap != null && hostMembersInfoMap.keySet().size() > 0) {
            DvsUtil.loadHostPropsForDvsHostMemberInfo(this._dataService, hostMembersInfoMap);
            DvsHostMemberInfo[] hostMemberInfos = hostMembersInfoMap.values().toArray(new DvsHostMemberInfo[hostMembersInfoMap.values().size()]);
            DvsUtil.sortByHostName(hostMemberInfos);
            return hostMemberInfos;
        }
        return null;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsHostMemberInfo[] getDvsHostMemberInfo(ManagedObjectReference dvsRef) throws Exception {
        assert (dvsRef != null);
        HashMap<ManagedObjectReference, DvsHostMemberInfo> hostMembersInfoMap = DvsUtil.getDvsHostMembers(this._dataService, dvsRef);
        if (hostMembersInfoMap != null && hostMembersInfoMap.keySet().size() > 0) {
            DvsUtil.loadHostPropsForDvsHostMemberInfo(this._dataService, hostMembersInfoMap);
            DvsHostMemberInfo[] hostMemberInfos = hostMembersInfoMap.values().toArray(new DvsHostMemberInfo[hostMembersInfoMap.values().size()]);
            DvsUtil.sortByHostName(hostMemberInfos);
            return hostMemberInfos;
        }
        return null;
    }

    @type(value="HostSystem")
    public ProxySwitchSpec[] getDvsesByUuids(ManagedObjectReference hostRef, Object[] uuids) throws Exception {
        ServiceInstanceContent sic;
        assert (hostRef != null);
        DistributedVirtualSwitchManager dvsManager = null;
        VcService vcService = VimSessionUtil.getService((String)hostRef.getServerGuid());
        if (vcService != null && (sic = vcService.getServiceInstanceContent()) != null) {
            dvsManager = (DistributedVirtualSwitchManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sic.dvSwitchManager);
        }
        ArrayList<ProxySwitchSpec> result = new ArrayList<ProxySwitchSpec>();
        for (Object uuid : uuids) {
            ManagedObjectReference mor;
            String uuidString = (String)uuid;
            ProxySwitchSpec proxySwitchSpec = new ProxySwitchSpec();
            proxySwitchSpec.dvsUuid = uuidString;
            result.add(proxySwitchSpec);
            try {
                mor = dvsManager.querySwitchByUuid(uuidString);
            }
            catch (NotFound e) {
                proxySwitchSpec.dvsRef = null;
                proxySwitchSpec.isGhostProxySwitch = true;
                continue;
            }
            proxySwitchSpec.dvsRef = mor;
        }
        return result.toArray(new ProxySwitchSpec[result.size()]);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DistributedVirtualSwitchManager.CompatibilityResult[] getDvsHostCompatibility(ManagedObjectReference dvsRef, ProductSpec productInfo) throws Exception {
        ServiceContent serviceContent = new ServiceContent(dvsRef.getServerGuid());
        DistributedVirtualSwitchManager dvsManager = serviceContent.getDvsManager();
        DistributedVirtualSwitchManager.HostContainer hostContainer = new DistributedVirtualSwitchManager.HostContainer();
        hostContainer.container = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)PROPERTY_DVS_DC);
        hostContainer.recursive = true;
        DistributedVirtualSwitchManager.HostDvsMembershipFilter filterSpec = new DistributedVirtualSwitchManager.HostDvsMembershipFilter();
        filterSpec.distributedVirtualSwitch = dvsRef;
        filterSpec.inclusive = true;
        DistributedVirtualSwitchManager.DvsProductSpec productSpec = new DistributedVirtualSwitchManager.DvsProductSpec();
        productSpec.newSwitchProductSpec = productInfo;
        DistributedVirtualSwitchManager.HostDvsFilterSpec[] hostDvsFilterSpec = new DistributedVirtualSwitchManager.HostDvsFilterSpec[]{filterSpec};
        DistributedVirtualSwitchManager.CompatibilityResult[] results = dvsManager.checkCompatibility(hostContainer, productSpec, hostDvsFilterSpec);
        return results;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public HostMember[] getHostMember(ManagedObjectReference dvsRef, Object[] hostRefArray) throws Exception {
        if (dvsRef == null) {
            return null;
        }
        HostMember[] memberArray = (HostMember[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"config.host");
        if (hostRefArray == null || hostRefArray.length == 0) {
            return memberArray;
        }
        HashSet<Object> hostSet = new HashSet<Object>();
        hostSet.addAll(Arrays.asList(hostRefArray));
        HostMember[] result = new HostMember[hostSet.size()];
        int fetchedMembers = 0;
        for (HostMember member : memberArray) {
            if (fetchedMembers >= result.length) break;
            if (!hostSet.contains(member.config.host)) continue;
            result[fetchedMembers++] = member;
        }
        return result;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public HealthCheckRuntimeInfo[] getHostMemberRuntimeInfo(ManagedObjectReference dvsRef) throws Exception {
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        if (dvs == null) {
            return null;
        }
        HostMember[] members = (HostMember[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"config.host");
        Map<ManagedObjectReference, HealthCheckRuntimeInfo> healthInfoByHost = DvsHealthCheckUtil.getHealthInfoByHost(members);
        if (healthInfoByHost == null || healthInfoByHost.isEmpty()) {
            return null;
        }
        DvsHealthCheckUtil.updateHostRuntimeInfo(this._dataService, healthInfoByHost);
        DvsHealthCheckUtil.updateHealthCheckResults(this._dataService, dvsRef, healthInfoByHost);
        Iterator<Map.Entry<ManagedObjectReference, HealthCheckRuntimeInfo>> hostEntryIterator = healthInfoByHost.entrySet().iterator();
        while (hostEntryIterator.hasNext()) {
            HealthCheckRuntimeInfo currentInfo = hostEntryIterator.next().getValue();
            if (!StringUtil.isNullOrEmpty((String)currentInfo.hostName)) continue;
            hostEntryIterator.remove();
        }
        HealthCheckRuntimeInfo[] healthInfo = healthInfoByHost.values().toArray(new HealthCheckRuntimeInfo[healthInfoByHost.size()]);
        DvsHealthCheckUtil.updateHealthCheckUplinksInfo(dvs, members, healthInfo);
        DvsHealthCheckUtil.removeStaleHealthCheckResults(healthInfo);
        DvsHealthCheckUtil.updateHealthCheckResultsSummary(healthInfo);
        return healthInfo;
    }

    @type(value="HostSystem")
    public VirtualNicManagerInfo getVirtualNicManagerInfo(ManagedObjectReference host) throws Exception {
        ManagedObjectReference vNicManagerRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)host, (String)"virtualNicManager");
        VirtualNicManager manager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vNicManagerRef);
        return manager.getInfo();
    }

    @type(value="Folder,Datacenter")
    public ProductSpec[] getSupportedProductSpec(ManagedObjectReference mor) throws Exception {
        ServiceContent serviceContent = new ServiceContent(mor.getServerGuid());
        DistributedVirtualSwitchManager dvsManager = serviceContent.getDvsManager();
        if (dvsManager != null) {
            return DvsCompatibilityChecker.querySupportedSwitchSpec(dvsManager, mor.getServerGuid(), true);
        }
        _logger.error((Object)"DistributedVirtualSwitchManager is required to retrieve the DVS supported ProductSpec");
        return null;
    }

    @type(value="Folder,Datacenter")
    public String[] getUniqueNewDvsName(ManagedObjectReference mor) throws Exception {
        try {
            ArrayList<String> existingDvsNames = DvsUtil.getAllDvsNames(this._dataService, mor);
            String newUniqueDvsName = StringUtil.getIndexedString(existingDvsNames, (String)Util.getLocalizedString("dvs.defaultName"), (String)" ");
            existingDvsNames.add(0, newUniqueDvsName);
            String[] uniqueDvsNames = new String[existingDvsNames.size()];
            uniqueDvsNames = existingDvsNames.toArray(uniqueDvsNames);
            return uniqueDvsNames;
        }
        catch (Exception ex) {
            _logger.error((Object)ex.getMessage());
            return new String[0];
        }
    }

    @type(value="Folder,Datacenter")
    public String getNewUniqueDvsName(ManagedObjectReference mor) throws Exception {
        Object[] dvsNames = this.getUniqueNewDvsName(mor);
        if (!ArrayUtil.isNullOrEmpty((Object[])dvsNames)) {
            return dvsNames[0];
        }
        return null;
    }

    @type(value="Folder,Datacenter,VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public String getNewUniquePortGroupName(ManagedObjectReference mor) throws Exception {
        try {
            String defaultName;
            ManagedObjectReference containerFolderMor = null;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, VmwareDistributedVirtualSwitch.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)mor, DistributedVirtualSwitch.class)) {
                containerFolderMor = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)mor, (String)PROPERTY_PARENT);
            } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, Datacenter.class)) {
                containerFolderMor = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)mor, (String)PROPERTY_DC_NETWORK_FOLDER);
            } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)mor, Folder.class)) {
                containerFolderMor = mor;
            } else {
                throw new IllegalArgumentException("Unexpected MOR type.");
            }
            ManagedObjectReference vcFolderMor = DvsUtil.getVCFolderMorForDc(this._dataService, DvsUtil.getDatacenterMor(this._dataService, containerFolderMor));
            String newUniqueName = defaultName = Util.getLocalizedString("dvPortGroup.defaultName");
            Boolean nameExists = DvsUtil.getPortGroupNameExists(this._dataService, vcFolderMor, defaultName, false, true);
            if (nameExists.booleanValue()) {
                newUniqueName = StringUtil.getIndexedString(DvsUtil.getPortGroupNames(this._dataService, vcFolderMor, defaultName, false, true), (String)defaultName, (String)" ");
            }
            return newUniqueName;
        }
        catch (Exception ex) {
            _logger.error((Object)ex.getMessage());
            return Util.getLocalizedString("dvPortGroup.defaultName");
        }
    }

    @type(value="Datacenter,Folder,VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public Boolean getDvsNameExists(ManagedObjectReference originObjectRef, String name) throws Exception {
        return DvsUtil.getDvsNameExists(this._dataService, originObjectRef, name);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,DistributedVirtualPortgroup,Datacenter,Folder")
    public Boolean getPortGroupNameExists(ManagedObjectReference originObjectRef, String name) throws Exception {
        return DvsUtil.getPortGroupNameExists(this._dataService, originObjectRef, name, true, false);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public ProductSpec[] getSupportedSwitchSpec(ManagedObjectReference dvsRef) throws Exception {
        ServiceContent serviceContent = new ServiceContent(dvsRef.getServerGuid());
        DistributedVirtualSwitchManager dvsManager = serviceContent.getDvsManager();
        if (dvsManager != null) {
            return DvsCompatibilityChecker.querySupportedSwitchSpec(dvsManager, dvsRef.getServerGuid(), true);
        }
        return null;
    }

    @type(value="Datacenter")
    public DisconnectedVmVnicsSpec[] getDisconnectedVms(ManagedObjectReference dcRef) throws Exception {
        Map<ManagedObjectReference, Pair<List<VirtualEthernetCard>, ManagedObjectReference[]>> vmNetMap = this.getEthernetCardsAndNetworksPerVM(dcRef);
        Map<ManagedObjectReference, String> networkKeys = this.getNetworksKeys(this.extractUniqueNetworks(vmNetMap));
        return this.getDisconnectedVmVnicSpecs(vmNetMap, networkKeys);
    }

    private ManagedObjectReference[] extractUniqueNetworks(Map<ManagedObjectReference, Pair<List<VirtualEthernetCard>, ManagedObjectReference[]>> vmNetMap) {
        HashSet<ManagedObjectReference> networkRefs = new HashSet<ManagedObjectReference>();
        for (Pair<List<VirtualEthernetCard>, ManagedObjectReference[]> mapping : vmNetMap.values()) {
            if (mapping.second == null) continue;
            for (ManagedObjectReference networkRef : (ManagedObjectReference[])mapping.second) {
                networkRefs.add(networkRef);
            }
        }
        return networkRefs.toArray(new ManagedObjectReference[networkRefs.size()]);
    }

    private Map<ManagedObjectReference, Pair<List<VirtualEthernetCard>, ManagedObjectReference[]>> getEthernetCardsAndNetworksPerVM(ManagedObjectReference dcRef) throws Exception {
        QuerySpec query = this.getRelatedVmsQuerySpec(dcRef);
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (resultSet == null || resultSet.items == null || resultSet.items.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<ManagedObjectReference, Pair<List<VirtualEthernetCard>, ManagedObjectReference[]>> vmNetMap = new HashMap<ManagedObjectReference, Pair<List<VirtualEthernetCard>, ManagedObjectReference[]>>();
        for (ResultItem item : resultSet.items) {
            VirtualDevice[] devices;
            if (item == null || item.resourceObject == null || item.properties == null || item.properties.length == 0) {
                _logger.warn((Object)"Invalid ResultItem retrieved for disconnected VMs.");
                continue;
            }
            FaultToleranceConfigInfo ftConfigInfo = (FaultToleranceConfigInfo)Util.getPropertyValue(item, FT_INFO_PROPERTY);
            if (ftConfigInfo != null && ftConfigInfo.role > 1 || (devices = (VirtualDevice[])Util.getPropertyValue(item, HARDWARE_DEVICE_PROPERTY)) == null || devices.length == 0) continue;
            ArrayList<VirtualEthernetCard> ethernetCards = new ArrayList<VirtualEthernetCard>();
            for (VirtualDevice virtualDevice : devices) {
                if (!(virtualDevice instanceof VirtualEthernetCard)) continue;
                ethernetCards.add((VirtualEthernetCard)virtualDevice);
            }
            if (ethernetCards.size() == 0) continue;
            ManagedObjectReference[] relnet = (ManagedObjectReference[])Util.getPropertyValue(item, NETWORK_PROPERTY);
            vmNetMap.put((ManagedObjectReference)item.resourceObject, (Pair<List<VirtualEthernetCard>, ManagedObjectReference[]>)new Pair(ethernetCards, (Object)relnet));
        }
        return vmNetMap;
    }

    private Map<ManagedObjectReference, String> getNetworksKeys(ManagedObjectReference[] networkReferences) throws Exception {
        QuerySpec networksQuerySpec = QueryUtil.buildQuerySpec((Object[])networkReferences, (String[])new String[]{DVPG_KEY_PROPERTY, OPAQUE_NETWORK_ID_PROPERTY, OPAQUE_NETWORK_TYPE_PROPERTY});
        ResultSet networksResultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)networksQuerySpec);
        if (networksResultSet == null || networksResultSet.items == null || networksResultSet.items.length == 0) {
            _logger.error((Object)"Unable to retrieve networks for disconnected VMs.");
            return Collections.emptyMap();
        }
        HashMap<ManagedObjectReference, String> networkKeys = new HashMap<ManagedObjectReference, String>();
        for (ResultItem netItem : networksResultSet.items) {
            if (!(netItem.resourceObject instanceof ManagedObjectReference)) {
                _logger.error((Object)("Unsupported network reference: " + netItem.resourceObject));
                continue;
            }
            ManagedObjectReference network = (ManagedObjectReference)netItem.resourceObject;
            if (DistributedVirtualPortgroup.class.getSimpleName().equals(network.getType())) {
                networkKeys.put(network, (String)Util.getPropertyValue(netItem, DVPG_KEY_PROPERTY));
                continue;
            }
            if (OpaqueNetwork.class.getSimpleName().equals(network.getType())) {
                networkKeys.put(network, DvsPropertyProvider.getOpaqueNetworkKey((String)Util.getPropertyValue(netItem, OPAQUE_NETWORK_ID_PROPERTY), (String)Util.getPropertyValue(netItem, OPAQUE_NETWORK_TYPE_PROPERTY)));
                continue;
            }
            if (Network.class.getSimpleName().equals(network.getType())) {
                networkKeys.put(network, network.getValue());
                continue;
            }
            _logger.error((Object)("Unsupported network type: " + network.getType()));
        }
        return networkKeys;
    }

    private DisconnectedVmVnicsSpec[] getDisconnectedVmVnicSpecs(Map<ManagedObjectReference, Pair<List<VirtualEthernetCard>, ManagedObjectReference[]>> vmNetMap, Map<ManagedObjectReference, String> networkKeys) {
        ArrayList<DisconnectedVmVnicsSpec> result = new ArrayList<DisconnectedVmVnicsSpec>();
        for (ManagedObjectReference vmRef : vmNetMap.keySet()) {
            HashSet<String> currentNetworkKeys = new HashSet<String>();
            Pair<List<VirtualEthernetCard>, ManagedObjectReference[]> vmInfo = vmNetMap.get(vmRef);
            if (vmInfo.second != null) {
                for (ManagedObjectReference netRef : (ManagedObjectReference[])vmInfo.second) {
                    currentNetworkKeys.add(networkKeys.get(netRef));
                }
            }
            ArrayList<VirtualEthernetCard> cardsWithInvalidBacking = new ArrayList<VirtualEthernetCard>();
            for (VirtualEthernetCard card : (List)vmInfo.first) {
                if (this.isEthernetCardBackingValid(card, currentNetworkKeys)) continue;
                cardsWithInvalidBacking.add(card);
            }
            if (cardsWithInvalidBacking.size() <= 0) continue;
            DisconnectedVmVnicsSpec disconnectedVmVnicsSpec = new DisconnectedVmVnicsSpec();
            disconnectedVmVnicsSpec.vmRef = vmRef;
            disconnectedVmVnicsSpec.vnics = cardsWithInvalidBacking.toArray(new VirtualEthernetCard[cardsWithInvalidBacking.size()]);
            result.add(disconnectedVmVnicsSpec);
        }
        return result.toArray(new DisconnectedVmVnicsSpec[result.size()]);
    }

    @type(value="DistributedVirtualSwitch,VmwareDistributedVirtualSwitch")
    public ManagedObjectReference[] getNetworkResourcePoolVms(ManagedObjectReference dvsRef, String poolKey) throws Exception {
        if (poolKey == null) {
            return null;
        }
        Constraint relationalConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)PORTGROUP_PROPERTY, (String)DistributedVirtualPortgroup.class.getSimpleName());
        PropertyConstraint nrpConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)DVPG_NRP_KEY, (Comparator)Comparator.EQUALS, (Object)poolKey);
        PropertyConstraint nrpNoOverrideConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)DVPG_NRP_OVERRIDE_ALLOWED, (Comparator)Comparator.EQUALS, (Object)false);
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{relationalConstraint, nrpConstraint, nrpNoOverrideConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{DVPG_VM});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        HashSet<ManagedObjectReference> vmSet = new HashSet<ManagedObjectReference>();
        if (resultSet.error != null) {
            _logger.error((Object)resultSet.error);
        }
        if (resultSet.items != null && resultSet.items.length > 0) {
            for (ResultItem item : resultSet.items) {
                PropertyValue vmProp = ResultUtil.getPropertyValue((ResultItem)item, (String)DVPG_VM);
                if (vmProp == null || vmProp.value == null) continue;
                vmSet.addAll(Arrays.asList((ManagedObjectReference[])vmProp.value));
            }
        }
        HashSet<String> portgroupKeys = new HashSet<String>();
        try {
            PropertyConstraint nrpOverrideConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)DVPG_NRP_OVERRIDE_ALLOWED, (Comparator)Comparator.EQUALS, (Object)true);
            constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{relationalConstraint, nrpOverrideConstraint}, (Conjoiner)Conjoiner.AND);
            query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{DVPG_CONFIG_KEY});
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
            if (resultSet.error != null) {
                _logger.error((Object)resultSet.error);
            }
            if (resultSet.items != null && resultSet.items.length > 0) {
                for (ResultItem item : resultSet.items) {
                    PropertyValue prop = ResultUtil.getPropertyValue((ResultItem)item, (String)DVPG_CONFIG_KEY);
                    if (prop == null || prop.value == null) continue;
                    portgroupKeys.add((String)prop.value);
                }
            }
        }
        catch (Exception error) {
            _logger.error((Object)error);
        }
        if (portgroupKeys.size() > 0) {
            PortCriteria criteria = new PortCriteria();
            criteria.connected = true;
            criteria.portgroupKey = portgroupKeys.toArray(new String[portgroupKeys.size()]);
            ManagedObjectReference[] vms = this.fetchResourcePoolVmsFromDvs(dvsRef, criteria, poolKey);
            vmSet.addAll(Arrays.asList(vms));
        }
        try {
            int numStandalonePorts = (Integer)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)NUM_STANDALONE_PORTS_PROPERTY);
            if (numStandalonePorts > 0) {
                PortCriteria criteria = new PortCriteria();
                criteria.connected = true;
                criteria.inside = false;
                ManagedObjectReference[] vms = this.fetchResourcePoolVmsFromDvs(dvsRef, criteria, poolKey);
                vmSet.addAll(Arrays.asList(vms));
            }
        }
        catch (Exception error) {
            _logger.error((Object)error);
        }
        return vmSet.toArray(new ManagedObjectReference[vmSet.size()]);
    }

    private QuerySpec getRelatedVmsQuerySpec(ManagedObjectReference dcRef) {
        Constraint vmConstraint = QueryUtil.createConstraintForRelationship((Object)dcRef, (String)DVPG_VM, (String)VirtualMachine.class.getSimpleName());
        RelationalConstraint connectedHostConstraint = QueryUtil.createRelationalConstraint((String)"host", (Constraint)QueryUtil.createPropertyConstraint((String)HostSystem.class.getSimpleName(), (String)"connectionState", (Comparator)Comparator.EQUALS, (Object)HostSystem.ConnectionState.connected.name()), (Boolean)false, (String)VirtualMachine.class.getSimpleName());
        PropertyConstraint nonTemplateVmConstraint = QueryUtil.createPropertyConstraint((String)VirtualMachine.class.getSimpleName(), (String)"summary.config.template", (Comparator)Comparator.EQUALS, (Object)false);
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{vmConstraint, connectedHostConstraint, nonTemplateVmConstraint}, (Conjoiner)Conjoiner.AND);
        return QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{HARDWARE_DEVICE_PROPERTY, NETWORK_PROPERTY, FT_INFO_PROPERTY});
    }

    private boolean isEthernetCardBackingValid(VirtualEthernetCard vnic, Set<String> networkKeys) {
        if (vnic.backing == null || networkKeys == null) {
            return true;
        }
        if (vnic.backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
            VirtualEthernetCard.NetworkBackingInfo backingInfo = (VirtualEthernetCard.NetworkBackingInfo)vnic.backing;
            if (backingInfo.network != null && !networkKeys.contains(backingInfo.network.getValue())) {
                _logger.error((Object)"Assigned network could not be found!");
                return false;
            }
        } else if (vnic.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
            VirtualEthernetCard.DistributedVirtualPortBackingInfo portBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)vnic.backing;
            if (portBacking.port != null && (StringUtil.isNullOrEmpty((String)portBacking.port.portgroupKey) ? StringUtil.isNullOrEmpty((String)portBacking.port.portKey) : !networkKeys.contains(portBacking.port.portgroupKey))) {
                return false;
            }
        } else if (vnic.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
            VirtualEthernetCard.OpaqueNetworkBackingInfo opaquebi = (VirtualEthernetCard.OpaqueNetworkBackingInfo)vnic.backing;
            if (StringUtil.isNullOrEmpty((String)opaquebi.opaqueNetworkId) || StringUtil.isNullOrEmpty((String)opaquebi.opaqueNetworkType)) {
                return false;
            }
            if (!networkKeys.contains(DvsPropertyProvider.getOpaqueNetworkKey(opaquebi))) {
                return false;
            }
        } else {
            if (vnic.backing instanceof VirtualEthernetCard.LegacyNetworkBackingInfo) {
                return false;
            }
            _logger.error((Object)"Invalid device backing!");
        }
        return true;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public IpPool[] getIpPools(ManagedObjectReference dvsRef) throws Exception {
        ManagedObjectReference dcRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)PROPERTY_DVS_DC);
        String serviceGuid = dcRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serviceGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        ManagedObjectReference managerRef = content.getIpPoolManager();
        IpPoolManager manager = (IpPoolManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
        IpPool[] pools = manager.queryIpPools(dcRef);
        if (pools != null) {
            this.unescapeSpecialChars(pools);
        }
        return pools;
    }

    @type(value="VirtualMachine")
    public VirtualEthernetCardOption[] getVmEthernetCardOption(ManagedObjectReference vmRef) throws Exception {
        ManagedObjectReference envBrowserRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)"environmentBrowser");
        EnvironmentBrowser envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserRef);
        String serverGuid = vmRef.getServerGuid();
        ConfigOption configOption = !StringUtil.isNullOrEmpty((String)serverGuid) && VcServiceUtil.is2014VcOrLater((String)serverGuid) ? envBrowser.queryConfigOptionEx(null) : envBrowser.queryConfigOption(null, null);
        ArrayList<VirtualEthernetCardOption> ethernetCardOptionList = new ArrayList<VirtualEthernetCardOption>();
        if (configOption != null && configOption.hardwareOptions != null && configOption.hardwareOptions.virtualDeviceOption != null) {
            for (VirtualDeviceOption deviceOption : configOption.hardwareOptions.virtualDeviceOption) {
                if (!(deviceOption instanceof VirtualEthernetCardOption)) continue;
                ethernetCardOptionList.add((VirtualEthernetCardOption)deviceOption);
            }
        }
        return ethernetCardOptionList.toArray(new VirtualEthernetCardOption[ethernetCardOptionList.size()]);
    }

    private void unescapeSpecialChars(IpPool[] pools) {
        for (IpPool pool : pools) {
            pool.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)pool.name);
        }
    }

    private ManagedObjectReference[] fetchResourcePoolVmsFromDvs(ManagedObjectReference dvs, PortCriteria criteria, String poolKey) {
        QuerySpec querySpec = new DistributedVirtualPortQuerySpecBuilder().queryName("fetch-ports-for-network-resource-pool").dvs(dvs).filterCriteria(criteria).propertyNames(DVPORT_CONNECTED_ENTITY, DVPORT_NRP).build();
        ResultSet resultSet = null;
        try {
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        }
        catch (Exception error) {
            _logger.error((Object)error);
            return new ManagedObjectReference[0];
        }
        if (resultSet.error != null) {
            _logger.error((Object)resultSet.error);
            return new ManagedObjectReference[0];
        }
        if (resultSet.items == null || resultSet.items.length == 0) {
            _logger.info((Object)("No ports retrieved with resource poolkey: " + poolKey));
            return new ManagedObjectReference[0];
        }
        HashSet<ManagedObjectReference> vmSet = new HashSet<ManagedObjectReference>();
        for (ResultItem item : resultSet.items) {
            String portPoolKey;
            PropertyValue prop = ResultUtil.getPropertyValue((ResultItem)item, (String)DVPORT_CONNECTED_ENTITY);
            ManagedObjectReference connectedEntity = prop != null ? (ManagedObjectReference)prop.value : null;
            prop = ResultUtil.getPropertyValue((ResultItem)item, (String)DVPORT_NRP);
            String string = portPoolKey = prop != null ? (String)prop.value : null;
            if (connectedEntity == null || !ManagedObjectUtil.isOfType((ManagedObjectReference)connectedEntity, VirtualMachine.class) || !ObjectUtil.objectsEqual((Object)portPoolKey, (Object)poolKey)) continue;
            vmSet.add(connectedEntity);
        }
        return vmSet.toArray(new ManagedObjectReference[vmSet.size()]);
    }

    private static String getOpaqueNetworkKey(String opaqueNetworkId, String opaqueNetworkType) {
        if (StringUtil.isNullOrEmpty((String)opaqueNetworkId) || StringUtil.isNullOrEmpty((String)opaqueNetworkType)) {
            throw new IllegalArgumentException("Empty opaque network id/type detected.");
        }
        return new StringBuilder(opaqueNetworkType.length() + opaqueNetworkId.length() + 1).append(opaqueNetworkType).append('/').append(opaqueNetworkId).toString();
    }

    private static String getOpaqueNetworkKey(VirtualEthernetCard.OpaqueNetworkBackingInfo info) {
        return DvsPropertyProvider.getOpaqueNetworkKey(info.opaqueNetworkId, info.opaqueNetworkType);
    }
}

