/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.lacp.commands;

import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.FutureCommand;
import com.vmware.vsphere.client.dvs.lacp.specs.LacpPhysicalNicReassignCommandSpec;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.Map;

public class LacpUpgradePhysicalNicReassignCommand
extends FutureCommand {
    private static final String PROP_NETWORK_SYSTEM = "networkSystem";
    private static final String PROP_CONFIG_PROXY_SWITCH = "config.network.proxySwitch";
    private final DataService _dataService;

    public LacpUpgradePhysicalNicReassignCommand(LacpPhysicalNicReassignCommandSpec spec, DataService dataService) {
        this.setCommandSpec(spec);
        this._dataService = dataService;
    }

    protected ClientFutureImpl<?> launch() throws Exception {
        LacpPhysicalNicReassignCommandSpec spec = (LacpPhysicalNicReassignCommandSpec)this.getCommandSpec();
        if (spec == null || spec.mor == null || spec.dvsUuid == null || spec.lagName == null) {
            throw new Exception("Invalid command spec supplied.");
        }
        this.waitForHostLagPropagation(spec.mor);
        String[] propNames = new String[]{PROP_NETWORK_SYSTEM, PROP_CONFIG_PROXY_SWITCH};
        Map<Object, Map<String, Object>> rs = Util.propertyValuesToMap(QueryUtil.getProperties((DataService)this._dataService, (Object)spec.mor, (String[])propNames));
        if (rs.size() != 1) {
            throw new Exception("Cannot find host " + spec.mor.toString());
        }
        Map<String, Object> props = rs.values().iterator().next();
        ManagedObjectReference nsRef = (ManagedObjectReference)props.get(PROP_NETWORK_SYSTEM);
        HostProxySwitch[] proxySwitches = (HostProxySwitch[])props.get(PROP_CONFIG_PROXY_SWITCH);
        HostProxySwitch proxySwitch = this.findProxySwitchByUuid(spec.dvsUuid, proxySwitches);
        if (proxySwitch == null) {
            throw new Exception("No dvs found with UUID " + spec.dvsUuid);
        }
        if (proxySwitch.hostLag == null || proxySwitch.hostLag.length != 1 || !spec.lagName.equals(proxySwitch.hostLag[0].lagName)) {
            throw new Exception("Unexpected LAG config for HPS with UUID " + spec.dvsUuid);
        }
        if (proxySwitch.spec == null || proxySwitch.spec.backing == null || !(proxySwitch.spec.backing instanceof HostMember.PnicBacking)) {
            throw new Exception("Host proxy switch is in unexpected state for DVS UUID " + spec.dvsUuid);
        }
        KeyValue[] uplinkPorts = proxySwitch.uplinkPort;
        KeyValue[] lagPorts = proxySwitch.hostLag[0].uplinkPort == null ? new KeyValue[]{} : proxySwitch.hostLag[0].uplinkPort;
        HostMember.PnicBacking backing = (HostMember.PnicBacking)proxySwitch.spec.backing;
        HostMember.PnicSpec[] existingPnicSpecs = backing.pnicSpec == null ? new HostMember.PnicSpec[]{} : backing.pnicSpec;
        HostMember.PnicSpec[] newPnicSpecs = new HostMember.PnicSpec[existingPnicSpecs.length];
        for (int i = 0; i < existingPnicSpecs.length; ++i) {
            HostMember.PnicSpec pnicSpec = existingPnicSpecs[i];
            int existingPortKey = LacpUpgradePhysicalNicReassignCommand.findPortKeyIndex(pnicSpec.uplinkPortKey, uplinkPorts);
            if (existingPortKey == -1) {
                throw new Exception("Assigned uplink port key is not part of 'uplinkPort' property of the HPS.");
            }
            if (existingPortKey >= lagPorts.length) {
                throw new Exception("Insufficient number of LAG ports available.");
            }
            KeyValue newPort = lagPorts[existingPortKey];
            if (newPort == null) {
                throw new Exception("LAG port is null.");
            }
            HostMember.PnicSpec newPnicSpec = new HostMember.PnicSpec();
            newPnicSpec.pnicDevice = pnicSpec.pnicDevice;
            newPnicSpec.uplinkPortKey = newPort.key;
            newPnicSpecs[i] = newPnicSpec;
        }
        NetworkConfig networkConfig = LacpUpgradePhysicalNicReassignCommand.createNetworkConfig(spec.dvsUuid, newPnicSpecs);
        NetworkSystem ns = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)nsRef);
        ClientFutureImpl resultFuture = new ClientFutureImpl();
        ns.updateNetworkConfig(networkConfig, ConfigChange.Mode.modify.name(), (Future)resultFuture);
        return resultFuture;
    }

    private void waitForHostLagPropagation(ManagedObjectReference hostRef) throws Exception {
        LacpPhysicalNicReassignCommandSpec spec = (LacpPhysicalNicReassignCommandSpec)this.getCommandSpec();
        QueryUtil.waitUntilPropertyChanged((DataService)this._dataService, (Object)hostRef, (QueryUtil.PropertyChangeInfo)new LagConfigChangeListener(spec));
    }

    private static NetworkConfig createNetworkConfig(String dvsUuid, HostMember.PnicSpec[] newPnicSpecs) {
        HostMember.PnicBacking backing = new HostMember.PnicBacking();
        backing.pnicSpec = (HostMember.PnicSpec[])newPnicSpecs.clone();
        HostProxySwitch.Config hps = new HostProxySwitch.Config();
        hps.changeOperation = ConfigChange.Operation.edit.name();
        hps.uuid = dvsUuid;
        hps.spec = new HostProxySwitch.Specification();
        hps.spec.backing = backing;
        NetworkConfig config = new NetworkConfig();
        config.proxySwitch = new HostProxySwitch.Config[]{hps};
        return config;
    }

    private static int findPortKeyIndex(String portKey, KeyValue[] ports) {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                KeyValue port = ports[i];
                if (port == null || port.key == null || !port.key.equals(portKey)) continue;
                return i;
            }
        }
        return -1;
    }

    private HostProxySwitch findProxySwitchByUuid(String uuid, HostProxySwitch[] proxySwitches) {
        for (HostProxySwitch hps : proxySwitches) {
            if (!uuid.equals(hps.dvsUuid)) continue;
            return hps;
        }
        return null;
    }

    private static final class LagConfigChangeListener
    implements QueryUtil.PropertyChangeInfo {
        private final LacpPhysicalNicReassignCommandSpec spec;

        private LagConfigChangeListener(LacpPhysicalNicReassignCommandSpec spec) {
            this.spec = spec;
        }

        public boolean isChanged(Object newValue) {
            HostProxySwitch[] proxySwitches;
            if (!(newValue instanceof HostProxySwitch[])) {
                return false;
            }
            for (HostProxySwitch hps : proxySwitches = (HostProxySwitch[])newValue) {
                if (!this.spec.dvsUuid.equals(hps.dvsUuid)) continue;
                return hps.hostLag != null && hps.hostLag.length == 1 && hps.hostLag[0] != null && this.spec.lagName.equals(hps.hostLag[0].lagName);
            }
            return false;
        }

        public String getPropertyName() {
            return LacpUpgradePhysicalNicReassignCommand.PROP_CONFIG_PROXY_SWITCH;
        }
    }
}

