/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.impl;

import com.vmware.vim.binding.vim.fault.DvsOperationBulkFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.error.ErrorReportService;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.common.error.ErrorStackResolver;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsOperationBulkFaultErrorStackResolver
implements ErrorStackResolver {
    private static final Log _logger = LogFactory.getLog(DvsOperationBulkFaultErrorStackResolver.class);
    private ErrorReportService _errorReportService;
    private DataService _ds;

    public DvsOperationBulkFaultErrorStackResolver(ErrorReportService errorReportService, DataService ds) {
        this._errorReportService = errorReportService;
        this._ds = ds;
    }

    public String[] getHandledTypeNames() {
        return new String[]{DvsOperationBulkFault.class.getName()};
    }

    public ErrorStack resolve(VcService s, Object obj) {
        if (obj instanceof DvsOperationBulkFault) {
            DvsOperationBulkFault bulkFault = (DvsOperationBulkFault)obj;
            DvsOperationBulkFault.FaultOnHost[] hostFaults = bulkFault.getHostFault();
            ErrorStack[] causeArray = new ErrorStack[hostFaults.length];
            for (int index = 0; index < causeArray.length; ++index) {
                DvsOperationBulkFault.FaultOnHost hostFault = hostFaults[index];
                ErrorStack errorStack = this._errorReportService.toErrorStack(s, (Object)hostFault.fault);
                errorStack.entity = hostFault.host;
                errorStack.entityDescription = Util.getLocalizedString("errorStack.entityDescription.host");
                causeArray[index] = errorStack;
            }
            this.populateHostNames(causeArray);
            ErrorStack stack = new ErrorStack(bulkFault.getFaultMessage());
            stack.cause = causeArray;
            return stack;
        }
        return null;
    }

    private void populateHostNames(ErrorStack[] errorStacks) {
        HashMap<ManagedObjectReference, ErrorStack> map = new HashMap<ManagedObjectReference, ErrorStack>();
        for (ErrorStack stack : errorStacks) {
            if (map.containsKey(stack.entity)) continue;
            map.put(stack.entity, stack);
        }
        PropertyValue[] propVals = null;
        try {
            propVals = QueryUtil.getProperty((DataService)this._ds, (Object[])map.keySet().toArray(), (String)"name");
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        if (propVals == null || propVals.length == 0) {
            return;
        }
        for (PropertyValue propVal : propVals) {
            ErrorStack stack = (ErrorStack)map.get((ManagedObjectReference)propVal.resourceObject);
            if (stack == null) continue;
            stack.entityName = (String)propVal.value;
        }
    }
}

