/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.networking.util;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceContent {
    private Log _logger = LogFactory.getLog(ServiceContent.class);
    private String _serverGuid = null;
    private ServiceInstanceContent _serviceInstanceContent = null;
    private DistributedVirtualSwitchManager _dvsManager = null;

    public ServiceContent(String serverGuid) {
        this._serverGuid = serverGuid;
        this.initialize();
    }

    public DistributedVirtualSwitchManager getDvsManager() {
        if (this._dvsManager == null) {
            if (this._serviceInstanceContent == null) {
                this._logger.error((Object)"ServiceInstanceContent found null");
                return null;
            }
            try {
                ManagedObjectReference dvsMgrMoref = this._serviceInstanceContent.dvSwitchManager;
                if (dvsMgrMoref == null) {
                    this._logger.error((Object)"Could not get DistributerVirtualSwitchManager moref");
                    return null;
                }
                this._dvsManager = (DistributedVirtualSwitchManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsMgrMoref);
                if (this._dvsManager == null) {
                    this._logger.error((Object)"Could not get DistributerVirtualSwitchManager");
                }
            }
            catch (Exception e) {
                this._logger.error((Object)"Error getting DistributedVirtualSwitchManager: ", (Throwable)e);
            }
        }
        return this._dvsManager;
    }

    private void initialize() {
        try {
            VcService vcService = VimSessionUtil.getService((String)this._serverGuid);
            if (vcService == null) {
                return;
            }
            this._serviceInstanceContent = vcService.getServiceInstanceContent();
        }
        catch (Exception e) {
            this._logger.error((Object)"Error getting getServiceInstanceContent: ", (Throwable)e);
        }
    }
}

