/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.vmware.cis.authorization.impl.AuthCache;
import com.vmware.cis.authorization.impl.Caches;
import com.vmware.cis.authorization.impl.DataProvider;
import com.vmware.cis.authorization.impl.InvalidationCallback;
import com.vmware.cis.authorization.impl.ParentChainMap;
import com.vmware.cis.authorization.impl.Products;
import com.vmware.cis.authorization.impl.ProviderInfo;
import com.vmware.cis.core.AuthFilterInfo;
import com.vmware.cis.core.Permission;
import com.vmware.cis.core.Principal;
import com.vmware.cis.core.PrivilegeData;
import com.vmware.cis.core.RoleData;
import com.vmware.cis.core.exception.AuthorizationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuthorizationProvider
implements DataProvider {
    private Caches _caches;
    private AuthCache _cache;

    public void setParentChainCache(AuthCache cache) {
        this._cache = cache;
    }

    public void setCaches(Caches caches) {
        this._caches = caches;
    }

    @Override
    public Map<String, Collection<Permission>> getPermissions() {
        return this._caches.getPermissionsCache().get();
    }

    @Override
    public synchronized Collection<String> getAllRootObjectIds() {
        Collection col = Collections2.filter(this._cache.getAllProviderInfo(), (Predicate)new Predicate<ProviderInfo>(){

            public boolean apply(ProviderInfo info) {
                if ("vpx".equalsIgnoreCase(info.getProvider().getProduct())) {
                    return true;
                }
                return "SRM".equalsIgnoreCase(info.getProvider().getProduct());
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        result.add(Products.NON_VPX_ROOT);
        for (ProviderInfo info : col) {
            result.add(info.getRoot());
        }
        return result;
    }

    @Override
    public String getVcRootObjectId() throws AuthorizationException {
        for (ProviderInfo info : this._cache.getAllProviderInfo()) {
            if (info == null || !"vpx".equalsIgnoreCase(info.getProvider().getProduct())) continue;
            return info.getRoot();
        }
        return null;
    }

    @Override
    public void setInvalidationCallback(InvalidationCallback cb) {
        this._cache.setInvalidationCallback(cb);
        this._caches.setInvalidationCallback(cb);
    }

    @Override
    public String getAuthObject(String objectId) {
        return this._cache.getAuthObject(objectId);
    }

    @Override
    public ParentChainMap getParentChains(Collection<String> entities, boolean includeAlternates) {
        ParentChainMap map = new ParentChainMap();
        for (String entity : entities) {
            List<String> pc = this._cache.getParentChain(entity);
            List<String> apc = this._cache.getAltParentChain(entity);
            map.setParentList(entity, pc, true);
            if (!includeAlternates || apc == null) continue;
            map.setParentList(entity, apc, false);
        }
        return map;
    }

    @Override
    public ParentChainMap getParentChains(String entity, boolean includeAlternates) {
        return this.getParentChains(Collections.singletonList(entity), includeAlternates);
    }

    @Override
    public boolean isDescendantOf(String objectId, Set<String> parentIds) {
        return this._cache.isDescendantOf(objectId, parentIds);
    }

    @Override
    public AuthFilterInfo getAuthInfo(String objectId) {
        return this._cache.getAuthFilterInfo(objectId);
    }

    @Override
    public Collection<Permission> getPermissions(String objectId) throws AuthorizationException {
        Collection<Permission> result = this._caches.getPermissionsCache().get().get(objectId);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public String getProviderRootObjectId(String providerUuid) throws AuthorizationException {
        for (ProviderInfo info : this._cache.getAllProviderInfo()) {
            if (info == null || !providerUuid.equalsIgnoreCase(info.getProvider().getProviderUuid())) continue;
            return info.getRoot();
        }
        return null;
    }

    @Override
    public Map<Long, RoleData> getRoles() {
        return this._caches.getRolesCache().get();
    }

    @Override
    public Map<String, PrivilegeData> getPrivileges() {
        return this._caches.getPrivilegesCache().get();
    }

    @Override
    public boolean hasImpliedSysViewPrivilege(String objectId, Principal principal) {
        return false;
    }
}

