/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import com.vmware.cis.authorization.PrincipalLifecycleManager;
import com.vmware.cis.authorization.UserSessionManager;
import com.vmware.cis.authorization.VcAuthorizationManager;
import com.vmware.cis.authorization.impl.SessionAuthDataImpl;
import com.vmware.cis.core.AuthFilterInfo;
import com.vmware.cis.core.Principal;
import com.vmware.cis.core.exception.AuthorizationException;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionAuthData;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserSessionManagerImpl
implements UserSessionManager {
    private static final Log _log = LogFactory.getLog(UserSessionManagerImpl.class);
    private VcAuthorizationManager _authMgr;
    private PrincipalLifecycleManager _plMgr;

    public void setAuthorizationManager(VcAuthorizationManager authMgr) {
        this._authMgr = authMgr;
    }

    public void setPrincipalLifecycleManager(PrincipalLifecycleManager plMgr) {
        this._plMgr = plMgr;
    }

    @Override
    public void addConnection(Session session, Principal principal, boolean isSuperuser) throws AuthorizationException {
        if (session != null && session.getAuthData() == null) {
            SessionAuthDataImpl authData = new SessionAuthDataImpl(principal, this);
            session.setAuthData((SessionAuthData)authData);
        }
        if (principal != null) {
            this._plMgr.notifyAdd(principal, isSuperuser);
        }
    }

    @Override
    public void removeConnection(Principal principal) {
        if (principal != null) {
            this._plMgr.notifyRemove(principal);
        }
    }

    @Override
    public boolean isSuperuser(Session userSession) throws AuthorizationException {
        SessionAuthDataImpl authData = (SessionAuthDataImpl)userSession.getAuthData();
        if (authData == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Auth data null in session. Returning false");
            }
            return false;
        }
        return this._authMgr.isSuperuser(authData.getPrincipal());
    }

    @Override
    public boolean isAllowed(Session session, String objectId, String privilegeId) throws AuthorizationException {
        SessionAuthDataImpl authData = (SessionAuthDataImpl)session.getAuthData();
        if (authData == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Auth data null in session. Returning false");
            }
            return false;
        }
        return this._authMgr.isAllowed(authData.getPrincipal(), objectId, privilegeId);
    }

    @Override
    public boolean isAllowed(Session session, String objectId, Collection<String> privileges) throws AuthorizationException {
        SessionAuthDataImpl authData = (SessionAuthDataImpl)session.getAuthData();
        if (authData == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Auth data null in session. Returning false");
            }
            return false;
        }
        return this._authMgr.isAllowed(authData.getPrincipal(), objectId, privileges);
    }

    @Override
    public boolean isAllowedOnVcRoot(Session session, String privilegeId) throws AuthorizationException {
        SessionAuthDataImpl authData = (SessionAuthDataImpl)session.getAuthData();
        if (authData == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Auth data null in session. Returning false");
            }
            return false;
        }
        return this._authMgr.isAllowedOnVcRoot(authData.getPrincipal(), privilegeId);
    }

    @Override
    public boolean isAllowedOnVcRoot(Session session, Collection<String> privileges) throws AuthorizationException {
        SessionAuthDataImpl authData = (SessionAuthDataImpl)session.getAuthData();
        if (authData == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Auth data null in session. Returning false");
            }
            return false;
        }
        return this._authMgr.isAllowedOnVcRoot(authData.getPrincipal(), privileges);
    }

    @Override
    public boolean isDescendantOf(String objectId, Set<String> parentIds) {
        return this._authMgr.isDescendantOf(objectId, parentIds);
    }

    @Override
    public AuthFilterInfo getAuthInfo(String objectId) {
        return this._authMgr.getAuthInfo(objectId);
    }

    @Override
    public boolean isAllowedOnRoot(Session session, Collection<String> privileges) throws AuthorizationException {
        SessionAuthDataImpl authData = (SessionAuthDataImpl)session.getAuthData();
        if (authData == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Auth data null in session. Returning false");
            }
            return false;
        }
        return this._authMgr.isAllowedOnRoot(authData.getPrincipal(), privileges);
    }
}

