/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.notif.client.impl;

import com.vmware.cis.notif.client.DeserializationException;
import com.vmware.cis.notif.client.Deserializer;
import com.vmware.cis.notif.client.impl.ManagedObjectContainer;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.query.core.util.VmomiUtil;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ManagedObjectDeserializer
implements Deserializer {
    private final Unmarshaller UNMARSHALLER;

    public ManagedObjectDeserializer(VmodlVersion version) {
        VmodlContext context = VmodlContext.getContext();
        if (context == null) {
            throw new IllegalStateException("No VMODL context instantiated - please initialize a context first");
        }
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        this.UNMARSHALLER = context.createQSResponseUnmarshaller(version, null);
    }

    @Override
    public ManagedObjectContainer deserialize(XMLStreamReader stream) throws DeserializationException {
        try {
            ManagedObjectContainer container = new ManagedObjectContainer();
            int eventType = stream.getEventType();
            if (eventType != 1) {
                stream.nextTag();
            }
            String id = stream.getAttributeValue("urn:vmware:queryservice", "id");
            ManagedObjectReference moref = VmomiUtil.createMoRef((String)id);
            HashMap<String, Object> props = new HashMap<String, Object>();
            while (stream.hasNext() && stream.nextTag() != 1) {
                stream.next();
            }
            while (stream.hasNext()) {
                if (stream.getEventType() != 1) {
                    stream.next();
                    continue;
                }
                String propertyName = stream.getLocalName();
                VmodlField field = this.getVmodlField(moref, propertyName);
                if (field == null) {
                    while (stream.hasNext() && ((eventType = stream.next()) != 2 || !stream.getLocalName().equals(propertyName))) {
                    }
                    continue;
                }
                Object property = this.UNMARSHALLER.unmarshal(field, stream);
                props.put(propertyName, property);
            }
            container.setMoRef(moref);
            container.setProps(props);
            return container;
        }
        catch (UnmarshallException e) {
            throw new DeserializationException(e.getMessage(), (Exception)((Object)e), e.toString());
        }
        catch (XMLStreamException e) {
            throw new DeserializationException(e.getMessage(), e, e.toString());
        }
    }

    private VmodlField getVmodlField(ManagedObjectReference moref, String propertyName) {
        VmodlType type = VmodlTypeMap.Factory.getTypeMap().getVmodlType(moref.getType());
        if (type == null) {
            return null;
        }
        if (type instanceof ManagedObjectType) {
            ManagedObjectType mot = (ManagedObjectType)type;
            return mot.getManagedProperty(propertyName);
        }
        return null;
    }
}

