/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.impl;

import com.vmware.cis.authorization.client.AuthorizationServiceClient;
import com.vmware.cis.authorization.client.impl.AuthorizationServiceClientimpl;
import com.vmware.cis.ol.client.ObjectServiceLocator;
import com.vmware.vim.binding.dataservice.Service;
import com.vmware.vim.binding.dataservice.ServiceInformation;
import com.vmware.vim.binding.dataservice.accesscontrol.AuthorizationService;
import com.vmware.vim.binding.dataservice.accesscontrol.internal.AuthorizationServiceInternal;
import com.vmware.vim.binding.dataservice.fault.NotAuthenticatedFault;
import com.vmware.vim.binding.dataservice.tagging.TagManager;
import com.vmware.vim.binding.dataservice.version.internal.version2;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.clientutil.VmomiClientUtil;
import com.vmware.vim.query.client.AuthenticationData;
import com.vmware.vim.query.client.AuthenticationStrategy;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.query.client.ClientFactory;
import com.vmware.vim.query.client.QueryAuthenticationManager;
import com.vmware.vim.query.client.QueryDispatcher;
import com.vmware.vim.query.client.exception.NotImplementedException;
import com.vmware.vim.query.client.exception.ServiceUnavailableException;
import com.vmware.vim.query.client.impl.ObjectServiceLocatorImpl;
import com.vmware.vim.query.client.impl.QueryAuthenticationManagerImpl;
import com.vmware.vim.query.client.impl.QueryDispatcherImpl;
import com.vmware.vim.query.client.provider.impl.AtomFeedUnmarshaller;
import com.vmware.vim.query.client.provider.impl.XMLAtomFeedUnMarshaller;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpProtocolBinding;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;

public class ClientImpl
implements Client {
    private static final Log _log;
    private static final AtomFeedUnmarshaller UNMARSHALLER;
    private static final ClientFactory.Configuration DEFAULT_CONFIGURATION;
    private String _baseUri;
    private String _secureContext = "/secure";
    private String _vmomiContext = "/vmomi/sdk/";
    private HttpClient _client;
    protected com.vmware.vim.vmomi.client.Client _vmomiDsClient;
    private QueryDispatcherImpl _dispatcher;
    private QueryAuthenticationManagerImpl _authManager;
    protected AuthenticationStrategy _authStrategy;
    private volatile ServiceInformation _serviceInformation;
    private final int KEEP_ALIVE_TIME_MS = 90000;
    private final int DEFAULT_KEEP_ALIVE_TIME_MS = 900000;
    private ObjectServiceLocator _objSvcLocator;

    @Deprecated
    public ClientImpl(URI uri, HttpConfiguration config, AuthenticationData data, AuthenticationStrategy as, Class<?> version) {
        this._baseUri = uri.toString();
        while (this._baseUri.endsWith("/")) {
            this._baseUri = this._baseUri.substring(0, this._baseUri.length() - 1);
        }
        this._authStrategy = as;
        this._vmomiDsClient = this.getVmomiDsClient(config, version);
        this._client = this.getVmomiHttpClient();
        this.setupManagers(uri, data);
    }

    public ClientImpl(URI uri, ClientFactory.Configuration config) {
        this._baseUri = uri.toString();
        while (this._baseUri.endsWith("/")) {
            this._baseUri = this._baseUri.substring(0, this._baseUri.length() - 1);
        }
        if (config == null) {
            config = DEFAULT_CONFIGURATION;
        }
        this._authStrategy = config.getAuthenticationStrategy();
        this._vmomiDsClient = this.getVmomiDsClient(config.getClientConfig(), config.getVersion());
        this._client = this.getVmomiHttpClient();
        this.setupManagers(uri, null);
    }

    @Override
    public QueryAuthenticationManager getAuthenticationManager() {
        return this._authManager;
    }

    @Override
    public QueryDispatcher getQueryDispatcher() {
        return this._dispatcher;
    }

    @Override
    public ObjectServiceLocator getObjectServiceLocator() {
        return this._objSvcLocator;
    }

    @Override
    public com.vmware.vim.vmomi.client.Client getVmomiClient() {
        return this._vmomiDsClient;
    }

    @Override
    public TagManager getTagManager() {
        ManagedObjectReference reference = new ManagedObjectReference("InventoryServiceTagManager", "tagManager");
        return VmomiClientUtil.createStub(this._vmomiDsClient, TagManager.class, reference, "IS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInformation getServiceInformation() throws ServiceUnavailableException, NotImplementedException {
        if (this._serviceInformation == null) {
            ClientImpl clientImpl = this;
            synchronized (clientImpl) {
                if (this._serviceInformation == null) {
                    ManagedObjectReference reference = new ManagedObjectReference("InventoryService", "service");
                    Service service = VmomiClientUtil.createStub(this._vmomiDsClient, Service.class, reference, "IS");
                    BlockingFuture f = new BlockingFuture();
                    service.getInfo((Future)f);
                    try {
                        this._serviceInformation = (ServiceInformation)f.get();
                    }
                    catch (InterruptedException e) {
                        throw new ServiceUnavailableException("Cannot get service information", e);
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof InvalidRequest) {
                            throw new NotImplementedException("Cannot get service information", e);
                        }
                        throw new ServiceUnavailableException("Cannot get service information", e);
                    }
                }
            }
        }
        return this._serviceInformation;
    }

    @Override
    public void close() {
        this._vmomiDsClient.shutdown();
        this._dispatcher.close();
    }

    @Override
    public AuthorizationService getAuthorizationService() {
        ManagedObjectReference reference = new ManagedObjectReference("AuthorizationService", "authorizationService");
        return VmomiClientUtil.createStub(this._vmomiDsClient, AuthorizationService.class, reference, "IS");
    }

    @Override
    public AuthorizationServiceInternal getAuthorizationServiceInternal() {
        ManagedObjectReference reference = new ManagedObjectReference("AuthorizationServiceInternal", "authorizationServiceInternal");
        return VmomiClientUtil.createStub(this._vmomiDsClient, AuthorizationServiceInternal.class, reference, "IS");
    }

    @Override
    public AuthorizationServiceClient newAuthorizationServiceClient(boolean enableClientSideCaching) {
        return new AuthorizationServiceClientimpl(this, enableClientSideCaching);
    }

    @Override
    public AuthorizationServiceClient newAuthorizationServiceClient(Set<String> products, Set<String> providerIds) {
        return new AuthorizationServiceClientimpl(this, true, products, providerIds);
    }

    private URI getVmomiUri() {
        try {
            return new URI(this.getBaseUri() + this._vmomiContext);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private HttpClient getVmomiHttpClient() {
        ProtocolBinding binding = this._vmomiDsClient.getBinding();
        if (!(binding instanceof HttpProtocolBinding)) {
            throw new IllegalStateException("Cannot handle authentication for VMOMI client:Binding not of type HttpProtocolBinding");
        }
        Object impl = ((HttpProtocolBinding)binding).getImpl();
        if (!(impl instanceof HttpClient)) {
            throw new IllegalStateException("Cannot handle authentication for VMOMI client: Implementation not instance of AbstractHttpClient");
        }
        return (HttpClient)impl;
    }

    private com.vmware.vim.vmomi.client.Client getVmomiDsClient(HttpClientConfiguration httpClientConfig, Class<?> version) {
        if (httpClientConfig == null) {
            return this.getVmomiDsClient((HttpConfiguration)null, version);
        }
        return this.getVmomiDsClient(httpClientConfig, httpClientConfig.getHttpConfiguration(), version);
    }

    private com.vmware.vim.vmomi.client.Client getVmomiDsClient(HttpConfiguration httpConfig, Class<?> version) {
        HttpClientConfiguration httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        return this.getVmomiDsClient(httpClientConfig, httpConfig, version);
    }

    private com.vmware.vim.vmomi.client.Client getVmomiDsClient(HttpClientConfiguration httpClientConfig, HttpConfiguration httpConfig, Class<?> version) {
        if (httpConfig == null) {
            httpConfig = HttpConfiguration.Factory.newInstance();
        }
        if (httpConfig.getKeepAlivePeriod() == 900000L) {
            httpConfig.setKeepAlivePeriod(90000L);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Setting the client keep alive period to :" + httpConfig.getKeepAlivePeriod()));
            }
        }
        httpClientConfig.setHttpConfiguration(httpConfig);
        final ClientImpl thisClient = this;
        if (this._authStrategy != null) {
            httpClientConfig.setRequestRetryCallback(new RequestRetryCallback(){

                public boolean retry(Exception exception, InvocationContext context, int retrycount) {
                    if (!(exception instanceof NotAuthenticatedFault)) {
                        if (_log.isTraceEnabled()) {
                            _log.trace((Object)("Cannot handle server exception: " + exception));
                        }
                        return false;
                    }
                    if (retrycount > ClientImpl.this._authStrategy.getMaxLoginAttempts()) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to login to server after retries:" + retrycount));
                        }
                        return false;
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Calling caller-defined login method");
                    }
                    ClientImpl.this._authStrategy.login(thisClient);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Done calling caller-defined login method");
                    }
                    return true;
                }
            });
        }
        if (version == null) {
            version = version2.class;
        }
        return Client.Factory.createClient((URI)this.getVmomiUri(), version, (ClientConfiguration)httpClientConfig);
    }

    public String getBaseUri() {
        return this._baseUri;
    }

    public String getSecureBaseUri() {
        return this._baseUri + this._secureContext;
    }

    public void setSecureContext(String secureContext) {
        this._secureContext = secureContext;
    }

    public void setVmomiContext(String vmomiContext) {
        this._vmomiContext = vmomiContext;
    }

    public HttpClient getClient() {
        return this._client;
    }

    public AuthenticationStrategy getAuthenticationStrategy() {
        return this._authStrategy;
    }

    private void setupManagers(URI uri, AuthenticationData data) {
        this._authManager = new QueryAuthenticationManagerImpl(this);
        this._authManager.setAuthenticationData(data);
        this._dispatcher = new QueryDispatcherImpl(this, UNMARSHALLER);
        this._objSvcLocator = new ObjectServiceLocatorImpl(this._dispatcher, uri);
    }

    static {
        block2: {
            _log = LogFactory.getLog(ClientImpl.class);
            UNMARSHALLER = new XMLAtomFeedUnMarshaller();
            DEFAULT_CONFIGURATION = new ClientFactory.Configuration(){

                @Override
                public HttpClientConfiguration getClientConfig() {
                    return null;
                }

                @Override
                public Class<?> getVersion() {
                    return null;
                }

                @Override
                public AuthenticationStrategy getAuthenticationStrategy() {
                    return null;
                }
            };
            try {
                VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.dataservice"});
            }
            catch (IllegalArgumentException e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("InitContext threw IllegalArgumentException:" + e.getMessage()));
                _log.warn((Object)"This will happen if the context com.vmware.vim.binding.dataserviceis already initialized");
            }
        }
    }
}

