/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.impl;

import com.vmware.cis.notif.client.ChangeListener;
import com.vmware.cis.notif.client.ChangeType;
import com.vmware.cis.notif.client.Filter;
import com.vmware.cis.notif.client.NotificationException;
import com.vmware.cis.notif.client.Notifications;
import com.vmware.cis.notif.client.ObjectChange;
import com.vmware.cis.notif.client.ObjectChangeIterator;
import com.vmware.cis.notif.client.ObjectSelector;
import com.vmware.cis.notif.client.SubscriptionSpec;
import com.vmware.cis.notif.client.impl.FilterImpl;
import com.vmware.cis.notif.client.impl.NotificationsImpl;
import com.vmware.cis.notif.client.impl.ObjectSelectorImpl;
import com.vmware.cis.notif.client.impl.SubscriptionSpecImpl;
import com.vmware.cis.ol.client.ObjectServiceLocator;
import com.vmware.cis.ol.client.ServiceRef;
import com.vmware.cis.ol.client.exception.LookupException;
import com.vmware.vim.query.client.QueryDispatcher;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.impl.ServiceRefImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectServiceLocatorImpl
implements ObjectServiceLocator {
    private static final String PROVIDER_QUERY = "declare namespace qs=\"urn:vmware:queryservice\";declare function local:providerUuid($node as node()) as xs:string* external;for $svcUuid in local:providerUuid(//*[@qs:id=\"%1$s\"])return   <serviceRef>      <serviceUUID>{$svcUuid}</serviceUUID>   </serviceRef>";
    private static final Log _log = LogFactory.getLog(ObjectServiceLocatorImpl.class);
    private QueryDispatcher _queryDispatcher;
    private ConcurrentHashMap<URI, Collection<ServiceRef>> _cache;
    private Notifications _notifications;
    private ObjSvcLocatorChangeListener _changeListener;
    private volatile boolean _subscribed;
    private URI _isUri;

    protected ObjectServiceLocatorImpl(QueryDispatcher queryDispatcher, URI uri) {
        this._queryDispatcher = queryDispatcher;
        this._cache = new ConcurrentHashMap();
        this._notifications = new NotificationsImpl();
        this._changeListener = new ObjSvcLocatorChangeListener();
        this._subscribed = false;
        this._isUri = uri;
    }

    @Override
    public Collection<ServiceRef> getService(URI objectID) throws LookupException {
        Collection<ServiceRef> svcRefs = null;
        if (objectID != null && (svcRefs = this._cache.get(objectID)) == null) {
            svcRefs = this.query(objectID);
        }
        return svcRefs;
    }

    @Override
    public void invalidate(URI objectID) {
        if (objectID != null) {
            this._cache.remove(objectID);
        }
    }

    public boolean existsServiceRef(URI objectID) {
        return objectID != null && this._cache.containsKey(objectID);
    }

    private Collection<ServiceRef> query(URI objectID) throws LookupException {
        Collection<ServiceRef> svcRefs;
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put(QueryDispatcher.QueryOption.FEDERATED.name(), Boolean.TRUE);
            String providerQuery = String.format(PROVIDER_QUERY, objectID);
            QueryDispatcher.QueryResponse qryResp = this._queryDispatcher.query(providerQuery, options);
            svcRefs = this.readQueryResponse(qryResp);
            if (svcRefs != null && !svcRefs.isEmpty()) {
                Collection<ServiceRef> existing = this._cache.get(objectID);
                if (existing != null && !existing.isEmpty()) {
                    svcRefs.addAll(existing);
                }
                existing = Collections.unmodifiableCollection(svcRefs);
                this._cache.put(objectID, existing);
                if (!this._subscribed) {
                    Collection<SubscriptionSpec> specs = this.createSubscriptionSpecs(this._cache.keySet(), svcRefs);
                    this.subscribeToNotifications(this._notifications, specs, this._changeListener);
                    this._subscribed = true;
                }
                svcRefs = existing;
            }
        }
        catch (ClientException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Exception querying for service id:", (Throwable)e);
            }
            throw new LookupException("Exception querying for serviceID", e);
        }
        return svcRefs;
    }

    private Collection<ServiceRef> readQueryResponse(QueryDispatcher.QueryResponse queryResp) throws LookupException {
        Collection<ServiceRef> svcRefs = null;
        InputStream inStrm = null;
        try {
            inStrm = queryResp.getResponseStream();
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ServiceRefs.class});
            Unmarshaller un = ctx.createUnmarshaller();
            ServiceRefs svcRefsWrapper = (ServiceRefs)un.unmarshal(inStrm);
            svcRefs = svcRefsWrapper.getServiceRefs();
        }
        catch (ClientException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Exception reading response stream for service id:", (Throwable)e);
            }
            throw new LookupException("Exception reading response for serviceID", e);
        }
        catch (JAXBException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Exception reading stream for serviceID", (Throwable)e);
            }
            throw new LookupException("Exception reading stream for serviceID", e);
        }
        finally {
            block14: {
                try {
                    if (inStrm != null) {
                        inStrm.close();
                    }
                }
                catch (IOException e) {
                    if (!_log.isWarnEnabled()) break block14;
                    _log.warn((Object)"Exception closing read/write streams:", (Throwable)e);
                }
            }
        }
        return svcRefs;
    }

    private Collection<SubscriptionSpec> createSubscriptionSpecs(Set<URI> objectIds, Collection<ServiceRef> svcRefs) throws LookupException {
        ObjectSelectorImpl objSelector = new ObjectSelectorImpl(objectIds);
        FilterImpl filter = new FilterImpl(null, new ObjectSelector[]{objSelector});
        ArrayList<SubscriptionSpec> subscriptionSpecs = new ArrayList<SubscriptionSpec>();
        for (ServiceRef svcRef : svcRefs) {
            SubscriptionSpecImpl spec = new SubscriptionSpecImpl("ObjectServiceLocatorSubscription", null, null, null, this._isUri, svcRef.getServiceUUID(), new Filter[]{filter});
            subscriptionSpecs.add(spec);
        }
        return subscriptionSpecs;
    }

    private void subscribeToNotifications(Notifications notif, Collection<SubscriptionSpec> specs, ChangeListener listener) throws LookupException {
        try {
            for (SubscriptionSpec spec : specs) {
                notif.subscribe(spec, listener, null);
            }
        }
        catch (NotificationException e) {
            throw new LookupException(e);
        }
    }

    class ObjSvcLocatorChangeListener
    implements ChangeListener {
        ObjSvcLocatorChangeListener() {
        }

        @Override
        public void onResync(ObjectChangeIterator changes) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"ObjSvcLocatorChangeListener: OnResync");
            }
            while (changes.hasNext()) {
                try {
                    ObjectChange oc = changes.nextChange();
                    if (oc.getType() != ChangeType.DELETE) continue;
                    ObjectServiceLocatorImpl.this.invalidate(oc.getObjectId());
                }
                catch (NotificationException e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)"ObjSvcLocatorChangeListener: Unable to process notification change. Cache may be stale.");
                }
            }
        }

        @Override
        public void onChanges(ObjectChangeIterator changes) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"ObjSvcLocatorChangeListener: OnChanges");
            }
            while (changes.hasNext()) {
                try {
                    ObjectChange oc = changes.nextChange();
                    if (oc.getType() != ChangeType.DELETE) continue;
                    ObjectServiceLocatorImpl.this.invalidate(oc.getObjectId());
                }
                catch (NotificationException e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)"ObjSvcLocatorChangeListener: Unable to process notification change. Cache may be stale.", (Throwable)e);
                }
            }
        }

        @Override
        public void onError(NotificationException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"ObjSvcLocatorChangeListener: error encountered. \n", (Throwable)e);
            }
        }
    }

    @XmlRootElement(name="resultSet")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class ServiceRefs {
        @XmlElement(name="serviceRef", type=ServiceRefImpl.class)
        private Collection<ServiceRef> _svcRefs;

        private ServiceRefs() {
        }

        public Collection<ServiceRef> getServiceRefs() {
            return this._svcRefs;
        }

        public void setServiceRefs(Collection<ServiceRef> svcRefs) {
            this._svcRefs = svcRefs;
        }
    }
}

