/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.provider.impl;

import com.vmware.vim.query.core.provider.AtomFeedEntry;
import com.vmware.vim.query.core.provider.content.ContentAtomFeed;
import com.vmware.vim.query.core.provider.content.ContentAtomFeedEntry;
import com.vmware.vim.query.core.provider.content.impl.ContentAtomFeedEntryImpl;
import com.vmware.vim.query.core.provider.content.impl.ContentAtomFeedImpl;
import com.vmware.vim.query.core.provider.impl.AtomFeedEntryImpl;
import com.vmware.vim.query.core.provider.impl.AtomFeedImpl;
import com.vmware.vim.query.core.provider.impl.EntryPropertyImpl;
import com.vmware.vim.query.core.provider.pull.PullAtomFeed;
import com.vmware.vim.query.core.provider.pull.PullAtomFeedEntry;
import com.vmware.vim.query.core.provider.pull.PullEntryMetadata;
import com.vmware.vim.query.core.provider.pull.PullEntryProperty;
import com.vmware.vim.query.core.provider.pull.impl.PullAtomFeedEntryImpl;
import com.vmware.vim.query.core.provider.pull.impl.PullAtomFeedImpl;
import com.vmware.vim.query.core.provider.pull.impl.PullEntryMetadataImpl;
import com.vmware.vim.query.core.provider.pull.impl.PullEntryPropertyImpl;
import com.vmware.vim.query.core.provider.push.PushAtomFeed;
import com.vmware.vim.query.core.provider.push.PushAtomFeedEntry;
import com.vmware.vim.query.core.provider.push.PushEntryProperty;
import com.vmware.vim.query.core.provider.push.impl.PushAtomFeedEntryImpl;
import com.vmware.vim.query.core.provider.push.impl.PushAtomFeedImpl;
import com.vmware.vim.query.core.provider.push.impl.PushEntryPropertyImpl;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class FeedFactory {
    private static final Log _log = LogFactory.getLog(FeedFactory.class);

    private FeedFactory() {
        throw new AssertionError();
    }

    public static PushEntryProperty createPushEntryProperty(QName property, Calendar modifiedTime) {
        return FeedFactory.createPushEntryProperty(property, modifiedTime, -1L);
    }

    public static PushEntryProperty createPushEntryProperty(QName property, Calendar modifiedTime, long expectedGeneration) {
        PushEntryPropertyImpl prop = new PushEntryPropertyImpl();
        FeedFactory.setEntryProperty(property, modifiedTime, (EntryPropertyImpl)prop);
        prop.setExpectedGeneration(expectedGeneration);
        return prop;
    }

    public static PullEntryProperty createPullEntryProperty(QName property, Calendar modifiedTime, long generation) {
        PullEntryPropertyImpl prop = new PullEntryPropertyImpl();
        FeedFactory.setEntryProperty(property, modifiedTime, (EntryPropertyImpl)prop);
        prop.setGeneration(generation);
        return prop;
    }

    public static PullEntryProperty createContentEntryProperty(QName property, Calendar modifiedTime, long generation) {
        PullEntryPropertyImpl prop = new PullEntryPropertyImpl();
        FeedFactory.setEntryProperty(property, modifiedTime, (EntryPropertyImpl)prop);
        prop.setGeneration(generation);
        return prop;
    }

    private static void setEntryProperty(QName property, Calendar modifiedTime, EntryPropertyImpl prop) {
        prop.setModifiedTime(modifiedTime);
        prop.setName(property);
    }

    public static PullEntryMetadata createPullEntryMetadata(PullEntryMetadata.MetadataName name, Calendar modifiedTime, long generation) {
        PullEntryMetadataImpl md = new PullEntryMetadataImpl();
        md.setName(name);
        md.setModifiedTime(modifiedTime);
        md.setGeneration(generation);
        return md;
    }

    public static PullEntryMetadata createContentEntryMetadata(PullEntryMetadata.MetadataName name, Calendar modifiedTime, long generation) {
        PullEntryMetadataImpl md = new PullEntryMetadataImpl();
        md.setName(name);
        md.setModifiedTime(modifiedTime);
        md.setGeneration(generation);
        return md;
    }

    public static PushAtomFeedEntry createPushAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PushEntryProperty> props, Document content) throws TransformerException {
        return FeedFactory.createPushAtomFeedEntry(objId, modifiedTime, changeType, props, content, -1L);
    }

    public static PushAtomFeedEntry createPushAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PushEntryProperty> props, Document content, long expectedGeneration) throws TransformerException {
        PushAtomFeedEntryImpl entry = new PushAtomFeedEntryImpl();
        FeedFactory.setFeedEntry(objId, modifiedTime, changeType, (AtomFeedEntryImpl)entry);
        entry.setEntryPropertyList(props);
        entry.setContent(content);
        FeedFactory.validateEntryAndFail((AtomFeedEntry)entry);
        FeedFactory.validatePushEntry((PushAtomFeedEntry)entry);
        entry.setExpectedGeneration(expectedGeneration);
        return entry;
    }

    public static PullAtomFeedEntry createPullAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PullEntryProperty> props, URL link, long generation) throws TransformerException {
        return FeedFactory.createPullAtomFeedEntry(objId, modifiedTime, changeType, props, Collections.<PullEntryMetadata>emptyList(), link, generation, null);
    }

    public static ContentAtomFeedEntry createContentAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PullEntryProperty> props, URL link, Document doc, long generation) throws TransformerException {
        return FeedFactory.createContentAtomFeedEntry(objId, modifiedTime, changeType, props, Collections.<PullEntryMetadata>emptyList(), link, doc, generation, null);
    }

    public static PullAtomFeedEntry createPullAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PullEntryProperty> props, List<PullEntryMetadata> metadata, URL link, long generation, QName type) throws TransformerException {
        PullAtomFeedEntryImpl entry = new PullAtomFeedEntryImpl();
        FeedFactory.setFeedEntry(objId, modifiedTime, changeType, (AtomFeedEntryImpl)entry);
        entry.setType(type);
        entry.setEntryPropertyList(props);
        entry.setGeneration(generation);
        entry.setLink(link);
        entry.setEntryMetadataList(metadata);
        FeedFactory.validateEntryAndLog((AtomFeedEntry)entry);
        return entry;
    }

    public static ContentAtomFeedEntry createContentAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PullEntryProperty> props, List<PullEntryMetadata> metadata, URL link, Document doc, long generation, QName type) throws TransformerException {
        ContentAtomFeedEntryImpl entry = new ContentAtomFeedEntryImpl();
        FeedFactory.setFeedEntry(objId, modifiedTime, changeType, (AtomFeedEntryImpl)entry);
        entry.setType(type);
        entry.setEntryPropertyList(props);
        entry.setGeneration(generation);
        entry.setLink(link);
        entry.setEntryMetadataList(metadata);
        entry.setContent(doc);
        return entry;
    }

    public static PullAtomFeedEntry createPullAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PullEntryProperty> props, URL link, long generation, QName type) throws TransformerException {
        return FeedFactory.createPullAtomFeedEntry(objId, modifiedTime, changeType, props, Collections.<PullEntryMetadata>emptyList(), link, generation, null);
    }

    public static ContentAtomFeedEntry createContentAtomFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, List<PullEntryProperty> props, URL link, Document doc, long generation, QName type) throws TransformerException {
        return FeedFactory.createContentAtomFeedEntry(objId, modifiedTime, changeType, props, Collections.<PullEntryMetadata>emptyList(), link, doc, generation, null);
    }

    public static PushAtomFeed createPushAtomFeed(Calendar modifiedTime, String providerId, Iterator<PushAtomFeedEntry> entries) {
        return FeedFactory.createPushAtomFeed(modifiedTime, providerId, entries, -1L);
    }

    public static PushAtomFeed createPushAtomFeed(Calendar modifiedTime, String providerId, Iterator<PushAtomFeedEntry> entries, long expectedGeneration) {
        PushAtomFeedImpl feed = new PushAtomFeedImpl();
        FeedFactory.setAtomFeed(modifiedTime, providerId, (AtomFeedImpl)feed);
        feed.setFeedEntries(entries);
        feed.setExpectedGeneration(expectedGeneration);
        return feed;
    }

    public static PullAtomFeed createPullAtomFeed(Calendar modifiedTime, String providerId, Iterator<PullAtomFeedEntry> entries, long generation) {
        PullAtomFeedImpl feed = new PullAtomFeedImpl();
        FeedFactory.setAtomFeed(modifiedTime, providerId, (AtomFeedImpl)feed);
        feed.setFeedEntries(entries);
        feed.setGeneration(generation);
        return feed;
    }

    public static ContentAtomFeed createContentAtomFeed(Calendar modifiedTime, String providerId, Iterator<ContentAtomFeedEntry> entries, long generation) {
        ContentAtomFeedImpl feed = new ContentAtomFeedImpl();
        FeedFactory.setAtomFeed(modifiedTime, providerId, (AtomFeedImpl)feed);
        feed.setFeedEntries(entries);
        feed.setGeneration(generation);
        return feed;
    }

    private static void setAtomFeed(Calendar modifiedTime, String providerId, AtomFeedImpl feed) {
        feed.setModifiedTime(modifiedTime);
        feed.setTitle(providerId + " feed");
        feed.setProviderId(providerId);
    }

    private static void setFeedEntry(URI objId, Calendar modifiedTime, AtomFeedEntry.ChangeType changeType, AtomFeedEntryImpl entry) {
        entry.setObjectId(objId);
        entry.setModifiedTime(modifiedTime);
        entry.setChangeType(changeType);
        entry.setModifiedTime(modifiedTime);
    }

    private static void validateEntryAndFail(AtomFeedEntry entry) {
        String msg = FeedFactory.validateEntryInt(entry);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void validateEntryAndLog(AtomFeedEntry entry) {
        String msg = FeedFactory.validateEntryInt(entry);
        if (msg != null && _log.isWarnEnabled()) {
            _log.warn((Object)("Atom feed validation for entry " + entry.getObjectId() + " failed with message " + msg));
        }
    }

    private static String validateEntryInt(AtomFeedEntry entry) {
        List props = entry.getEntryPropertyList();
        switch (entry.getChangeType()) {
            case CREATE: {
                if (props == null || props.isEmpty()) break;
                return "Properties specified for CREATE";
            }
            case EDIT: {
                if (props != null && !props.isEmpty()) break;
                List metadata = null;
                if (entry instanceof PullAtomFeedEntry) {
                    metadata = ((PullAtomFeedEntry)entry).getEntryMetadataList();
                }
                if (metadata != null && !metadata.isEmpty()) break;
                return "Properties not specified for EDIT";
            }
            case DELETE: {
                if (props == null || props.isEmpty()) break;
                return "Properties specified for DELETE";
            }
            default: {
                throw new IllegalArgumentException("Invalid change type");
            }
        }
        return null;
    }

    private static void validatePushEntry(PushAtomFeedEntry entry) {
        Document content = entry.getContent();
        URI objId = entry.getObjectId();
        switch (entry.getChangeType()) {
            case CREATE: {
                if (content == null) {
                    throw new IllegalArgumentException("Content needs to be specified for CREATE");
                }
                FeedFactory.validateQsId(objId, content);
                break;
            }
            case EDIT: {
                if (content == null) {
                    throw new IllegalArgumentException("Content needs to be specified for EDIT");
                }
                FeedFactory.validateQsId(objId, content);
                break;
            }
            case DELETE: {
                if (content == null) break;
                FeedFactory.validateQsId(objId, content);
                FeedFactory.validateDeleteChange(content);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid change type");
            }
        }
    }

    private static void validateDeleteChange(Document content) {
        boolean error = false;
        for (int i = 0; i < content.getDocumentElement().getAttributes().getLength(); ++i) {
            Node n = content.getDocumentElement().getAttributes().item(i);
            if (!n.getNamespaceURI().equals("urn:vmware:queryservice")) {
                error = true;
                break;
            }
            if (n.getLocalName().equals("id") && n.getLocalName().equals("revision")) continue;
            error = true;
            break;
        }
        if (error) {
            throw new IllegalArgumentException("DELETE entries can contain content with only {urn:vmware:queryservice}id and {urn:vmware:queryservice}revision attributes");
        }
    }

    private static void validateQsId(URI objId, Document content) {
        Attr qsIdAttr = content.getDocumentElement().getAttributeNodeNS("urn:vmware:queryservice", "id");
        if (qsIdAttr == null) {
            throw new IllegalArgumentException("Content needs to have {urn:vmware:queryservice}id attribute");
        }
        if (!objId.toString().equals(qsIdAttr.getValue())) {
            throw new IllegalArgumentException("Content {urn:vmware:queryservice}id attribute needs to match entry id");
        }
    }
}

