/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.provider.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ForwardingIterator<E>
implements Iterator<E> {
    private final Node<E> _header = new Node<Object>(null, null);
    private Node<E> _tail = this._header;
    private boolean _canRemove = false;

    @Override
    public boolean hasNext() {
        return this._header != this._tail;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        Object result = this._header._next._e;
        if (this._header._next == this._tail) {
            this._tail = this._header;
        }
        this._header._next = this._header._next._next;
        this._canRemove = true;
        return result;
    }

    @Override
    public void remove() {
        if (!this._canRemove) {
            throw new IllegalStateException("Call next first or next has not been called after last remove");
        }
        this._canRemove = false;
    }

    public void add(E e) {
        this._tail._next = new Node<E>(e, null);
        this._tail = this._tail._next;
    }

    private static class Node<E> {
        E _e;
        Node<E> _next;

        Node(E e, Node<E> next) {
            this._e = e;
            this._next = next;
        }
    }
}

