/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension;

import com.vmware.vise.util.Pair;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vsphere.client.vcextension.RemoteImageSpec;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteImageManager {
    private static final int CACHE_EXPIRE_TIMEOUT = 3600000;
    private static final int CONNECTION_TIMEOUT = 300000;
    private static final Log _logger = LogFactory.getLog(RemoteImageManager.class);
    public static final int SOCKET_TIMEOUT = 20000;
    private final KeystoreService _ksService;
    private final HostnameVerifier _hostnameVerifier;
    private final Map<String, Pair<Long, BufferedImage>> _imageCache;

    private RemoteImageManager(KeystoreService ksService) {
        Validate.notNull((Object)ksService, (String)"extension ksService null");
        this._ksService = ksService;
        this._imageCache = new ConcurrentHashMap<String, Pair<Long, BufferedImage>>();
        this._hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
    }

    public RemoteImageSpec get(String url) {
        return this.getResized(url, -1, -1);
    }

    public RemoteImageSpec getResized(String url, int width, int height) {
        String imageData;
        int h;
        BufferedImage img = this.getImage(url);
        if (img == null) {
            return null;
        }
        int w = width < 0 ? img.getWidth() : width;
        int n = h = height < 0 ? img.getHeight() : height;
        if (width >= 0 || height >= 0) {
            img = this.resizeImage(img, w, h);
        }
        if ((imageData = this.encodeImage(img)) == null || imageData.isEmpty()) {
            return null;
        }
        RemoteImageSpec ris = new RemoteImageSpec();
        ris.id = url + "|" + w + "|" + h;
        ris.imageData = imageData;
        return ris;
    }

    /*
     * Exception decompiling
     */
    private BufferedImage getImage(String urlString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream openConnectionCheckRedirects(URLConnection connection) throws IOException, NoSuchAlgorithmException, KeyManagementException, SecurityException {
        boolean followRedirect;
        int redirects = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection http;
            int httpStatusCode;
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
            }
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setReadTimeout(20000);
                httpsConnection.setHostnameVerifier(this._hostnameVerifier);
                SSLContext sslContext = new SSLBuilder().addTrustStore(this._ksService.getKeyStore()).buildSSLContext().getSslContext();
                httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            inputStream = connection.getInputStream();
            followRedirect = false;
            if (!(connection instanceof HttpURLConnection) || !RemoteImageManager.isRedirection(httpStatusCode = (http = (HttpURLConnection)connection).getResponseCode())) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || redirects >= 5 || !target.getProtocol().equals("http") && !target.getProtocol().equals("https")) {
                throw new SecurityException("illegal URL redirect");
            }
            followRedirect = true;
            connection = target.openConnection();
            ++redirects;
        } while (followRedirect);
        return inputStream;
    }

    private static boolean isRedirection(int httpStatusCode) {
        boolean isRedirection = httpStatusCode == 300 || httpStatusCode == 301 || httpStatusCode == 302 || httpStatusCode == 303 || httpStatusCode == 305 || httpStatusCode == 307;
        return isRedirection;
    }

    private String encodeImage(BufferedImage img) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        String encodedImage = null;
        try {
            ImageIO.write((RenderedImage)img, "png", baos);
            baos.flush();
            encodedImage = new String(new Base64().encode(baos.toByteArray()));
            baos.close();
        }
        catch (IOException e) {
            _logger.info((Object)("Problem doing IO: " + e.getMessage()));
        }
        return encodedImage;
    }

    private BufferedImage resizeImage(BufferedImage img, int width, int height) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > width && (w /= 2) < width) {
                w = width;
            }
            if (h > height && (h /= 2) < height) {
                h = height;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != width || h != height);
        return ret;
    }
}

