/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.util;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.ext.SolutionManagerInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.VcExtensionManagerProxy;
import com.vmware.vsphere.client.vcextension.impl.VcSolutionPropertyProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcExtensionUtil {
    private static final Log _logger = LogFactory.getLog(VcSolutionPropertyProvider.class);
    public static final Predicate<Extension> isSolutionManagerExtension = new Predicate<Extension>(){

        public boolean evaluate(Extension extension) {
            return extension != null && extension.getShownInSolutionManager() != false;
        }
    };
    public static final String RESOURCE_BUNDLE_NAME = "vcextensionservice";
    private static final String DEPRECATES_TAB_PROPERTY = "deprecatesSolutionManagerTabs";
    private static final String DEPRECATES_TAB_URL_SEPARATOR = ";";
    private static final String DNS_WILDCARD = "*";

    public static String getLocalizedString(String key, String ... args) {
        String result = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])args, (ClassLoader)VcExtensionUtil.class.getClassLoader());
        return result;
    }

    public static String getVcServerHostname(String serverGuid) throws Exception {
        String serviceUrl = "";
        try {
            VcService sourceVcServer = VimSessionUtil.getService((String)serverGuid);
            serviceUrl = VcServiceUtil.getServiceUrl((VcService)sourceVcServer);
            URL vcServerUrl = new URL(serviceUrl);
            return vcServerUrl.getHost();
        }
        catch (MalformedURLException e) {
            String errorMessage = VcExtensionUtil.getLocalizedString("Error.malformedServiceUrl", serviceUrl);
            _logger.error((Object)errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public static String qualifyHostName(String url, String localhostAddress) throws MalformedURLException {
        URL parsedUrl = new URL(url);
        String hostname = parsedUrl.getHost();
        String regexp = null;
        if (hostname.equalsIgnoreCase("localhost")) {
            regexp = "(?i)localhost";
        } else if (hostname.equals(DNS_WILDCARD)) {
            regexp = "\\*";
        } else if (hostname.equals("127.0.0.1")) {
            regexp = "127\\.0\\.0\\.1";
        } else {
            return url;
        }
        String urlString = parsedUrl.toString();
        return urlString.replaceFirst(regexp, localhostAddress);
    }

    public static Extension getExtension(ExtensionUriSpec extensionUri, VcExtensionManagerProxy extensionManagerProxy) throws Exception {
        HashSet<String> extensionKeys = new HashSet<String>(Arrays.asList(extensionUri.getKey()));
        List extensions = extensionManagerProxy.getExtensionsForServer(extensionUri.getServerGuid(), extensionKeys);
        if (extensions.isEmpty()) {
            return null;
        }
        assert (extensions.size() == 1) : "Multiple extensions with key" + extensionUri.getKey();
        return (Extension)extensions.get(0);
    }

    public static ExtensionManager.ExtensionDataUsage getExtensionDataUsage(Extension extension, ExtensionUriSpec extensionUri) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{extension, extensionUri});
        VcService vcService = VimSessionUtil.getService((String)extensionUri.getServerGuid());
        ServiceInstanceContent sic = vcService.getServiceInstanceContent();
        com.vmware.vim.binding.vim.ExtensionManager extensionMan = (com.vmware.vim.binding.vim.ExtensionManager)vcService.getManagedObject(sic.getExtensionManager());
        String[] extensionKeys = new String[]{extension.key};
        Object[] dataUsage = extensionMan.queryExtensionDataUsage(extensionKeys);
        if (ArrayUtil.isNullOrEmpty((Object[])dataUsage)) {
            _logger.warn((Object)("Could not obtain data usage for extension with the URI " + extensionUri + ". The extensionmanager returned " + (dataUsage == null ? "null." : "an empty array.")));
            return null;
        }
        return dataUsage[0];
    }

    public static ManagedObjectReference getServerVm(Extension extension) {
        if (extension == null || extension.extendedProductInfo == null || extension.extendedProductInfo.self == null) {
            return null;
        }
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)extension.extendedProductInfo.self, VirtualMachine.class)) {
            return null;
        }
        return extension.extendedProductInfo.self;
    }

    public static ManagedObjectReference getVcFolder(String serverGuid) {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent serviceInstanceContent = service != null ? service.getServiceInstanceContent() : null;
        return serviceInstanceContent != null ? serviceInstanceContent.rootFolder : null;
    }

    public static Collection<Extension> getSolutionManagerExtensions(String serverGuid, VcExtensionManagerProxy extensionManager) {
        HashSet<String> serverGuids = new HashSet<String>(Arrays.asList(serverGuid));
        Map extensionsByServer = extensionManager.getAllExtensionsForServers(serverGuids);
        List extensions = (List)extensionsByServer.get(serverGuid);
        return CollectionUtil.filter((Collection)extensions, isSolutionManagerExtension);
    }

    public static SolutionManagerInfo.TabInfo[] filterDeprecatedTabs(Extension extension) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{extension});
        if (extension.solutionManagerInfo == null) {
            return null;
        }
        Object[] tabs = extension.solutionManagerInfo.tab;
        if (ArrayUtil.isNullOrEmpty((Object[])tabs)) {
            return extension.solutionManagerInfo.tab;
        }
        ExtensionManager extManager = ExtensionManager.getInstance();
        Object[] pluginPackages = extManager.getAllPluginPackageInfos();
        if (ArrayUtil.isNullOrEmpty((Object[])pluginPackages)) {
            return tabs;
        }
        ArrayList<String> deprecatedUrls = new ArrayList<String>();
        for (Object pluginPackage : pluginPackages) {
            String[] urls;
            Object value;
            ConcurrentMap metadata = pluginPackage.getMetadata();
            if (metadata == null || (value = metadata.get(DEPRECATES_TAB_PROPERTY)) == null) continue;
            if (!(value instanceof String)) {
                _logger.error((Object)("Plugin package '" + pluginPackage + "' has invalid type of metadata value for property '" + DEPRECATES_TAB_PROPERTY + "'. The offending type is " + value.getClass().getSimpleName() + " - expected String."));
                continue;
            }
            String tabsString = (String)value;
            for (String url : urls = tabsString.split(DEPRECATES_TAB_URL_SEPARATOR)) {
                deprecatedUrls.add(url.trim());
            }
        }
        if (deprecatedUrls.isEmpty()) {
            return tabs;
        }
        ArrayList<Object> filtered = new ArrayList<Object>();
        block2: for (Object tabInfo : tabs) {
            for (String deprecatedUrl : deprecatedUrls) {
                if (VcExtensionUtil.equalSolutionManagerTabs(((SolutionManagerInfo.TabInfo)tabInfo).url.trim(), deprecatedUrl)) continue block2;
                filtered.add(tabInfo);
            }
        }
        return (SolutionManagerInfo.TabInfo[])ArrayUtil.toArray(filtered, SolutionManagerInfo.TabInfo.class);
    }

    private static boolean equalSolutionManagerTabs(String tab1, String tab2) {
        if (VcExtensionUtil.equalsIgnoreCase(tab1, tab2)) {
            return true;
        }
        if (tab1.isEmpty() || tab2.isEmpty()) {
            return false;
        }
        URL u1 = null;
        URL u2 = null;
        try {
            u1 = new URL(tab1);
            u2 = new URL(tab2);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!VcExtensionUtil.equalsIgnoreCase(u1.getProtocol(), u2.getProtocol())) {
            return false;
        }
        if (u1.getPort() != u2.getPort()) {
            return false;
        }
        if (!VcExtensionUtil.equalsIgnoreCase(u1.getPath(), u2.getPath())) {
            return false;
        }
        return VcExtensionUtil.equalsIgnoreCase(u1.getHost(), u2.getHost()) || DNS_WILDCARD.equals(u1.getHost()) || DNS_WILDCARD.equals(u2.getHost());
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }
}

