/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data;

import com.vmware.cis.data.ResourceModelDefinitions;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.client.exception.BindingsException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public interface ResourceModelTypes {
    public static final String PROPERTY_MODEL_KEY = "@modelKey";

    public static final class ResourceItem
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private List<DataValue> propertyValues;
        protected final StructValue __dynamicStructureFields;

        public ResourceItem() {
            this(ResourceItem.createEmptyStructValue());
        }

        protected ResourceItem(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public List<DataValue> getPropertyValues() {
            return this.propertyValues;
        }

        public void setPropertyValues(List<DataValue> list) {
            this.propertyValues = list;
        }

        public StructType _getType() {
            return ResourceModelDefinitions.resourceItem;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("property_values", BindingsUtil.toDataValue(this.propertyValues, (Type)this._getType().getField("property_values")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return ResourceModelDefinitions.resourceItem;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return ResourceItem._getClassType().getName();
        }

        public static ResourceItem _newInstance(StructValue structValue) {
            return new ResourceItem(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(ResourceModelDefinitions.resourceItem.getName());
        }

        public static final class Builder {
            private List<DataValue> propertyValues;

            public Builder(List<DataValue> list) {
                this.propertyValues = list;
            }

            public ResourceItem build() {
                ResourceItem resourceItem = new ResourceItem();
                resourceItem.setPropertyValues(this.propertyValues);
                return resourceItem;
            }
        }
    }

    public static final class ResultSet
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private List<String> properties;
        private List<ResourceItem> items;
        protected final StructValue __dynamicStructureFields;

        public ResultSet() {
            this(ResultSet.createEmptyStructValue());
        }

        protected ResultSet(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public void setProperties(List<String> list) {
            this.properties = list;
        }

        public List<ResourceItem> getItems() {
            return this.items;
        }

        public void setItems(List<ResourceItem> list) {
            this.items = list;
        }

        public StructType _getType() {
            return ResourceModelDefinitions.resultSet;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("properties", BindingsUtil.toDataValue(this.properties, (Type)this._getType().getField("properties")));
            structValue.setField("items", BindingsUtil.toDataValue(this.items, (Type)this._getType().getField("items")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return ResourceModelDefinitions.resultSet;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return ResultSet._getClassType().getName();
        }

        public static ResultSet _newInstance(StructValue structValue) {
            return new ResultSet(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(ResourceModelDefinitions.resultSet.getName());
        }

        public static final class Builder {
            private List<String> properties;
            private List<ResourceItem> items;

            public Builder(List<String> list, List<ResourceItem> list2) {
                this.properties = list;
                this.items = list2;
            }

            public ResultSet build() {
                ResultSet resultSet = new ResultSet();
                resultSet.setProperties(this.properties);
                resultSet.setItems(this.items);
                return resultSet;
            }
        }
    }

    public static final class SortCriterion
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String property;
        private SortDirection sortDirection;
        protected final StructValue __dynamicStructureFields;

        public SortCriterion() {
            this(SortCriterion.createEmptyStructValue());
        }

        protected SortCriterion(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public SortDirection getSortDirection() {
            return this.sortDirection;
        }

        public void setSortDirection(SortDirection sortDirection) {
            this.sortDirection = sortDirection;
        }

        public StructType _getType() {
            return ResourceModelDefinitions.sortCriterion;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("property", BindingsUtil.toDataValue((Object)this.property, (Type)this._getType().getField("property")));
            structValue.setField("sort_direction", BindingsUtil.toDataValue((Object)((Object)this.sortDirection), (Type)this._getType().getField("sort_direction")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return ResourceModelDefinitions.sortCriterion;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return SortCriterion._getClassType().getName();
        }

        public static SortCriterion _newInstance(StructValue structValue) {
            return new SortCriterion(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(ResourceModelDefinitions.sortCriterion.getName());
        }

        public static final class Builder {
            private String property;
            private SortDirection sortDirection;

            public Builder(String string) {
                this.property = string;
            }

            public Builder setSortDirection(SortDirection sortDirection) {
                this.sortDirection = sortDirection;
                return this;
            }

            public SortCriterion build() {
                SortCriterion sortCriterion = new SortCriterion();
                sortCriterion.setProperty(this.property);
                sortCriterion.setSortDirection(this.sortDirection);
                return sortCriterion;
            }
        }

        public static final class SortDirection
        extends ApiEnumeration<SortDirection> {
            public static final SortDirection ASCENDING = new SortDirection("ASCENDING");
            public static final SortDirection DESCENDING = new SortDirection("DESCENDING");
            private static final long serialVersionUID = 1L;
            private static final SortDirection[] $VALUES = new SortDirection[]{ASCENDING, DESCENDING};
            private static final Map<String, SortDirection> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

            private SortDirection() {
                super(Values._UNKNOWN.name());
            }

            private SortDirection(String string) {
                super(string);
            }

            public static SortDirection[] values() {
                return (SortDirection[])$VALUES.clone();
            }

            public static SortDirection valueOf(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                SortDirection sortDirection = $NAME_TO_VALUE_MAP.get(string);
                if (sortDirection != null) {
                    return sortDirection;
                }
                return new SortDirection(string);
            }

            public boolean isUnknown() {
                return this.getEnumValue() == Values._UNKNOWN;
            }

            public Values getEnumValue() {
                try {
                    return Values.valueOf(this.name());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Values._UNKNOWN;
                }
            }

            private Object readResolve() {
                return SortDirection.valueOf(this.name());
            }

            public static enum Values {
                ASCENDING,
                DESCENDING,
                _UNKNOWN;

            }
        }
    }

    public static final class PropertyPredicate
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private String property;
        private ComparisonOperator operator;
        private DataValue comparableValue;
        private List<DataValue> comparableList;
        protected final StructValue __dynamicStructureFields;

        public PropertyPredicate() {
            this(PropertyPredicate.createEmptyStructValue());
        }

        protected PropertyPredicate(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public ComparisonOperator getOperator() {
            return this.operator;
        }

        public void setOperator(ComparisonOperator comparisonOperator) {
            this.operator = comparisonOperator;
        }

        public DataValue getComparableValue() {
            return this.comparableValue;
        }

        public void setComparableValue(DataValue dataValue) {
            this.comparableValue = dataValue;
        }

        public List<DataValue> getComparableList() {
            return this.comparableList;
        }

        public void setComparableList(List<DataValue> list) {
            this.comparableList = list;
        }

        public StructType _getType() {
            return ResourceModelDefinitions.propertyPredicate;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("property", BindingsUtil.toDataValue((Object)this.property, (Type)this._getType().getField("property")));
            structValue.setField("operator", BindingsUtil.toDataValue((Object)((Object)this.operator), (Type)this._getType().getField("operator")));
            structValue.setField("comparable_value", BindingsUtil.toDataValue((Object)this.comparableValue, (Type)this._getType().getField("comparable_value")));
            structValue.setField("comparable_list", BindingsUtil.toDataValue(this.comparableList, (Type)this._getType().getField("comparable_list")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return ResourceModelDefinitions.propertyPredicate;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return PropertyPredicate._getClassType().getName();
        }

        public static PropertyPredicate _newInstance(StructValue structValue) {
            return new PropertyPredicate(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(ResourceModelDefinitions.propertyPredicate.getName());
        }

        public static final class Builder {
            private String property;
            private ComparisonOperator operator;
            private DataValue comparableValue;
            private List<DataValue> comparableList;

            public Builder(String string, ComparisonOperator comparisonOperator) {
                this.property = string;
                this.operator = comparisonOperator;
            }

            public Builder setComparableValue(DataValue dataValue) {
                this.comparableValue = dataValue;
                return this;
            }

            public Builder setComparableList(List<DataValue> list) {
                this.comparableList = list;
                return this;
            }

            public PropertyPredicate build() {
                PropertyPredicate propertyPredicate = new PropertyPredicate();
                propertyPredicate.setProperty(this.property);
                propertyPredicate.setOperator(this.operator);
                propertyPredicate.setComparableValue(this.comparableValue);
                propertyPredicate.setComparableList(this.comparableList);
                return propertyPredicate;
            }
        }

        public static final class ComparisonOperator
        extends ApiEnumeration<ComparisonOperator> {
            public static final ComparisonOperator EQUAL = new ComparisonOperator("EQUAL");
            public static final ComparisonOperator NOT_EQUAL = new ComparisonOperator("NOT_EQUAL");
            public static final ComparisonOperator GREATER = new ComparisonOperator("GREATER");
            public static final ComparisonOperator GREATER_OR_EQUAL = new ComparisonOperator("GREATER_OR_EQUAL");
            public static final ComparisonOperator LESS = new ComparisonOperator("LESS");
            public static final ComparisonOperator LESS_OR_EQUAL = new ComparisonOperator("LESS_OR_EQUAL");
            public static final ComparisonOperator IN = new ComparisonOperator("IN");
            private static final long serialVersionUID = 1L;
            private static final ComparisonOperator[] $VALUES = new ComparisonOperator[]{EQUAL, NOT_EQUAL, GREATER, GREATER_OR_EQUAL, LESS, LESS_OR_EQUAL, IN};
            private static final Map<String, ComparisonOperator> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

            private ComparisonOperator() {
                super(Values._UNKNOWN.name());
            }

            private ComparisonOperator(String string) {
                super(string);
            }

            public static ComparisonOperator[] values() {
                return (ComparisonOperator[])$VALUES.clone();
            }

            public static ComparisonOperator valueOf(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                ComparisonOperator comparisonOperator = $NAME_TO_VALUE_MAP.get(string);
                if (comparisonOperator != null) {
                    return comparisonOperator;
                }
                return new ComparisonOperator(string);
            }

            public boolean isUnknown() {
                return this.getEnumValue() == Values._UNKNOWN;
            }

            public Values getEnumValue() {
                try {
                    return Values.valueOf(this.name());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Values._UNKNOWN;
                }
            }

            private Object readResolve() {
                return ComparisonOperator.valueOf(this.name());
            }

            public static enum Values {
                EQUAL,
                NOT_EQUAL,
                GREATER,
                GREATER_OR_EQUAL,
                LESS,
                LESS_OR_EQUAL,
                IN,
                _UNKNOWN;

            }
        }
    }

    public static final class Filter
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private List<PropertyPredicate> criteria;
        private LogicalOperator operator;
        protected final StructValue __dynamicStructureFields;

        public Filter() {
            this(Filter.createEmptyStructValue());
        }

        protected Filter(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public List<PropertyPredicate> getCriteria() {
            return this.criteria;
        }

        public void setCriteria(List<PropertyPredicate> list) {
            this.criteria = list;
        }

        public LogicalOperator getOperator() {
            return this.operator;
        }

        public void setOperator(LogicalOperator logicalOperator) {
            this.operator = logicalOperator;
        }

        public StructType _getType() {
            return ResourceModelDefinitions.filter;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("criteria", BindingsUtil.toDataValue(this.criteria, (Type)this._getType().getField("criteria")));
            structValue.setField("operator", BindingsUtil.toDataValue((Object)((Object)this.operator), (Type)this._getType().getField("operator")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return ResourceModelDefinitions.filter;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return Filter._getClassType().getName();
        }

        public static Filter _newInstance(StructValue structValue) {
            return new Filter(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(ResourceModelDefinitions.filter.getName());
        }

        public static final class Builder {
            private List<PropertyPredicate> criteria;
            private LogicalOperator operator;

            public Builder(List<PropertyPredicate> list) {
                this.criteria = list;
            }

            public Builder setOperator(LogicalOperator logicalOperator) {
                this.operator = logicalOperator;
                return this;
            }

            public Filter build() {
                Filter filter = new Filter();
                filter.setCriteria(this.criteria);
                filter.setOperator(this.operator);
                return filter;
            }
        }

        public static final class LogicalOperator
        extends ApiEnumeration<LogicalOperator> {
            public static final LogicalOperator AND = new LogicalOperator("AND");
            public static final LogicalOperator OR = new LogicalOperator("OR");
            private static final long serialVersionUID = 1L;
            private static final LogicalOperator[] $VALUES = new LogicalOperator[]{AND, OR};
            private static final Map<String, LogicalOperator> $NAME_TO_VALUE_MAP = ApiEnumeration.buildNameMap((ApiEnumeration[])$VALUES);

            private LogicalOperator() {
                super(Values._UNKNOWN.name());
            }

            private LogicalOperator(String string) {
                super(string);
            }

            public static LogicalOperator[] values() {
                return (LogicalOperator[])$VALUES.clone();
            }

            public static LogicalOperator valueOf(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                LogicalOperator logicalOperator = $NAME_TO_VALUE_MAP.get(string);
                if (logicalOperator != null) {
                    return logicalOperator;
                }
                return new LogicalOperator(string);
            }

            public boolean isUnknown() {
                return this.getEnumValue() == Values._UNKNOWN;
            }

            public Values getEnumValue() {
                try {
                    return Values.valueOf(this.name());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Values._UNKNOWN;
                }
            }

            private Object readResolve() {
                return LogicalOperator.valueOf(this.name());
            }

            public static enum Values {
                AND,
                OR,
                _UNKNOWN;

            }
        }
    }

    public static final class QuerySpec
    implements Serializable,
    StaticStructure {
        private static final long serialVersionUID = 1L;
        private List<String> properties;
        private List<String> resourceModels;
        private Filter filter;
        private List<SortCriterion> sortCriteria;
        private Long limit;
        protected final StructValue __dynamicStructureFields;

        public QuerySpec() {
            this(QuerySpec.createEmptyStructValue());
        }

        protected QuerySpec(StructValue structValue) {
            Validate.notNull((Object)structValue);
            this.__dynamicStructureFields = structValue;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public void setProperties(List<String> list) {
            this.properties = list;
        }

        public List<String> getResourceModels() {
            return this.resourceModels;
        }

        public void setResourceModels(List<String> list) {
            this.resourceModels = list;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
        }

        public List<SortCriterion> getSortCriteria() {
            return this.sortCriteria;
        }

        public void setSortCriteria(List<SortCriterion> list) {
            this.sortCriteria = list;
        }

        public Long getLimit() {
            return this.limit;
        }

        public void setLimit(Long l) {
            this.limit = l;
        }

        public StructType _getType() {
            return ResourceModelDefinitions.querySpec;
        }

        public StructValue _getDataValue() {
            StructValue structValue = this.__dynamicStructureFields.copy();
            this._updateDataValue(structValue);
            return structValue;
        }

        protected void _updateDataValue(StructValue structValue) {
            structValue.setField("properties", BindingsUtil.toDataValue(this.properties, (Type)this._getType().getField("properties")));
            structValue.setField("resource_models", BindingsUtil.toDataValue(this.resourceModels, (Type)this._getType().getField("resource_models")));
            structValue.setField("filter", BindingsUtil.toDataValue((Object)this.filter, (Type)this._getType().getField("filter")));
            structValue.setField("sort_criteria", BindingsUtil.toDataValue(this.sortCriteria, (Type)this._getType().getField("sort_criteria")));
            structValue.setField("limit", BindingsUtil.toDataValue((Object)this.limit, (Type)this._getType().getField("limit")));
        }

        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        public boolean equals(Object object) {
            return BindingsUtil.areEqual((StaticStructure)this, (Object)object);
        }

        public int hashCode() {
            return BindingsUtil.computeHashCode((StaticStructure)this);
        }

        public String toString() {
            return BindingsUtil.convertToString((StaticStructure)this, (StructValue)this.__dynamicStructureFields);
        }

        public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
            return BindingsUtil.hasTypeNameOf((StructValue)this.__dynamicStructureFields, clazz);
        }

        public <T extends Structure> T _convertTo(Class<T> clazz) {
            return (T)BindingsUtil.convertTo((Structure)this, clazz);
        }

        public void _setDynamicField(String string, DataValue dataValue) {
            if (this._getType().getFieldNames().contains(string)) {
                throw new BindingsException("The structure contains static field with name " + string);
            }
            this.__dynamicStructureFields.setField(string, dataValue);
        }

        public DataValue _getDynamicField(String string) {
            if (!this.__dynamicStructureFields.getFieldNames().contains(string)) {
                throw new BindingsException("The structure doesn't contain dynamic field with name " + string);
            }
            return this.__dynamicStructureFields.getField(string);
        }

        public Set<String> _getDynamicFieldNames() {
            return this.__dynamicStructureFields.getFieldNames();
        }

        public static StructType _getClassType() {
            return ResourceModelDefinitions.querySpec;
        }

        public String _getCanonicalName() {
            return this.__dynamicStructureFields.getName();
        }

        public static String _getCanonicalTypeName() {
            return QuerySpec._getClassType().getName();
        }

        public static QuerySpec _newInstance(StructValue structValue) {
            return new QuerySpec(structValue);
        }

        private static StructValue createEmptyStructValue() {
            return new StructValue(ResourceModelDefinitions.querySpec.getName());
        }

        public static final class Builder {
            private List<String> properties;
            private List<String> resourceModels;
            private Filter filter;
            private List<SortCriterion> sortCriteria;
            private Long limit;

            public Builder(List<String> list, List<String> list2) {
                this.properties = list;
                this.resourceModels = list2;
            }

            public Builder setFilter(Filter filter) {
                this.filter = filter;
                return this;
            }

            public Builder setSortCriteria(List<SortCriterion> list) {
                this.sortCriteria = list;
                return this;
            }

            public Builder setLimit(Long l) {
                this.limit = l;
                return this;
            }

            public QuerySpec build() {
                QuerySpec querySpec = new QuerySpec();
                querySpec.setProperties(this.properties);
                querySpec.setResourceModels(this.resourceModels);
                querySpec.setFilter(this.filter);
                querySpec.setSortCriteria(this.sortCriteria);
                querySpec.setLimit(this.limit);
                return querySpec;
            }
        }
    }
}

