/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.impl;

import com.vmware.eam.AgencyOperation;
import com.vmware.eam.AgencyOperationSpec;
import com.vmware.eam.util.EamConnection;
import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.fault.InvalidAgencyScope;
import com.vmware.vim.binding.eam.fault.InvalidAgentConfiguration;
import com.vmware.vim.binding.eam.fault.InvalidUrl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.task.TaskRegistry;
import com.vmware.vsphere.client.task.impl.ParametrizedMessageException;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgencyMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(AgencyMutationProvider.class);
    private final TaskRegistry _taskRegistry;

    public AgencyMutationProvider(TaskRegistry taskRegistry) {
        assert (taskRegistry != null);
        this._taskRegistry = taskRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] agencies, AgencyOperationSpec opSpec) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{agencies, opSpec});
        _logger.debug((Object)("Apply agency operation on " + agencies.length + " agencies"));
        ArrayList<OperationResult> results = new ArrayList<OperationResult>(agencies.length);
        List<ManagedObjectReference> agencyList = Arrays.asList(agencies);
        Map<String, List<ManagedObjectReference>> agenciesByServer = EamUtil.moRefPerServer(agencyList);
        for (String serverGuid : agenciesByServer.keySet()) {
            EamConnection eamConnection = null;
            try {
                eamConnection = EamConnection.newInstance(serverGuid);
                List<ManagedObjectReference> agencyRefs = agenciesByServer.get(serverGuid);
                this.applyOperation(opSpec, agencyRefs, eamConnection, results);
            }
            finally {
                EamConnection.tryClose((VcExtensionConnection)eamConnection);
            }
        }
        return (OperationResult[])ArrayUtil.toArray(results, OperationResult.class);
    }

    private void applyOperation(AgencyOperationSpec opSpec, List<ManagedObjectReference> agencies, EamConnection eamConnection, List<OperationResult> results) {
        assert (opSpec != null && agencies != null && eamConnection != null && results != null);
        ArrayList<String> agencyNames = new ArrayList<String>(agencies.size());
        int failures = 0;
        for (ManagedObjectReference agencyRef : agencies) {
            OperationResult result = new OperationResult();
            result.entity = agencyRef;
            String errorMsgKey = null;
            try {
                Agency agency = eamConnection.getAgency(EamUtil.dsToEamMoref(agencyRef));
                Agency.ConfigInfo agencyConfig = agency.getConfig();
                agencyNames.add(agencyConfig.getAgencyName());
                if (opSpec.operation == AgencyOperation.DISABLE_OPTIMIZED_DEPLOY || opSpec.operation == AgencyOperation.ENABLE_OPTIMIZED_DEPLOY) {
                    agencyConfig.setOptimizedDeploymentEnabled(Boolean.valueOf(opSpec.operation == AgencyOperation.ENABLE_OPTIMIZED_DEPLOY));
                    try {
                        agency.update(agencyConfig);
                    }
                    catch (InvalidAgentConfiguration invalidAgentConfig) {
                        errorMsgKey = "error.mutationOperationFailed.invalidAgentConfig";
                        _logger.error((Object)("Exception updating " + agencyRef), (Throwable)invalidAgentConfig);
                    }
                    catch (InvalidAgencyScope invalidAgencyScope) {
                        errorMsgKey = "error.mutationOperationFailed.invalidAgencyScope";
                        _logger.error((Object)("Exception updating " + agencyRef), (Throwable)invalidAgencyScope);
                    }
                    catch (InvalidUrl invalidUrl) {
                        errorMsgKey = "error.mutationOperationFailed.invalidUrl";
                        _logger.error((Object)("Exception updating " + agencyRef), (Throwable)invalidUrl);
                    }
                } else if (opSpec.operation == AgencyOperation.DELETE_AGENCY) {
                    agency.destroyAgency();
                } else if (opSpec.operation == AgencyOperation.RESOLVE_ALL_ISSUES) {
                    agency.resolveAll();
                } else if (opSpec.operation == AgencyOperation.RESOLVE_ISSUES) {
                    if (ArrayUtil.isNullOrEmpty((Object[])opSpec.arguments)) {
                        _logger.warn((Object)"Request to resolve specific agency issues does not contain any issue keys.");
                        continue;
                    }
                    int[] issueKeys = new int[opSpec.arguments.length];
                    for (int i = 0; i < opSpec.arguments.length; ++i) {
                        Integer key = (Integer)opSpec.arguments[i];
                        issueKeys[i] = key;
                    }
                    agency.resolve(issueKeys);
                }
            }
            catch (Exception genericEamException) {
                errorMsgKey = "error.mutationOperationFailed.unknownReason";
                _logger.error((Object)("Agency mutation operation " + (Object)((Object)opSpec.operation) + " failed with the exception: " + genericEamException));
            }
            if (errorMsgKey != null) {
                result.error = new MethodFault(errorMsgKey);
                ++failures;
            }
            results.add(result);
        }
        this.registerFinishedTask(opSpec.operation, agencyNames, eamConnection.getServerGuid(), failures);
    }

    private void registerFinishedTask(AgencyOperation operation, List<String> agencyNames, String serverGuid, int failures) {
        assert (operation != null && !StringUtil.isNullOrEmpty((String)serverGuid) && agencyNames != null && failures >= 0);
        ParametrizedMessageException error = null;
        if (failures != 0) {
            error = new ParametrizedMessageException("action.agency.failed", new String[]{String.valueOf(failures), String.valueOf(agencyNames.size())});
        }
        ClientTaskInfo task = EamUtil.newFinishedEamTask(serverGuid, operation.getTaskLabelKey(), error);
        if (agencyNames.size() == 1) {
            task.details = operation.getTaskDetailsKeySingular();
        } else if (agencyNames.size() > 1) {
            task.details = operation.getTaskDetailsKeyPlural();
        } else {
            _logger.error((Object)"Name not retrieved for some operation target entites");
        }
        this._taskRegistry.addTask(task);
    }
}

