/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query;

import java.util.ArrayList;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyConstraintValueAdapter
extends XmlAdapter<Object, Object> {
    private static final String TYPE_INTEGER = "Int";
    private static final String TYPE_BOOLEAN = "Boolean";
    private static final String TYPE_ARRAY = "Array";

    public Object unmarshal(Object object) {
        if (!(object instanceof Node)) {
            return object;
        }
        Node node = (Node)object;
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        String string = node2.getNodeName();
        Object object2 = TYPE_ARRAY.equalsIgnoreCase(string) ? this.parseArray(node2) : this.toPrimitiveValue(string, node2.getTextContent());
        return object2;
    }

    private Object toPrimitiveValue(String string, String string2) {
        if (TYPE_BOOLEAN.equalsIgnoreCase(string)) {
            return Boolean.parseBoolean(string2);
        }
        if (TYPE_INTEGER.equalsIgnoreCase(string)) {
            return Integer.parseInt(string2);
        }
        return string2;
    }

    private Object[] parseArray(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (1 != node2.getNodeType()) continue;
            String string = node2.getNodeName();
            Object object = this.toPrimitiveValue(string, node2.getTextContent());
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public Object marshal(Object object) throws Exception {
        return object;
    }
}

