/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.RequestProcessor;
import com.vmware.vise.data.query.commands.impl.ResponseProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDataFetchCommand
implements DataFetchCommand {
    private static final Log _logger = LogFactory.getLog(DataFetchCommandFactory.class);
    private final DataService _dataService;

    public DefaultDataFetchCommand(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException("dataService cannot be null");
        }
        this._dataService = dataService;
    }

    @Override
    public <T extends DataModel> Collection<T> execute(Class<T> clazz, Constraint constraint, Map<String, Object> map) {
        if (clazz == null) {
            throw new IllegalArgumentException("dataModel must be non-null.");
        }
        if (constraint == null) {
            _logger.error((Object)"Constraint can not be null.");
            return Collections.emptySet();
        }
        RequestProcessor<T> requestProcessor = new RequestProcessor<T>(clazz, constraint, map, null);
        Response response = new Response();
        response = this._dataService.getData(requestProcessor.getRequestSpec());
        ResultSet[] resultSetArray = response.resultSet;
        ResponseProcessor<T> responseProcessor = new ResponseProcessor<T>(requestProcessor, resultSetArray);
        return responseProcessor.getDataModelInstances();
    }

    @Override
    public <T extends DataModel> Collection<T> execute(Class<T> clazz, Object[] objectArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("dataModel must be non-null");
        }
        if (objectArray == null) {
            _logger.error((Object)"Null entities reference passed to runDataRequest");
            return Collections.emptySet();
        }
        if (objectArray.length == 0) {
            _logger.warn((Object)"Empty entities passed to runDataRequest");
            return Collections.emptySet();
        }
        Constraint constraint = QueryUtil.combineIntoSingleConstraint(objectArray, Conjoiner.OR);
        return this.execute(clazz, constraint, null);
    }
}

