/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.ProfiledTaskExecutor;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataAdapterUtil {
    private static final Logger _logger = LoggerFactory.getLogger(DataAdapterUtil.class);

    DataAdapterUtil() {
    }

    static Callable<DataAdaptersExecutionResult> createAdapterTask(final DataAdapterInfo dataAdapterInfo, final QuerySpec[] querySpecArray, final String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataAdapterInfo, querySpecArray, string});
        Callable<DataAdaptersExecutionResult> callable = new Callable<DataAdaptersExecutionResult>(){

            @Override
            public DataAdaptersExecutionResult call() throws Exception {
                DataAdaptersExecutionResult dataAdaptersExecutionResult = DataAdapterUtil.getResultFromAdapter(dataAdapterInfo, querySpecArray);
                return dataAdaptersExecutionResult;
            }

            public String toString() {
                String string2 = string + " " + dataAdapterInfo.adapter.getClass().getName();
                return string2;
            }
        };
        return callable;
    }

    static List<DataAdaptersExecutionResult> executeAdapterTasks(ProfiledTaskExecutor profiledTaskExecutor, List<DataAdapterQueryBatch> list, List<Callable<DataAdaptersExecutionResult>> list2) throws InterruptedException {
        assert (profiledTaskExecutor != null);
        assert (list != null && list2 != null);
        assert (list.size() == list2.size());
        List list3 = profiledTaskExecutor.executeTasks(list2);
        ArrayList<DataAdaptersExecutionResult> arrayList = new ArrayList<DataAdaptersExecutionResult>(list3.size());
        for (int i = 0; i < list3.size(); ++i) {
            DataAdaptersExecutionResult dataAdaptersExecutionResult;
            ExecutorUtil.TaskResult taskResult = list3.get(i);
            Exception exception = taskResult.getException();
            if (exception != null) {
                DataAdapterQueryBatch dataAdapterQueryBatch = list.get(i);
                String string = dataAdapterQueryBatch.daInfo.adapter.getClass().getName();
                exception = DataAdapterUtil.processDataAdapterTaskException(exception, string, profiledTaskExecutor.getTaskTimeoutInSecs());
                Map<QuerySpec, ResultSetInfo> map = DataAdapterUtil.constructErrorResultForAdapter(string, dataAdapterQueryBatch.queryBatch, exception);
                dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map, null);
            } else {
                dataAdaptersExecutionResult = (DataAdaptersExecutionResult)taskResult.getResult();
            }
            arrayList.add(dataAdaptersExecutionResult);
        }
        return arrayList;
    }

    private static Exception processDataAdapterTaskException(Exception exception, String string, long l) {
        if (!(exception instanceof TimeoutException)) {
            return exception;
        }
        String string2 = String.format(Utils.getLocalizedString("error.dataAdapterTimeout"), string, l);
        return new DataServiceException(string2, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataAdaptersExecutionResult getResultFromAdapter(DataAdapterInfo dataAdapterInfo, QuerySpec[] querySpecArray) {
        assert (dataAdapterInfo != null);
        assert (querySpecArray != null);
        try (ViseDsLogConfigurator.ViseDsLogContext viseDsLogContext = ViseDsLogConfigurator.onDataAdapterStart(dataAdapterInfo.adapter);){
            DataAdaptersExecutionResult dataAdaptersExecutionResult;
            long l = System.currentTimeMillis();
            Map<QuerySpec, ResultSetInfo> map = DataAdapterUtil.getDataFromAdapter(dataAdapterInfo, querySpecArray);
            long l2 = System.currentTimeMillis() - l;
            DataAdapterExecutionDetails dataAdapterExecutionDetails = new DataAdapterExecutionDetails(dataAdapterInfo, viseDsLogContext.getInvocationId(), l2, querySpecArray);
            DataAdaptersExecutionResult dataAdaptersExecutionResult2 = dataAdaptersExecutionResult = new DataAdaptersExecutionResult(map, Arrays.asList(dataAdapterExecutionDetails));
            return dataAdaptersExecutionResult2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<QuerySpec, ResultSetInfo> getDataFromAdapter(DataAdapterInfo dataAdapterInfo, QuerySpec[] querySpecArray) {
        Response response;
        Object object;
        ResultSet[] resultSetArray;
        assert (dataAdapterInfo != null && dataAdapterInfo.adapter != null);
        assert (!ArrayUtil.isNullOrEmpty((Object[])querySpecArray));
        DataProviderAdapter dataProviderAdapter = dataAdapterInfo.adapter;
        String string = dataAdapterInfo.toString();
        Map<Object, Object> map = new IdentityHashMap();
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        ExecutionProfiler executionProfiler = SessionUtil.getExecutionProfiler();
        try {
            resultSetArray = "dataService." + dataAdapterInfo.toString();
            object = executionProfiler.startTimer((String)resultSetArray);
            try {
                response = dataProviderAdapter.getData(requestSpec);
            }
            finally {
                executionProfiler.stopTimer(object);
            }
        }
        catch (Exception exception) {
            return DataAdapterUtil.constructErrorResultForAdapter(string, querySpecArray, exception);
        }
        catch (AssertionError assertionError) {
            IllegalStateException illegalStateException = new IllegalStateException(String.format("Data adapter %s failed with internal assertion error with message `%s'.", string, ((Throwable)((Object)assertionError)).getMessage()), (Throwable)((Object)assertionError));
            return DataAdapterUtil.constructErrorResultForAdapter(string, querySpecArray, (Exception)illegalStateException);
        }
        resultSetArray = null;
        if (response != null) {
            resultSetArray = response.resultSet;
            ResultUtil.setQueryNamesIntoResults(querySpecArray, resultSetArray);
        }
        if (dataProviderAdapter instanceof DynamicProviderAdapter) {
            object = resultSetArray != null ? (DynamicProviderResultSet[])resultSetArray : null;
            map = DataAdapterUtil.createResults(querySpecArray, (DynamicProviderResultSet[])object);
        } else {
            map = DataAdapterUtil.createResults(dataAdapterInfo, querySpecArray, resultSetArray);
        }
        if (map.size() == 0) {
            DataAdapterUtil.logInabilityToExecuteQueries(string, querySpecArray);
            return null;
        }
        if (map.size() != querySpecArray.length) {
            object = "Invalid ResultSet[] size received from adapter " + string + " getData(): " + map.size() + ". It should match QuerySpec[] size: " + querySpecArray.length;
            _logger.error((String)object);
            return DataAdapterUtil.constructErrorResultForAdapter(string, querySpecArray, null);
        }
        DataAdapterUtil.logQueryResultsForAdapter(dataAdapterInfo, map);
        return map;
    }

    private static void logQueryResultsForAdapter(DataAdapterInfo dataAdapterInfo, Map<QuerySpec, ResultSetInfo> map) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = dataAdapterInfo.adapter.getClass().getCanonicalName();
        for (QuerySpec querySpec : map.keySet()) {
            ResultSetInfo resultSetInfo = map.get(querySpec);
            ResultSet resultSet = resultSetInfo.getResultSet();
            if (_logger.isTraceEnabled()) {
                stringBuilder.append(String.format("For data adapter '%s' query '%s' returned:\n%s", string, querySpec.name, Utils.renderResultSet(resultSet)));
            } else {
                stringBuilder.append(String.format("For data adapter '%s' query '%s' returned '%s' items.", string, querySpec.name, resultSet.items == null ? null : Integer.valueOf(resultSet.items.length)));
            }
            stringBuilder.append("\n");
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace(stringBuilder.toString());
        } else {
            _logger.debug(stringBuilder.toString());
        }
    }

    private static void logInabilityToExecuteQueries(String string, QuerySpec[] querySpecArray) {
        String string2 = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Adapter ").append(string).append(" cannot return result for: ").append(string2);
        for (QuerySpec querySpec : querySpecArray) {
            String string3 = Utils.renderQuerySpec(querySpec);
            stringBuilder.append(string3).append(string2);
        }
        _logger.debug(stringBuilder.toString());
    }

    private static Map<QuerySpec, ResultSetInfo> createResults(DataAdapterInfo dataAdapterInfo, QuerySpec[] querySpecArray, ResultSet[] resultSetArray) {
        if (resultSetArray == null) {
            return new IdentityHashMap<QuerySpec, ResultSetInfo>(0);
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> identityHashMap = new IdentityHashMap<QuerySpec, ResultSetInfo>(resultSetArray.length);
        for (int i = 0; i < resultSetArray.length; ++i) {
            String string;
            Object object;
            boolean bl;
            ResultSet resultSet = resultSetArray[i];
            QuerySpec querySpec = querySpecArray[i];
            ResultSpec resultSpec = querySpec.resultSpec;
            if (resultSpec == null) {
                resultSpec = new ResultSpec();
            }
            boolean bl2 = resultSpec.order != null && !ArrayUtil.isNullOrEmpty((Object[])resultSpec.order.orderingProperties);
            boolean bl3 = resultSet != null && resultSet.items != null;
            boolean bl4 = bl = bl3 && resultSpec.offset != null && resultSpec.offset > 0 && resultSpec.maxResultCount != null && resultSpec.maxResultCount >= resultSet.items.length;
            if (!bl && bl3 && _logger.isDebugEnabled()) {
                object = dataAdapterInfo.adapter.getClass().getName();
                string = String.format("Data service will page the received '%s' items from adapter '%s' for query '%s' with offset '%s' and maxResultCount '%s'", querySpec.name, resultSet.items.length, object, resultSpec.offset, resultSpec.maxResultCount);
                _logger.debug(string);
            }
            if (bl3 && resultSpec.maxResultCount != null && resultSpec.maxResultCount >= 0 && resultSpec.maxResultCount < resultSet.items.length) {
                object = dataAdapterInfo.adapter.getClass().getName();
                string = String.format("Too many items were returned for query %s by adapter %s: got %d items and resultSpec.maxResultCount was %s.\nPaging will be applied by the DataService but you should fix your DataAdapterProvider to handle resultSpec correctly!", querySpec.name, object, resultSet.items.length, resultSpec.maxResultCount);
                _logger.warn(string);
            }
            object = resultSet == null ? ResultSetInfo.newEmptyResultSetInfo(querySpec.name) : ResultSetInfo.getResultSetInfo(resultSet, bl2, bl);
            identityHashMap.put(querySpec, (ResultSetInfo)object);
        }
        return identityHashMap;
    }

    private static Map<QuerySpec, ResultSetInfo> createResults(QuerySpec[] querySpecArray, DynamicProviderResultSet[] dynamicProviderResultSetArray) {
        if (dynamicProviderResultSetArray == null) {
            return new IdentityHashMap<QuerySpec, ResultSetInfo>(0);
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> identityHashMap = new IdentityHashMap<QuerySpec, ResultSetInfo>(dynamicProviderResultSetArray.length);
        for (int i = 0; i < dynamicProviderResultSetArray.length; ++i) {
            DynamicProviderResultSet dynamicProviderResultSet = dynamicProviderResultSetArray[i];
            QuerySpec querySpec = querySpecArray[i];
            ResultSetInfo resultSetInfo = DataAdapterUtil.getResultSetInfo(querySpec.name, dynamicProviderResultSet);
            identityHashMap.put(querySpec, resultSetInfo);
        }
        return identityHashMap;
    }

    private static ResultSetInfo getResultSetInfo(String string, DynamicProviderResultSet dynamicProviderResultSet) {
        if (dynamicProviderResultSet == null) {
            ResultSetInfo resultSetInfo = ResultSetInfo.newEmptyResultSetInfo(string);
            return resultSetInfo;
        }
        ResultSetInfo resultSetInfo = ResultSetInfo.getResultSetInfo(dynamicProviderResultSet, dynamicProviderResultSet.sorted, dynamicProviderResultSet.paged);
        return resultSetInfo;
    }

    private static Map<QuerySpec, ResultSetInfo> constructErrorResultForAdapter(String string, QuerySpec[] querySpecArray, Exception exception) {
        IdentityHashMap<QuerySpec, ResultSetInfo> identityHashMap = new IdentityHashMap<QuerySpec, ResultSetInfo>();
        for (QuerySpec querySpec : querySpecArray) {
            ResultSetInfo resultSetInfo = DataAdapterUtil.constructErrorResultForAdapter(string, querySpec, exception);
            identityHashMap.put(querySpec, resultSetInfo);
        }
        return identityHashMap;
    }

    private static ResultSetInfo constructErrorResultForAdapter(String string, QuerySpec querySpec, Exception exception) {
        Exception exception2 = exception;
        if (exception2 == null) {
            exception2 = new DataServiceException(String.format(Utils.getLocalizedString("error.invalidAdapterResult"), string));
        }
        ResultSetInfo resultSetInfo = ResultSetInfo.createErrorResult(exception2);
        resultSetInfo.getResultSet().queryName = querySpec.name;
        return resultSetInfo;
    }

    static class DataAdapterQueryBatch {
        DataAdapterInfo daInfo;
        QuerySpec[] queryBatch;

        DataAdapterQueryBatch(DataAdapterInfo dataAdapterInfo, QuerySpec[] querySpecArray) {
            assert (dataAdapterInfo != null);
            assert (!ArrayUtils.isEmpty((Object[])querySpecArray));
            this.daInfo = dataAdapterInfo;
            this.queryBatch = querySpecArray;
        }
    }
}

