/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.impl.DataServiceThreadPoolStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class DataServiceThreadPoolDecorator
implements ExecutorService {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceThreadPoolDecorator.class);
    private final ThreadPoolExecutor _executor;
    private final DataServiceThreadPoolStats _threadPoolStats;

    DataServiceThreadPoolDecorator(ThreadPoolExecutor threadPoolExecutor, String string, int n) {
        assert (threadPoolExecutor != null);
        assert (string != null);
        this._executor = threadPoolExecutor;
        this._threadPoolStats = new DataServiceThreadPoolStats(threadPoolExecutor, string, n);
    }

    @Override
    public void execute(Runnable runnable) {
        Validate.notNull((Object)runnable);
        this._executor.execute(DataServiceThreadPoolDecorator.mdcAware(runnable));
        this._threadPoolStats.logUsageIfChanged();
    }

    @Override
    public void shutdown() {
        this._executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this._executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this._executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this._executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this._executor.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        Validate.notNull(callable);
        Future<T> future = this._executor.submit(DataServiceThreadPoolDecorator.mdcAware(callable));
        this._threadPoolStats.logUsageIfChanged();
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        Validate.notNull((Object)runnable);
        Future<T> future = this._executor.submit(DataServiceThreadPoolDecorator.mdcAware(runnable), t);
        this._threadPoolStats.logUsageIfChanged();
        return future;
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        Validate.notNull((Object)runnable);
        Future<?> future = this._executor.submit(DataServiceThreadPoolDecorator.mdcAware(runnable));
        this._threadPoolStats.logUsageIfChanged();
        return future;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        Validate.notNull(collection);
        List<Future<T>> list = this._executor.invokeAll(DataServiceThreadPoolDecorator.mdcAware(collection));
        this._threadPoolStats.logUsageIfChanged();
        return list;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        Validate.notNull(collection);
        List<Future<T>> list = this._executor.invokeAll(DataServiceThreadPoolDecorator.mdcAware(collection), l, timeUnit);
        this._threadPoolStats.logUsageIfChanged();
        return list;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        Validate.notNull(collection);
        T t = this._executor.invokeAny(DataServiceThreadPoolDecorator.mdcAware(collection));
        this._threadPoolStats.logUsageIfChanged();
        return t;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Validate.notNull(collection);
        T t = this._executor.invokeAny(DataServiceThreadPoolDecorator.mdcAware(collection), l, timeUnit);
        this._threadPoolStats.logUsageIfChanged();
        return t;
    }

    private static <T> Collection<Callable<T>> mdcAware(Collection<? extends Callable<T>> collection) {
        ArrayList<Callable<T>> arrayList = new ArrayList<Callable<T>>();
        for (Callable<T> callable : collection) {
            arrayList.add(DataServiceThreadPoolDecorator.mdcAware(callable));
        }
        return arrayList;
    }

    private static <T> Callable<T> mdcAware(final Callable<T> callable) {
        assert (callable != null);
        final long l = Thread.currentThread().getId();
        final Map map = MDC.getCopyOfContextMap();
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                long l2 = Thread.currentThread().getId();
                if (l2 != l) {
                    MDC.setContextMap((Map)map);
                }
                try {
                    Object v = callable.call();
                    return v;
                }
                catch (Throwable throwable) {
                    _logger.warn("Data Service execution for task: {} has failed", (Object)callable, (Object)throwable);
                    throw throwable;
                }
                finally {
                    if (l2 != l) {
                        MDC.clear();
                    }
                }
            }
        };
    }

    private static Runnable mdcAware(final Runnable runnable) {
        assert (runnable != null);
        final long l = Thread.currentThread().getId();
        final Map map = MDC.getCopyOfContextMap();
        return new Runnable(){

            @Override
            public void run() {
                long l2 = Thread.currentThread().getId();
                if (l2 != l) {
                    MDC.setContextMap((Map)map);
                }
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    _logger.warn("Data Service execution for task: {} has failed", (Object)runnable, (Object)throwable);
                    throw throwable;
                }
                finally {
                    if (l2 != l) {
                        MDC.clear();
                    }
                }
            }
        };
    }
}

