/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.internal.profiling;

import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DerivedPropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.PropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.PropertyProvidersExecutionResult;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.util.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingUtil {
    private static final Logger _logger = LoggerFactory.getLogger(ProfilingUtil.class);

    public static void logSlowExecutions(QuerySpec[] querySpecArray, long l, DataAdaptersExecutionResult dataAdaptersExecutionResult, List<PropertyProvidersExecutionResult> list) {
        boolean bl;
        if (!_logger.isWarnEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)ProfilingUtil.logDataProviderDetails(dataAdaptersExecutionResult));
        for (PropertyProvidersExecutionResult propertyProvidersExecutionResult : list) {
            stringBuilder.append((CharSequence)ProfilingUtil.logPropertyProviderDetails(propertyProvidersExecutionResult));
        }
        boolean bl2 = stringBuilder.length() > 0;
        boolean bl3 = bl = l > Config.QUERY_BATCH_TIME_THRESHOLD;
        if (bl2 || bl) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("The Data Service detected slow execution:\n");
            String string = ViseDsLogConfigurator.getProviderInvocation();
            if (string != null) {
                stringBuilder2.append("DataService is called by provider invocation: " + string + "\n");
            }
            if (bl) {
                stringBuilder2.append("The query batch execution took too long: ").append(l).append(" milliseconds.\n");
            }
            if (bl2) {
                stringBuilder2.append(stringBuilder.toString());
            }
            stringBuilder2.append("\nThe queries in the batch sent to the Data Service are:\n").append(Utils.renderQuerySpecs(querySpecArray));
            _logger.warn(stringBuilder2.toString());
        }
    }

    public static void logQSpecsIfMaxResultCountIsWrong(QuerySpec[] querySpecArray) {
        if (_logger.isDebugEnabled()) {
            Vector<QuerySpec> vector = new Vector<QuerySpec>();
            for (QuerySpec querySpec : querySpecArray) {
                ResultSpec resultSpec;
                if (querySpec == null || (resultSpec = querySpec.resultSpec) != null && resultSpec.maxResultCount != null && resultSpec.maxResultCount >= 0 && resultSpec.maxResultCount <= 1000) continue;
                vector.add(querySpec);
            }
            if (!vector.isEmpty()) {
                _logger.debug("ResultSpec.maxResultCount is wrong.\nThe following are names of QuerySpecs that do not specify maxResultCount or it is above 1000:\n" + Utils.getQueryNames(vector));
            }
        }
    }

    private static StringBuilder logDataProviderDetails(DataAdaptersExecutionResult dataAdaptersExecutionResult) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dataAdaptersExecutionResult == null) {
            return stringBuilder;
        }
        if (dataAdaptersExecutionResult.getAdaptersExecutionDetails() != null) {
            for (DataAdapterExecutionDetails dataAdapterExecutionDetails : dataAdaptersExecutionResult.getAdaptersExecutionDetails()) {
                long l;
                if (dataAdapterExecutionDetails == null || (l = dataAdapterExecutionDetails.getElapsedTime()) <= Config.DATA_PROVIDER_ADAPTER_TIME_THRESHOLD) continue;
                stringBuilder.append("\nA ").append(DataProviderAdapter.class.getSimpleName()).append(" (").append(dataAdapterExecutionDetails.getDataAdapterInfo()).append(")").append(" execution took too long: ").append(l).append(" milliseconds.").append("\nInvocation id: ").append(dataAdapterExecutionDetails.getInvocationId()).append("\nQuery names: ").append(Utils.getQueryNames(dataAdapterExecutionDetails.getQuerySpecs())).append('\n');
            }
        }
        return stringBuilder;
    }

    private static StringBuilder logPropertyProviderDetails(PropertyProvidersExecutionResult propertyProvidersExecutionResult) {
        long l;
        StringBuilder stringBuilder = new StringBuilder();
        if (propertyProvidersExecutionResult == null) {
            return stringBuilder;
        }
        if (propertyProvidersExecutionResult.getPropertyProvidersExecDetails() != null) {
            for (PropertyProviderExecutionDetails object : propertyProvidersExecutionResult.getPropertyProvidersExecDetails()) {
                if (object == null || (l = object.getElapsedTime()) <= Config.PROPERTY_PROVIDER_ADAPTER_TIME_THRESHOLD) continue;
                if (object instanceof DerivedPropertyProviderExecutionDetails) {
                    stringBuilder.append("\nA ").append(DerivedPropertyProviderAdapter.class.getSimpleName()).append(" (").append(object.getPropertyProvider()).append(")").append(" execution took too long: ").append(l).append(" milliseconds.").append("\nInvocation id: ").append(object.getInvocationId()).append("\nQuery name: ").append(object.getQuerySpec().name).append("\nThe derived properties processed: ").append(Arrays.toString(object.getPropertySpecs())).append("\nTo compute the derived properties requested properties: ").append(Arrays.toString(((DerivedPropertyProviderExecutionDetails)object).getSourcePropertyNamesByType().entrySet().toArray())).append('\n');
                    continue;
                }
                stringBuilder.append("\nA ").append(PropertyProviderAdapter.class.getSimpleName()).append(" (").append(Utils.renderPropertyProvider(object.getPropertyProvider())).append(")").append(" execution took too long: ").append(l).append(" milliseconds.").append("\nInvocation id: ").append(object.getInvocationId()).append("\nQuery name: ").append(object.getQuerySpec().name).append("\nThe properties processed: ").append(Arrays.toString(object.getPropertySpecs())).append('\n');
            }
        }
        if (propertyProvidersExecutionResult.getDynamicAdaptersExecDetails() != null) {
            for (DataAdapterExecutionDetails dataAdapterExecutionDetails : propertyProvidersExecutionResult.getDynamicAdaptersExecDetails()) {
                if (dataAdapterExecutionDetails == null || (l = dataAdapterExecutionDetails.getElapsedTime()) <= Config.DATA_PROVIDER_ADAPTER_TIME_THRESHOLD) continue;
                stringBuilder.append("\nA dynamic adapter ").append(DataProviderAdapter.class.getSimpleName()).append(" (").append(dataAdapterExecutionDetails.getDataAdapterInfo()).append(")").append(" execution took too long: ").append(l).append(" milliseconds. The dynamic adapter was executed after").append(" the property providers to provide the properties that").append(" were not covered by the property providers.").append("\nInvocation id: ").append(dataAdapterExecutionDetails.getInvocationId()).append("\nQuery names: ").append(Utils.getQueryNames(dataAdapterExecutionDetails.getQuerySpecs())).append('\n');
            }
        }
        return stringBuilder;
    }
}

