/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.internal.profiling;

import com.vmware.cis.data.internal.provider.profiler.QueryIdLogConfigurator;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.QueryOption;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.OpIdUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.MDC;

public final class ViseDsLogConfigurator {
    private static final String SEPARATOR = ":";
    private static final String PROVIDER_INVOCATION_ID_KEY = "viseProvider";
    private static final String VISE_BATCH_INVOCATION_ID_PREFIX = "vb-";
    private static final AtomicLong PROVIDER_INVOCATION_ID_GENERATOR = new AtomicLong(0L);

    public static ViseDsLogContext onBatchStart() {
        final QueryIdLogConfigurator queryIdLogConfigurator = QueryIdLogConfigurator.onQueryStart((String)"", (String)VISE_BATCH_INVOCATION_ID_PREFIX);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                queryIdLogConfigurator.close();
            }

            @Override
            public String getInvocationId() {
                return QueryMarker.getQueryId();
            }

            @Override
            public String getPreviousInvocationId() {
                return QueryMarker.getParentQueryId();
            }
        };
    }

    public static ViseDsLogContext onQueryStart(QuerySpec querySpec) {
        final String string = QueryMarker.getQueryId();
        String string2 = ViseDsLogConfigurator.isQueryFromQueryService(querySpec.options) ? string : string + SEPARATOR + querySpec.name;
        QueryMarker.setQueryId((String)string2);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                QueryMarker.setQueryId((String)string);
            }

            @Override
            public String getInvocationId() {
                return QueryMarker.getQueryId();
            }

            @Override
            public String getPreviousInvocationId() {
                return QueryMarker.getParentQueryId();
            }
        };
    }

    public static ViseDsLogContext onDataAdapterStart(DataProviderAdapter dataProviderAdapter) {
        assert (dataProviderAdapter != null);
        String string = QueryMarker.getQueryId();
        String string2 = dataProviderAdapter.getClass().getSimpleName();
        String string3 = QueryMarker.getQueryControl();
        String string4 = dataProviderAdapter instanceof DynamicProviderAdapter ? string3 : "external";
        return ViseDsLogConfigurator.onProviderInvocation(string, string2, string4);
    }

    public static ViseDsLogContext onPropertyProviderStart(QuerySpec querySpec, PropertyProviderAdapter propertyProviderAdapter) {
        assert (querySpec != null);
        assert (querySpec.name != null);
        assert (propertyProviderAdapter != null);
        String string = QueryMarker.getQueryId();
        String string2 = Utils.renderPropertyProvider(propertyProviderAdapter, false);
        String string3 = ViseDsLogConfigurator.isQueryFromQueryService(querySpec.options) ? string : string + SEPARATOR + querySpec.name;
        return ViseDsLogConfigurator.onProviderInvocation(string3, string2, "external");
    }

    private static ViseDsLogContext onProviderInvocation(String string, String string2, String string3) {
        final String string4 = QueryMarker.getQueryId();
        final String string5 = OpIdUtil.getCustomOpIdPrefix();
        final String string6 = ViseDsLogConfigurator.getProviderInvocation();
        String string7 = string + SEPARATOR + string2;
        final String string8 = ViseDsLogConfigurator.nextProviderInvocation(string7);
        QueryMarker.setQueryId((String)string);
        OpIdUtil.setCustomOpIdPrefix((String)string8);
        ViseDsLogConfigurator.setProviderInvocation(string8);
        final QueryIdLogConfigurator queryIdLogConfigurator = QueryIdLogConfigurator.onProviderStart((String)string3, (String)string2);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                OpIdUtil.setCustomOpIdPrefix((String)string5);
                ViseDsLogConfigurator.setProviderInvocation(string6);
                queryIdLogConfigurator.close();
                QueryMarker.setQueryId((String)string4);
            }

            @Override
            public String getInvocationId() {
                return string8;
            }

            @Override
            public String getPreviousInvocationId() {
                return string6;
            }
        };
    }

    private static void setProviderInvocation(String string) {
        MDC.put((String)PROVIDER_INVOCATION_ID_KEY, (String)string);
    }

    public static String getProviderInvocation() {
        return MDC.get((String)PROVIDER_INVOCATION_ID_KEY);
    }

    private static String nextProviderInvocation(String string) {
        String string2 = Long.toString(PROVIDER_INVOCATION_ID_GENERATOR.incrementAndGet());
        return string + SEPARATOR + string2;
    }

    private static boolean isQueryFromQueryService(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        Object object = map.get(QueryOption.VISE_TO_RISE_TRANSLATOR_STRICT_MODE.name());
        return Boolean.TRUE.equals(object);
    }

    public static interface ViseDsLogContext
    extends AutoCloseable {
        public String getInvocationId();

        public String getPreviousInvocationId();

        @Override
        public void close();
    }
}

