/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.metadata.QuantityTypes;

public enum Units {
    DATE(-1L, QuantityTypes.DATE),
    TIME(-1L, QuantityTypes.DATE),
    DATETIME(-1L, QuantityTypes.DATE),
    MILLISECONDS(1L, QuantityTypes.TIME_SPAN),
    SECONDS(1000L, QuantityTypes.TIME_SPAN),
    MINUTES(60000L, QuantityTypes.TIME_SPAN),
    HOURS(3600000L, QuantityTypes.TIME_SPAN),
    DAYS(86400000L, QuantityTypes.TIME_SPAN),
    BYTE(1L, QuantityTypes.DATA_SIZE),
    KB(1024L, QuantityTypes.DATA_SIZE),
    MB(0x100000L, QuantityTypes.DATA_SIZE),
    GB(0x40000000L, QuantityTypes.DATA_SIZE),
    TB(0x10000000000L, QuantityTypes.DATA_SIZE),
    HZ(1L, QuantityTypes.FREQUENCY),
    KHZ(1000L, QuantityTypes.FREQUENCY),
    MHZ(1000000L, QuantityTypes.FREQUENCY),
    GHZ(1000000000L, QuantityTypes.FREQUENCY),
    BPS(1L, QuantityTypes.BIT_RATE),
    KBPS(1000L, QuantityTypes.BIT_RATE),
    MBPS(1000000L, QuantityTypes.BIT_RATE),
    GBPS(1000000000L, QuantityTypes.BIT_RATE),
    AUTO(-1L, QuantityTypes.ANY);

    private final long _baseMultiplier;
    private final QuantityTypes _type;

    private Units(long l, QuantityTypes quantityTypes) {
        this._baseMultiplier = l;
        this._type = quantityTypes;
    }

    public long getBaseMultiplier() {
        return this._baseMultiplier;
    }

    public QuantityTypes getType() {
        return this._type;
    }
}

