/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.impl;

import com.vmware.vsphere.client.telemetry.ITelemetryLogger;
import com.vmware.vsphere.client.telemetry.TelemetryLoggingService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelemetryLoggingServiceImpl
implements TelemetryLoggingService {
    private static final Log _logger = LogFactory.getLog(TelemetryLoggingServiceImpl.class);
    private final ITelemetryLogger _telemetryLogger;

    public TelemetryLoggingServiceImpl(ITelemetryLogger iTelemetryLogger) {
        this._telemetryLogger = iTelemetryLogger;
    }

    @Override
    public boolean isEnabled() {
        return this._telemetryLogger.isCeipEnabled();
    }

    @Override
    public void logTelemetry(Map<String, Object>[] mapArray) {
        if (mapArray == null) {
            _logger.debug((Object)"Null data has been recieved and will not be logged!");
            return;
        }
        for (Map<String, Object> map : mapArray) {
            this._telemetryLogger.logTelemetryData(map);
        }
    }
}

